/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.launching;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.devices.DeviceSelector;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DeviceTab
extends AbstractLaunchConfigurationTab {
    private static final Object[] NO_ELEMENTS = new Object[0];
    private DeviceSelector deviceSelector;
    private Text extraParameters;
    private IJavaProject javaProject;
    private Button projectDeviceButton;
    private ComboViewer securityDomainViewer;
    private Button specificDeviceButton;

    public void activated(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        IJavaProject iJavaProject = this.getJavaProjectFrom((ILaunchConfiguration)iLaunchConfigurationWorkingCopy);
        if (iJavaProject != null || this.javaProject != null) {
            boolean bl;
            boolean bl2 = bl = iJavaProject == null && this.javaProject != null || iJavaProject != null && this.javaProject == null || !iJavaProject.equals(this.javaProject);
            if (bl) {
                this.javaProject = iJavaProject;
                this.initializeDeviceFrom((ILaunchConfiguration)iLaunchConfigurationWorkingCopy);
            }
        }
    }

    public void createControl(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 32);
        group.setText(MTJUIMessages.DeviceTab_device_group_label_text);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        this.projectDeviceButton = new Button((Composite)group, 16);
        new Label((Composite)group, 0).setText(MTJUIMessages.DeviceTab_projectDeviceButton_radio_label_text);
        this.specificDeviceButton = new Button((Composite)group, 16);
        new Label((Composite)group, 0).setText(MTJUIMessages.DeviceTab_specificDeviceButton_radio_label_text);
        this.deviceSelector = new DeviceSelector();
        this.deviceSelector.createContents((Composite)group, false, true);
        Label label = new Label(composite2, 0);
        label.setText(MTJUIMessages.DeviceTab_securityDomain_label_text);
        label.setFont(font);
        this.securityDomainViewer = new ComboViewer(composite2, 12);
        this.securityDomainViewer.setContentProvider((IContentProvider)new SecurityDomainContentProvider());
        this.securityDomainViewer.getCombo().setFont(font);
        this.securityDomainViewer.getCombo().setLayoutData((Object)new GridData(768));
        this.securityDomainViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object object) {
                return (String)object;
            }
        });
        this.securityDomainViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                DeviceTab.this.updateLaunchConfigurationDialog();
            }
        });
        Label label2 = new Label(composite2, 0);
        label2.setText(MTJUIMessages.DeviceTab_extraParams_label_text);
        label2.setFont(font);
        this.extraParameters = new Text(composite2, 2048);
        this.extraParameters.setLayoutData((Object)new GridData(768));
        this.extraParameters.setTextLimit(200);
        this.extraParameters.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                DeviceTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.projectDeviceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeviceTab.this.deviceSelector.setEnabled(DeviceTab.this.specificDeviceButton.getSelection());
                DeviceTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.specificDeviceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeviceTab.this.deviceSelector.setEnabled(DeviceTab.this.specificDeviceButton.getSelection());
                DeviceTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.deviceSelector.setSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                DeviceTab.this.securityDomainViewer.setInput((Object)DeviceTab.this.deviceSelector.getSelectedDevice());
                DeviceTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public Image getImage() {
        return MTJUIPluginImages.DESC_CELLPHONE_OBJ.createImage();
    }

    public String getName() {
        return MTJUIMessages.DeviceTab_name;
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        this.javaProject = this.getJavaProjectFrom(iLaunchConfiguration);
        this.initializeDeviceFrom(iLaunchConfiguration);
        this.securityDomainViewer.setInput((Object)this.getSelectedDevice());
        String string = this.getStringOrDefault(iLaunchConfiguration, "mtj.security_domain", "None");
        this.securityDomainViewer.setSelection((ISelection)new StructuredSelection((Object)string), true);
        String string2 = this.getStringOrDefault(iLaunchConfiguration, "mtj.launch_params", "");
        this.extraParameters.setText(string2);
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        this.setErrorMessage(null);
        this.setMessage(null);
        boolean bl = true;
        if (this.getSelectedDevice() == null) {
            this.setErrorMessage(MTJUIMessages.DeviceTab_error_no_device_selected);
            bl = false;
        }
        return bl;
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        IDevice iDevice;
        iLaunchConfigurationWorkingCopy.setAttribute("mtj.use_project_device", this.projectDeviceButton.getSelection());
        if (this.specificDeviceButton.getSelection()) {
            iDevice = this.deviceSelector.getSelectedDevice();
            String string = iDevice == null ? null : iDevice.getSDKName();
            String string2 = iDevice == null ? null : iDevice.getName();
            iLaunchConfigurationWorkingCopy.setAttribute("mtj.emulated_device_group", string);
            iLaunchConfigurationWorkingCopy.setAttribute("mtj.emulated_device", string2);
        }
        iDevice = (IStructuredSelection)this.securityDomainViewer.getSelection();
        iLaunchConfigurationWorkingCopy.setAttribute("mtj.security_domain", (String)iDevice.getFirstElement());
        iLaunchConfigurationWorkingCopy.setAttribute("mtj.launch_params", this.extraParameters.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute("mtj.use_project_device", true);
        iLaunchConfigurationWorkingCopy.setAttribute("mtj.emulated_device_group", "");
        iLaunchConfigurationWorkingCopy.setAttribute("mtj.emulated_device", "");
        iLaunchConfigurationWorkingCopy.setAttribute("mtj.security_domain", "None");
        iLaunchConfigurationWorkingCopy.setAttribute("mtj.launch_params", "");
    }

    private IJavaProject getJavaProjectFrom(ILaunchConfiguration iLaunchConfiguration) {
        IProject iProject;
        IJavaProject iJavaProject = null;
        String string = "";
        try {
            string = iLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        catch (CoreException coreException) {
            MTJCore.log((int)2, (String)MTJUIMessages.DeviceTab_error_updating_project_field, (Throwable)coreException);
        }
        if (string.trim().length() > 1 && (iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string)) != null && iProject.exists() && iProject.isOpen()) {
            iJavaProject = JavaCore.create((IProject)iProject);
        }
        return iJavaProject;
    }

    private IDevice getProjectDevice() {
        IDevice iDevice = null;
        if (this.javaProject != null) {
            IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)this.javaProject);
            iDevice = iMidletSuiteProject.getMTJRuntime().getActiveMTJRuntime().getDevice();
        }
        return iDevice;
    }

    private IMIDPDevice getSelectedDevice() {
        IMIDPDevice iMIDPDevice = null;
        iMIDPDevice = this.projectDeviceButton.getSelection() ? (IMIDPDevice)this.getProjectDevice() : (IMIDPDevice)this.deviceSelector.getSelectedDevice();
        return iMIDPDevice;
    }

    private String getStringOrDefault(ILaunchConfiguration iLaunchConfiguration, String string, String string2) {
        String string3 = null;
        try {
            string3 = iLaunchConfiguration.getAttribute(string, string2);
        }
        catch (CoreException coreException) {
            MTJCore.log((int)2, (Throwable)coreException);
            string3 = string2;
        }
        return string3;
    }

    private void initializeDeviceFrom(ILaunchConfiguration iLaunchConfiguration) {
        boolean bl = true;
        try {
            bl = iLaunchConfiguration.getAttribute("mtj.use_project_device", true);
        }
        catch (CoreException coreException) {
            MTJCore.log((int)2, (String)MTJUIMessages.DeviceTab_error_initializePlatformDefinitionFrom, (Throwable)coreException);
        }
        this.projectDeviceButton.setSelection(bl);
        this.deviceSelector.setEnabled(!bl);
        this.specificDeviceButton.setSelection(!bl);
        IDevice iDevice = null;
        if (bl) {
            iDevice = this.getProjectDevice();
        } else {
            String string = this.getStringOrDefault(iLaunchConfiguration, "mtj.emulated_device_group", "");
            String string2 = this.getStringOrDefault(iLaunchConfiguration, "mtj.emulated_device", "");
            try {
                iDevice = MTJCore.getDeviceRegistry().getDevice(string, string2);
            }
            catch (PersistenceException persistenceException) {
                MTJCore.log((int)2, (String)MTJUIMessages.DeviceTab_error_retrieving_devices, (Throwable)persistenceException);
            }
        }
        this.deviceSelector.setSelectedDevice(iDevice);
    }

    private class SecurityDomainContentProvider
    implements IStructuredContentProvider {
        private SecurityDomainContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            IMIDPDevice iMIDPDevice = (IMIDPDevice)object;
            Object[] objectArray = iMIDPDevice.getProtectionDomains();
            if (objectArray == null) {
                objectArray = NO_ELEMENTS;
            }
            return objectArray;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }
}

