/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.launching;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.launching.StackTraceEntry;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class MTJConsoleHyperLink
implements IHyperlink {
    private StackTraceEntry stackEntry;

    public MTJConsoleHyperLink(StackTraceEntry stackTraceEntry) {
        this.stackEntry = stackTraceEntry;
    }

    public void linkActivated() {
        File file = this.stackEntry.getJavaFile();
        int n = this.stackEntry.getLine() - 1;
        if (file != null) {
            try {
                IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorDescriptor iEditorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
                IFile[] iFileArray = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(file.getAbsolutePath()));
                IEditorPart iEditorPart = iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFileArray[0]), iEditorDescriptor.getId());
                ITextEditor iTextEditor = (ITextEditor)iEditorPart.getAdapter(ITextEditor.class);
                IDocument iDocument = iTextEditor.getDocumentProvider().getDocument((Object)iTextEditor.getEditorInput());
                iTextEditor.selectAndReveal(iDocument.getLineOffset(n), iDocument.getLineLength(n) - 1);
            }
            catch (PartInitException partInitException) {
                MTJCore.log((int)4, (String)partInitException.getMessage(), (Throwable)partInitException);
            }
            catch (BadLocationException badLocationException) {
                MTJCore.log((int)4, (String)badLocationException.getMessage(), (Throwable)badLocationException);
            }
        }
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }
}

