/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preprocess.contentAssistant;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.AntennaPPDirectiveProvider;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.AntennaPPPrefixHandler;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.IPreprocessContentAssistModel;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.IPreprocessDirectiveProvider;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.IPreprocessPrefixHandler;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessDebugLevel;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessDirective;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.PreprocessSymbol;
import org.eclipse.mtj.internal.ui.preprocess.contentAssistant.ProposalType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreprocessContext {
    private static final IPreprocessPrefixHandler DEFAULT_PREFIX_HANDLER = new AntennaPPPrefixHandler();
    private static final IPreprocessDirectiveProvider DEFAULT_DIRECTIVE_PROVIDER = new AntennaPPDirectiveProvider();
    public static final char COMMON_SEPARATOR = ' ';
    private static final int STATAMENT_DIRECTIVE_UNCOMPLETE = 0;
    private static final int STATAMENT_DIRECTIVE_COMPLETE = 1;
    private IPreprocessPrefixHandler prefixHandler = DEFAULT_PREFIX_HANDLER;
    private IPreprocessDirectiveProvider directiveProvider = DEFAULT_DIRECTIVE_PROVIDER;
    private IDocument document;
    private int fOffset;
    private IProject containedProject;
    private boolean validEnv = false;
    private int fLineStartOffset = -1;
    private int fStatementStartOffset = -1;
    private int fCompletionOffset = -1;
    private int currStatementState;

    public PreprocessContext(IDocument iDocument, int n, IProject iProject) {
        this.document = iDocument;
        this.fOffset = n;
        this.containedProject = iProject;
        this.initialize();
    }

    public boolean accept(PreprocessDebugLevel preprocessDebugLevel) {
        return this.prefixMatch(preprocessDebugLevel);
    }

    public boolean accept(PreprocessDirective preprocessDirective) {
        if (!this.prefixMatch(preprocessDirective)) {
            return false;
        }
        return this.sytaxAcceptable(preprocessDirective);
    }

    public boolean accept(PreprocessSymbol preprocessSymbol) {
        return this.prefixMatch(preprocessSymbol);
    }

    private boolean sytaxAcceptable(PreprocessDirective preprocessDirective) {
        if (preprocessDirective.getName().equalsIgnoreCase("condition")) {
            try {
                int n = this.document.getLineOfOffset(this.fOffset);
                if (n != 0) {
                    return false;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return true;
    }

    public int getCompletionOffset() {
        if (this.fCompletionOffset == -1) {
            if (this.currStatementState == 0) {
                this.fCompletionOffset = this.getStatementStartOffset();
            } else if (this.currStatementState == 1) {
                this.fCompletionOffset = this.getWordBeginingPos(' ');
            }
        }
        return this.fCompletionOffset;
    }

    public IProject getContainedProject() {
        return this.containedProject;
    }

    private String getCurrDirectiveName() {
        String string = this.getPreprocessStatement();
        String string2 = string.substring(0, string.indexOf(32));
        return string2;
    }

    public IPreprocessDirectiveProvider getDirectiveProvider() {
        return this.directiveProvider;
    }

    public IDocument getDocument() {
        return this.document;
    }

    private String getDocumentSegment(int n, int n2) {
        String string = "";
        try {
            string = this.document.get(n, n2);
        }
        catch (BadLocationException badLocationException) {}
        return string;
    }

    public int getLineStartOffset() {
        if (this.fLineStartOffset == -1) {
            try {
                int n = this.document.getLineOfOffset(this.fOffset);
                this.fLineStartOffset = this.document.getLineOffset(n);
            }
            catch (BadLocationException badLocationException) {
                this.fLineStartOffset = 0;
            }
        }
        return this.fLineStartOffset;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public List<ProposalType> getPossibleProposalTypes() {
        ArrayList<ProposalType> arrayList = new ArrayList<ProposalType>();
        if (!this.validEnv) {
            return arrayList;
        }
        if (this.currStatementState == 0) {
            arrayList.add(ProposalType.TEMPLATE);
            arrayList.add(ProposalType.DIRECTIVE);
            return arrayList;
        }
        if (this.currStatementState == 1 && this.hasLegalDirective()) {
            if (this.needSymbolProposal()) {
                arrayList.add(ProposalType.SYMBOL);
                return arrayList;
            }
            if (this.needDebugLevelProposal()) {
                arrayList.add(ProposalType.DEBUG_LEVER);
                return arrayList;
            }
        }
        return arrayList;
    }

    public String getPreprocessingLine() {
        int n = this.getLineStartOffset();
        int n2 = this.getOffset() - n;
        return this.getDocumentSegment(n, n2);
    }

    public String getPreprocessingLinePrefix() {
        return this.prefixHandler.getCurrPrefix(this.getPreprocessingLine());
    }

    public String getPreprocessStatement() {
        int n = this.getStatementStartOffset();
        int n2 = this.getOffset() - n;
        return this.getDocumentSegment(n, n2);
    }

    public int getStatementStartOffset() {
        if (this.fStatementStartOffset == -1) {
            this.fStatementStartOffset = this.getLineStartOffset() + this.getPreprocessingLinePrefix().length();
        }
        return this.fStatementStartOffset;
    }

    private String getUncompletedElementName() {
        int n = this.getCompletionOffset();
        String string = "";
        try {
            string = this.document.get(n, this.getOffset() - n);
        }
        catch (BadLocationException badLocationException) {}
        return string;
    }

    private int getWordBeginingPos(char c) {
        int n = this.getOffset();
        try {
            while (this.document.getChar(n) != c) {
                --n;
            }
        }
        catch (BadLocationException badLocationException) {}
        return n + 1;
    }

    private boolean hasLegalDirective() {
        return this.isLegalDirective(this.getCurrDirectiveName());
    }

    private void initialize() {
        String string;
        this.validEnv = this.validatePPEnvironment();
        if (this.validEnv && (string = this.getPreprocessStatement()).indexOf(32) >= 0) {
            this.currStatementState = 1;
        }
    }

    private boolean isInRightProject(IProject iProject) {
        boolean bl = false;
        try {
            bl = iProject.hasNature("org.eclipse.mtj.core.preprocessingNature");
        }
        catch (CoreException coreException) {
            MTJCore.log((int)2, (Throwable)coreException);
        }
        return bl;
    }

    private boolean isLegalDirective(String string) {
        if (this.getDirectiveProvider() != null) {
            return this.getDirectiveProvider().getDirective(string) != null;
        }
        return false;
    }

    private boolean needDebugLevelProposal() {
        String string = this.getCurrDirectiveName();
        return string.equalsIgnoreCase("debug") || string.equalsIgnoreCase("mdebug");
    }

    private boolean needSymbolProposal() {
        String string = this.getCurrDirectiveName();
        return !string.equalsIgnoreCase("else") && !string.equalsIgnoreCase("debug") && !string.equalsIgnoreCase("mdebug") && !string.equalsIgnoreCase("endif") && !string.equalsIgnoreCase("enddebug");
    }

    private boolean prefixMatch(IPreprocessContentAssistModel iPreprocessContentAssistModel) {
        String string = this.getUncompletedElementName();
        return iPreprocessContentAssistModel.getName().regionMatches(true, 0, string, 0, string.length());
    }

    public void setDirectiveProvider(IPreprocessDirectiveProvider iPreprocessDirectiveProvider) {
        this.directiveProvider = iPreprocessDirectiveProvider;
    }

    public void setPrefixHandler(IPreprocessPrefixHandler iPreprocessPrefixHandler) {
        this.prefixHandler = iPreprocessPrefixHandler;
    }

    private boolean validatePPEnvironment() {
        return this.isInRightProject(this.containedProject) && this.prefixHandler.hasLegalPrefix(this.getPreprocessingLine());
    }
}

