/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.importer.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ILeveledImportStructureProvider;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ProjectImporterMessage;
import org.eclipse.mtj.internal.ui.wizards.importer.common.TarEntry;
import org.eclipse.mtj.internal.ui.wizards.importer.common.TarException;
import org.eclipse.mtj.internal.ui.wizards.importer.common.TarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TarLeveledStructureProvider
implements ILeveledImportStructureProvider {
    private TarFile tarFile;
    private TarEntry root = new TarEntry("/");
    private Map<TarEntry, List<TarEntry>> children;
    private Map<IPath, TarEntry> directoryEntryCache = new HashMap<IPath, TarEntry>();
    private int stripLevel;

    public TarLeveledStructureProvider(TarFile tarFile) {
        this.tarFile = tarFile;
        this.root.setFileType(53);
    }

    protected TarEntry createContainer(IPath iPath) {
        TarEntry tarEntry = this.directoryEntryCache.get(iPath);
        if (tarEntry != null) {
            return tarEntry;
        }
        TarEntry tarEntry2 = iPath.segmentCount() == 1 ? this.root : this.createContainer(iPath.removeLastSegments(1));
        TarEntry tarEntry3 = new TarEntry(iPath.toString());
        tarEntry3.setFileType(53);
        this.directoryEntryCache.put(iPath, tarEntry3);
        ArrayList arrayList = new ArrayList();
        this.children.put(tarEntry3, arrayList);
        List<TarEntry> list = this.children.get(tarEntry2);
        list.add(tarEntry3);
        return tarEntry3;
    }

    protected void createFile(TarEntry tarEntry) {
        Path path = new Path(tarEntry.getName());
        TarEntry tarEntry2 = path.segmentCount() == 1 ? this.root : this.directoryEntryCache.get(path.removeLastSegments(1));
        List<TarEntry> list = this.children.get(tarEntry2);
        list.add(tarEntry);
    }

    public List<TarEntry> getChildren(Object object) {
        if (this.children == null) {
            this.initialize();
        }
        return this.children.get(object);
    }

    public InputStream getContents(Object object) {
        try {
            return this.tarFile.getInputStream((TarEntry)object);
        }
        catch (TarException tarException) {
            MTJCore.log((int)4, (String)tarException.getLocalizedMessage(), (Throwable)tarException);
            return null;
        }
        catch (IOException iOException) {
            MTJCore.log((int)4, (String)iOException.getLocalizedMessage(), (Throwable)iOException);
            return null;
        }
    }

    public ResourceAttributes getResourceAttributes(Object object) {
        ResourceAttributes resourceAttributes = new ResourceAttributes();
        TarEntry tarEntry = (TarEntry)object;
        resourceAttributes.setExecutable((tarEntry.getMode() & 0x40L) != 0L);
        resourceAttributes.setReadOnly((tarEntry.getMode() & 0x80L) == 0L);
        return resourceAttributes;
    }

    public String getFullPath(Object object) {
        return this.stripPath(((TarEntry)object).getName());
    }

    public String getLabel(Object object) {
        if (object.equals(this.root)) {
            return ((TarEntry)object).getName();
        }
        return this.stripPath(new Path(((TarEntry)object).getName()).lastSegment());
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    public TarFile getTarFile() {
        return this.tarFile;
    }

    @Override
    public boolean closeArchive() {
        try {
            this.getTarFile().close();
        }
        catch (IOException iOException) {
            MTJCore.log((int)2, (String)(String.valueOf(ProjectImporterMessage.ZipImport_couldNotClose) + this.getTarFile().getName()), (Throwable)iOException);
            return false;
        }
        return true;
    }

    protected void initialize() {
        this.children = new HashMap<TarEntry, List<TarEntry>>(1000);
        this.children.put(this.root, new ArrayList());
        Enumeration<TarEntry> enumeration = this.tarFile.entries();
        while (enumeration.hasMoreElements()) {
            TarEntry tarEntry = enumeration.nextElement();
            IPath iPath = new Path(tarEntry.getName()).addTrailingSeparator();
            if (tarEntry.getFileType() == 53) {
                this.createContainer(iPath);
                continue;
            }
            int n = iPath.segmentCount();
            if (n > 1) {
                this.createContainer(iPath.uptoSegment(n - 1));
            }
            this.createFile(tarEntry);
        }
    }

    public boolean isFolder(Object object) {
        return ((TarEntry)object).getFileType() == 53;
    }

    private String stripPath(String string) {
        String string2 = new String(string);
        int n = 0;
        while (n < this.stripLevel) {
            int n2 = string.indexOf(47);
            if (n2 == 0) {
                string = string.substring(1);
                n2 = string.indexOf(47);
            }
            if (n2 == -1) {
                return string2;
            }
            string = string.substring(n2);
            ++n;
        }
        return string;
    }

    @Override
    public void setStrip(int n) {
        this.stripLevel = n;
    }

    @Override
    public int getStrip() {
        return this.stripLevel;
    }
}

