/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.l10n;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.dialog.SrcFolderFilter;
import org.eclipse.mtj.internal.ui.util.FolderValidator;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class LocalizationBlock
implements MouseListener {
    private Composite composite;
    private Button dstFolderButton;
    private Text dstFolderText;
    private IJavaElement jPackage;
    private IJavaProject jProject;
    private IResource jSource;
    private Button pkgFolderButton;
    private Text pkgFolderText;
    private IWizardContainer wizard;

    public LocalizationBlock(IJavaProject iJavaProject, IWizardContainer iWizardContainer) {
        this.jProject = iJavaProject;
        this.wizard = iWizardContainer;
    }

    public Composite createMainComposite(Composite composite) {
        this.composite = new Composite(composite, 0);
        this.composite.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.composite.setLayout((Layout)gridLayout);
        Label label = new Label(this.composite, 0);
        label.setText(MTJUIMessages.LocalizationBlock_DestinationFolder);
        this.dstFolderText = new Text(this.composite, 2048);
        this.dstFolderText.setEnabled(false);
        this.dstFolderButton = new Button(this.composite, 0);
        this.dstFolderButton.setText(MTJUIMessages.LocalizationBlock_Browse);
        this.dstFolderButton.addMouseListener((MouseListener)this);
        Label label2 = new Label(this.composite, 0);
        label2.setText(MTJUIMessages.LocalizationBlock_PackageName);
        this.pkgFolderText = new Text(this.composite, 2048);
        this.pkgFolderText.setEnabled(false);
        this.pkgFolderButton = new Button(this.composite, 0);
        this.pkgFolderButton.setText(MTJUIMessages.LocalizationBlock_Browse);
        this.pkgFolderButton.addMouseListener((MouseListener)this);
        Dialog.applyDialogFont((Control)this.composite);
        int n = this.getWidgetTextWidth((Control)label, label.getText());
        int n2 = this.getWidgetTextWidth((Control)label2, label2.getText());
        GridData gridData = new GridData();
        gridData.widthHint = Math.max(n, n2);
        label.setLayoutData((Object)gridData);
        label2.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        this.dstFolderText.setLayoutData((Object)gridData);
        this.pkgFolderText.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.widthHint = this.getWidgetTextWidth((Control)this.dstFolderButton, this.dstFolderButton.getText()) + 20;
        this.dstFolderButton.setLayoutData((Object)gridData);
        this.pkgFolderButton.setLayoutData((Object)gridData);
        return this.composite;
    }

    public Composite getControl() {
        return this.composite;
    }

    public IResource getDestination() {
        return this.jSource;
    }

    public IJavaElement getPackage() {
        return this.jPackage;
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    public void mouseDown(MouseEvent mouseEvent) {
    }

    public void mouseUp(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.dstFolderButton) {
            this.selectDestinationFolder();
        } else if (mouseEvent.getSource() == this.pkgFolderButton) {
            this.selectPackageFolder();
        }
        this.wizard.updateButtons();
    }

    private int getWidgetTextWidth(Control control, String string) {
        GC gC = new GC((Drawable)control);
        gC.setFont(control.getFont());
        return gC.stringExtent((String)string).x;
    }

    private void selectDestinationFolder() {
        ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(this.dstFolderButton.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        elementTreeSelectionDialog.setValidator((ISelectionStatusValidator)new FolderValidator());
        elementTreeSelectionDialog.setAllowMultiple(false);
        elementTreeSelectionDialog.setTitle(MTJUIMessages.LocalizationBlock_DestinationFolderTitle);
        elementTreeSelectionDialog.setMessage(MTJUIMessages.LocalizationBlock_DestinationFolderMessage);
        try {
            elementTreeSelectionDialog.addFilter((ViewerFilter)new SrcFolderFilter(this.jProject.getProject(), Utils.getJavaProjectSourceDirectories((IJavaProject)this.jProject)));
        }
        catch (CoreException coreException) {
            MTJCore.log((int)4, (Throwable)coreException);
        }
        elementTreeSelectionDialog.setInput((Object)MTJUIPlugin.getWorkspace().getRoot());
        if (elementTreeSelectionDialog.open() == 0) {
            IResource iResource;
            this.jSource = iResource = (IResource)elementTreeSelectionDialog.getFirstResult();
            this.dstFolderText.setText(iResource.getProjectRelativePath().toString());
        }
    }

    private void selectPackageFolder() {
        try {
            Object[] objectArray;
            SelectionDialog selectionDialog = JavaUI.createPackageDialog((Shell)this.dstFolderButton.getShell(), (IJavaProject)this.jProject, (int)0);
            selectionDialog.setMessage(MTJUIMessages.LocalizationBlock_PackageDialogMessage);
            selectionDialog.setTitle(MTJUIMessages.LocalizationBlock_PackageDialogTitle);
            if (selectionDialog.open() == 0 && (objectArray = selectionDialog.getResult()).length > 0) {
                this.jPackage = (IPackageFragment)selectionDialog.getResult()[0];
                String string = "(Default Package)";
                if (this.jPackage.getElementName().equals("")) {
                    this.pkgFolderText.setText(string);
                } else {
                    this.pkgFolderText.setText(this.jPackage.getElementName());
                }
            }
        }
        catch (JavaModelException javaModelException) {
            MTJCore.log((int)4, (Throwable)javaModelException);
        }
    }
}

