/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.pulsar.ui.view;

import java.net.URI;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.console.ProvisioningHelper;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.ui.PlanAnalyzer;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvisioningOperationRunner;
import org.eclipse.equinox.internal.provisional.p2.ui.QueryableMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.PreselectedIUInstallWizard;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.PlannerResolutionOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mtj.internal.provisional.pulsar.core.IInstallerUI;
import org.eclipse.mtj.internal.provisional.pulsar.core.ISDK;
import org.eclipse.mtj.internal.pulsar.core.P2Utils;
import org.eclipse.mtj.internal.pulsar.core.SDK;
import org.eclipse.mtj.internal.pulsar.ui.view.Messages;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class P2InstallerUI
implements IInstallerUI {
    private static P2InstallerUI instance;

    private P2InstallerUI() {
    }

    public static IInstallerUI getInstance() {
        if (instance == null) {
            instance = new P2InstallerUI();
        }
        return instance;
    }

    public void runInstaller(final Shell shell, ISDK iSDK) throws CoreException {
        SDK sDK = (SDK)iSDK.getAdapter(SDK.class);
        IInstallableUnit iInstallableUnit = sDK.getInstallableUnit();
        InstallableUnitQuery installableUnitQuery = new InstallableUnitQuery(iInstallableUnit.getId(), iInstallableUnit.getVersion());
        Collector collector = ProvisioningHelper.getInstallableUnits((URI)this.getMetadataURI(sDK), (Query)installableUnitQuery, null);
        final InstallableUnit[] installableUnitArray = (InstallableUnit[])collector.toArray(InstallableUnit.class);
        IProfile iProfile = this.createProfile(shell, iSDK);
        if (iProfile == null) {
            return;
        }
        final URI uRI = sDK.getRepository().getArtifactsURI();
        ProvisioningHelper.addArtifactRepository((URI)uRI);
        ProfileChangeRequest profileChangeRequest = new ProfileChangeRequest(iProfile);
        profileChangeRequest.addInstallableUnits((IInstallableUnit[])installableUnitArray);
        final String string = iProfile.getProfileId();
        final PlannerResolutionOperation plannerResolutionOperation = new PlannerResolutionOperation(Messages.P2InstallerUI_ResoultionOperationLabel, string, profileChangeRequest, null, PlanAnalyzer.getProfileChangeAlteredStatus(), true);
        Job job = ProvisioningOperationRunner.schedule((ProvisioningOperation)plannerResolutionOperation, (int)2);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent iJobChangeEvent) {
                ProvisioningPlan provisioningPlan = plannerResolutionOperation.getProvisioningPlan();
                if (provisioningPlan != null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            Policy policy = P2InstallerUI.this.getPolicy();
                            PreselectedIUInstallWizard preselectedIUInstallWizard = new PreselectedIUInstallWizard(policy, string, (IInstallableUnit[])installableUnitArray, plannerResolutionOperation, new QueryableMetadataRepositoryManager(policy.getQueryContext(), false));
                            WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)preselectedIUInstallWizard);
                            wizardDialog.create();
                            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)wizardDialog.getShell(), "org.eclipse.equinox.p2.ui.install_wizard_context");
                            int n = wizardDialog.open();
                            if (n != 0) {
                                P2Utils.deleteProfile((String)string);
                            }
                            ProvisioningHelper.removeArtifactRepository((URI)uRI);
                        }
                    });
                }
            }
        });
    }

    private URI getMetadataURI(SDK sDK) {
        return sDK.getRepository().getMetadataURI();
    }

    private IProfile createProfile(Shell shell, ISDK iSDK) throws ProvisionException {
        IPath iPath = null;
        if (iSDK.getType().equals((Object)ISDK.EType.ZIP_ARCHIVE) && (iPath = this.getInstallFolderFromUser(shell, iSDK)) == null) {
            return null;
        }
        return P2Utils.createProfileForSDK((ISDK)iSDK, iPath);
    }

    private IPath getInstallFolderFromUser(Shell shell, ISDK iSDK) {
        DirectoryDialog directoryDialog = new DirectoryDialog(shell);
        directoryDialog.setMessage(MessageFormat.format(Messages.P2InstallerUI_DirerctoryDialogMessage, iSDK.getName()));
        String string = directoryDialog.open();
        if (string != null) {
            return new Path(string);
        }
        return null;
    }

    private Policy getPolicy() {
        return new Policy();
    }
}

