/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.pulsar.ui.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUIProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.StructuredViewerProvisioningListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeColumnViewerLabelProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mtj.internal.provisional.pulsar.core.ISDK;
import org.eclipse.mtj.internal.provisional.pulsar.core.ISDKRepository;
import org.eclipse.mtj.internal.provisional.pulsar.core.QuickInstallCore;
import org.eclipse.mtj.internal.pulsar.ui.view.InstallersLabelProvider;
import org.eclipse.mtj.internal.pulsar.ui.view.Messages;
import org.eclipse.mtj.internal.pulsar.ui.view.P2InstallerUI;
import org.eclipse.mtj.internal.pulsar.ui.view.StatusLabelProvider;
import org.eclipse.mtj.pulsar.core.Activator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDKInstallView
extends ViewPart {
    private TreeViewer viewer;
    private InstallAction installAction;
    private Action doubleClickAction;
    private StructuredViewerProvisioningListener listener;

    public void createPartControl(Composite composite) {
        this.viewer = new TreeViewer(composite, 768);
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.viewer, 16384);
        Display display = this.getViewSite().getShell().getDisplay();
        treeViewerColumn.setLabelProvider((CellLabelProvider)new TreeColumnViewerLabelProvider((IBaseLabelProvider)new InstallersLabelProvider((Device)display)));
        treeViewerColumn.getColumn().setText(Messages.SDKInstallView_InstallersColLabel);
        TreeViewerColumn treeViewerColumn2 = new TreeViewerColumn(this.viewer, 16384);
        treeViewerColumn2.setLabelProvider((CellLabelProvider)new StatusLabelProvider());
        treeViewerColumn2.getColumn().setText(Messages.SDKInstallView_StatusColLabel);
        this.viewer.setContentProvider((IContentProvider)new TreeNodeContentProvider());
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object object, Object object2) {
                return SDKInstallView.this.getTreeNodeDisplayName(object).compareToIgnoreCase(SDKInstallView.this.getTreeNodeDisplayName(object2));
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                SDKInstallView.this.installAction.selectionChanged(selectionChangedEvent);
            }
        });
        Job job = new Job(Messages.SDKInstallView_UpdatingInstallersJobTitle){

            public IStatus run(IProgressMonitor iProgressMonitor) {
                final TreeNode[] treeNodeArray = SDKInstallView.this.createTreeNodes(iProgressMonitor);
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        SDKInstallView.this.viewer.setInput((Object)treeNodeArray);
                        SDKInstallView.this.viewer.expandAll();
                        SDKInstallView.this.packColumns();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        this.makeActions();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.addProvisioningListener();
    }

    private TreeNode[] createTreeNodes(IProgressMonitor iProgressMonitor) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        Collection collection = QuickInstallCore.getInstance().getSDKRepositories();
        iProgressMonitor.beginTask("", collection.size());
        iProgressMonitor.subTask(Messages.SDKInstallView_GettingRepoInfoMessage);
        for (ISDKRepository iSDKRepository : collection) {
            arrayList.add(this.createRepositoryTreeNode(iSDKRepository, iProgressMonitor));
        }
        iProgressMonitor.done();
        return arrayList.toArray(new TreeNode[arrayList.size()]);
    }

    private TreeNode createRepositoryTreeNode(ISDKRepository iSDKRepository, IProgressMonitor iProgressMonitor) {
        String string;
        TreeNode treeNode = new TreeNode((Object)iSDKRepository);
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        Collection collection = iSDKRepository.getSDKs(iProgressMonitor);
        for (Object object : collection) {
            string = object.getCategory();
            if (string != null) {
                if (!linkedHashMap.containsKey(string)) {
                    linkedHashMap.put(string, new ArrayList());
                }
                ((Collection)linkedHashMap.get(string)).add(object);
                continue;
            }
            SDKInstallView.addNewTreeNode(arrayList, treeNode, object);
        }
        for (Object object : linkedHashMap.keySet()) {
            string = SDKInstallView.addNewTreeNode(arrayList, treeNode, object);
            Collection collection2 = (Collection)linkedHashMap.get(object);
            ArrayList<TreeNode> arrayList2 = new ArrayList<TreeNode>();
            for (ISDK iSDK : collection2) {
                SDKInstallView.addNewTreeNode(arrayList2, (TreeNode)string, iSDK);
            }
            string.setChildren(arrayList2.toArray(new TreeNode[arrayList2.size()]));
        }
        treeNode.setChildren(arrayList.toArray(new TreeNode[arrayList.size()]));
        iProgressMonitor.worked(1);
        return treeNode;
    }

    private static TreeNode addNewTreeNode(Collection<TreeNode> collection, TreeNode treeNode, Object object) {
        TreeNode treeNode2 = new TreeNode(object);
        treeNode2.setParent(treeNode);
        if (collection != null) {
            collection.add(treeNode2);
        }
        return treeNode2;
    }

    private String getTreeNodeDisplayName(Object object) {
        Object object2 = ((TreeNode)object).getValue();
        if (object2 instanceof ISDK) {
            return ((ISDK)object2).getName();
        }
        if (object2 instanceof String) {
            return (String)object2;
        }
        return "";
    }

    private void packColumns() {
        TreeColumn[] treeColumnArray;
        TreeColumn[] treeColumnArray2 = treeColumnArray = this.viewer.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn treeColumn = treeColumnArray2[n2];
            treeColumn.pack();
            ++n2;
        }
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
        this.fillLocalToolBar(iActionBars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.installAction);
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.installAction);
    }

    private void makeActions() {
        this.installAction = new InstallAction();
        this.installAction.setEnabled(this.getSelectedSDK() != null);
        this.doubleClickAction = new Action(){

            public void run() {
                SDKInstallView.this.installSelectedSDK();
            }
        };
    }

    private ISDK getSelectedSDK() {
        Object object;
        Object object2;
        ISelection iSelection = this.viewer.getSelection();
        if (!iSelection.isEmpty() && (object2 = ((IStructuredSelection)iSelection).getFirstElement()) instanceof TreeNode && (object = ((TreeNode)object2).getValue()) instanceof ISDK) {
            return (ISDK)object;
        }
        return null;
    }

    protected void installSelectedSDK() {
        ISDK iSDK = this.getSelectedSDK();
        if (iSDK != null) {
            try {
                QuickInstallCore.getInstance().installSDK(this.getSite().getShell(), iSDK, P2InstallerUI.getInstance());
            }
            catch (CoreException coreException) {
                Activator.logError((String)Messages.SDKInstallView_InstallError, (Throwable)coreException);
            }
        }
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                SDKInstallView.this.doubleClickAction.run();
            }
        });
    }

    private void addProvisioningListener() {
        this.listener = new StructuredViewerProvisioningListener((StructuredViewer)this.viewer, 4){

            protected void profileChanged(String string) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        SDKInstallView.this.viewer.refresh();
                    }
                });
            }
        };
        ProvUI.addProvisioningListener((ProvUIProvisioningListener)this.listener);
    }

    private void removeProvisioningListener() {
        ProvUI.removeProvisioningListener((ProvUIProvisioningListener)this.listener);
    }

    public void dispose() {
        this.removeProvisioningListener();
        super.dispose();
    }

    public void setFocus() {
    }

    private class InstallAction
    extends BaseSelectionListenerAction {
        protected InstallAction() {
            super(Messages.SDKInstallView_InstallActionLabel);
            this.setToolTipText(Messages.SDKInstallView_InstallActionToolTip);
            this.setImageDescriptor(ProvUIActivator.getDefault().getImageRegistry().getDescriptor("obj/profile_obj.gif"));
        }

        protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
            return SDKInstallView.this.getSelectedSDK() != null;
        }

        public void run() {
            SDKInstallView.this.installSelectedSDK();
        }
    }
}

