/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.pulsar.core;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.mtj.internal.provisional.pulsar.core.ISDKRepository;
import org.eclipse.mtj.internal.provisional.pulsar.core.ISDKRepositoryProvider;
import org.eclipse.mtj.internal.pulsar.core.Messages;
import org.eclipse.mtj.internal.pulsar.core.SDKRepository;
import org.eclipse.mtj.pulsar.core.Activator;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSDKRepositoryProvider
implements ISDKRepositoryProvider {
    private static final String NAME_KEY_SUFFIX = ".name";
    private static final String METADATA_KEY_SUFFIX = ".metadata";
    private static final String ARTIFACTS_KEY_SUFFIX = ".artifacts";
    private static final String IMAGE_KEY_SUFFIX = ".image";
    private URL repositoriesFileUrl;

    public DefaultSDKRepositoryProvider() {
        URL[] uRLArray = FileLocator.findEntries((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("repositories/repositories.properties"));
        this.repositoriesFileUrl = uRLArray[0];
    }

    @Override
    public Collection<ISDKRepository> getRepositories() {
        HashSet<ISDKRepository> hashSet = new HashSet<ISDKRepository>();
        try {
            Properties properties = new Properties();
            InputStream inputStream = this.repositoriesFileUrl.openStream();
            properties.load(inputStream);
            for (Object object : properties.keySet()) {
                String string = object.toString();
                if (!string.endsWith(NAME_KEY_SUFFIX)) continue;
                try {
                    String string2 = properties.getProperty(string);
                    String string3 = string.substring(0, string.lastIndexOf(NAME_KEY_SUFFIX));
                    URL uRL = new URL(properties.getProperty(String.valueOf(string3) + METADATA_KEY_SUFFIX));
                    URL uRL2 = new URL(properties.getProperty(String.valueOf(string3) + ARTIFACTS_KEY_SUFFIX));
                    SDKRepository sDKRepository = new SDKRepository(string2, uRL.toURI(), uRL2.toURI());
                    String string4 = properties.getProperty(String.valueOf(string3) + IMAGE_KEY_SUFFIX);
                    if (string4 != null) {
                        sDKRepository.setImageDescriptorURL(new URL(string4));
                    }
                    hashSet.add(sDKRepository);
                }
                catch (MalformedURLException malformedURLException) {
                    Activator.logError(Messages.DefaultSDKRepositoryProvider_URLError, malformedURLException);
                }
                catch (URISyntaxException uRISyntaxException) {
                    Activator.logError(Messages.DefaultSDKRepositoryProvider_URLError, uRISyntaxException);
                }
            }
        }
        catch (Exception exception) {
            Activator.logError(Messages.DefaultSDKRepositoryProvider_FileReadError, exception);
        }
        return hashSet;
    }
}

