/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.pulsar.core;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.console.ProvisioningHelper;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.MatchQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mtj.internal.provisional.pulsar.core.ISDK;
import org.eclipse.mtj.internal.provisional.pulsar.core.ISDKRepository;
import org.eclipse.mtj.internal.pulsar.core.SDK;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDKRepository
implements ISDKRepository {
    private URI metadataUri;
    private URI artifactsUri;
    private String name;
    private ImageDescriptor imageDescriptor;

    public SDKRepository(String string, URI uRI, URI uRI2) {
        this.name = string;
        this.metadataUri = uRI;
        this.artifactsUri = uRI2;
    }

    @Override
    public Collection<ISDK> getSDKs(IProgressMonitor iProgressMonitor) {
        ArrayList<ISDK> arrayList = new ArrayList<ISDK>();
        Collector collector = ProvisioningHelper.getInstallableUnits((URI)this.getMetadataURI(), (Query)this.getSDKQuery(), (IProgressMonitor)iProgressMonitor);
        for (IInstallableUnit iInstallableUnit : collector.toCollection()) {
            arrayList.add(new SDK(this, iInstallableUnit));
        }
        return arrayList;
    }

    private Query getSDKQuery() {
        return new MatchQuery(){

            public boolean isMatch(Object object) {
                if (object instanceof IInstallableUnit) {
                    IInstallableUnit iInstallableUnit = (IInstallableUnit)object;
                    return iInstallableUnit.getProperty("org.eclipse.pulsar.type") != null;
                }
                return false;
            }
        };
    }

    @Override
    public URI getMetadataURI() {
        return this.metadataUri;
    }

    @Override
    public URI getArtifactsURI() {
        return this.artifactsUri;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    public void setImageDescriptorURL(URL uRL) {
        this.imageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
    }
}

