/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.pulsar.core.action;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Util;
import org.eclipse.equinox.internal.p2.touchpoint.natives.actions.UnzipAction;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.mtj.internal.pulsar.core.Messages;
import org.eclipse.mtj.pulsar.core.Activator;

public class UnzipAndExecuteAction
extends UnzipAction {
    public static final String ACTION_UNZIPANDEXECUTE = "unzipAndExecute";
    private static final String PARM_EXECUTABLE = "executable";

    public IStatus execute(Map map) {
        IStatus iStatus = super.execute(map);
        if (!iStatus.isOK()) {
            return iStatus;
        }
        String string = (String)map.get(PARM_EXECUTABLE);
        if (string == null) {
            return Activator.makeErrorStatus(MessageFormat.format(Messages.ExecuteAction_ParamNotSetError, PARM_EXECUTABLE, ACTION_UNZIPANDEXECUTE), null);
        }
        IInstallableUnit iInstallableUnit = (IInstallableUnit)map.get("iu");
        IProfile iProfile = (IProfile)map.get("profile");
        String string2 = Util.getInstallFolder((IProfile)iProfile);
        if (string2 == null) {
            return Activator.makeErrorStatus("The profile did not have an install folder", null);
        }
        Path path = new Path(string2);
        path = path.append(string);
        string = path.toOSString();
        try {
            this.execute(string, iInstallableUnit);
        }
        catch (Exception exception) {
            return Activator.makeErrorStatus(MessageFormat.format(Messages.ExecuteAction_ExecuteError, string), exception);
        }
        return Status.OK_STATUS;
    }

    private void execute(String string, IInstallableUnit iInstallableUnit) throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder(string);
        Process process = processBuilder.start();
        process.waitFor();
    }

    public IStatus undo(Map map) {
        return Activator.makeErrorStatus(Messages.ExecuteAction_UndoUnsupportedError, null);
    }
}

