/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.pulsar.core;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.mtj.internal.provisional.pulsar.core.ISDKRepositoryProvider;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.mtj.pulsar.core";
    private static final String SDK_REPOSITORY_PROVIDER_EXTENSION = "org.eclipse.mtj.pulsar.core.sdkRepositoryProvider";
    private Collection<ISDKRepositoryProvider> providers;
    private static Activator plugin;

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
        super.stop(bundleContext);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public Collection<ISDKRepositoryProvider> getSDKRepositoryProviders() {
        if (this.providers == null) {
            this.readSDKRepositoryProviderExtensions();
        }
        return this.providers;
    }

    private void readSDKRepositoryProviderExtensions() {
        IConfigurationElement[] iConfigurationElementArray;
        this.providers = new ArrayList<ISDKRepositoryProvider>();
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(SDK_REPOSITORY_PROVIDER_EXTENSION);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
            try {
                Object object = iConfigurationElement.createExecutableExtension("class");
                this.providers.add((ISDKRepositoryProvider)object);
            }
            catch (Exception exception) {
                Activator.logError("Could not create extension", exception);
            }
            ++n2;
        }
    }

    public static IStatus makeErrorStatus(String string, Throwable throwable) {
        return new Status(4, PLUGIN_ID, string, throwable);
    }

    public static void logError(String string, Throwable throwable) {
        plugin.getLog().log(Activator.makeErrorStatus(string, throwable));
    }

    public static BundleContext getContext() {
        return plugin.getBundle().getBundleContext();
    }
}

