/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.project.midp;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.midp.ProjectConvertionException;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteProject;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.core.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTJProjectConverter {
    private static final String DEFAULT_PREFERENCES_DIRNAME = ".settings";
    private static final String EclipseME_JAVAME_CONTAINER = "J2MELIB";
    private static final String EclipseME_METADATA_ELEM_ROOT = "eclipsemeMetadata";
    private static final String EclipseME_METADATA_FILE = ".eclipseme";
    private static final String EclipseME_NATURE_PREFIX = "eclipseme.core.";
    private static final String EclipseME_PREFERENCE_STORE = "eclipseme.core.prefs";
    private static final String EcliseME_TEMP_FOLDER_NAME = ".eclipseme.tmp";
    private static final String FILENAME_PROJECT = ".project";
    private static final String MTJ_METADATA_ELEM_PASSWORDS = "passwords";
    private static final String MTJ_METADATA_ELEM_ROOT = "mtjMetadata";
    private static String oldJadFilePath;
    private static final String PREFS_FILE_EXTENSION = "prefs";
    private static MTJProjectConverter instance;

    static {
        instance = new MTJProjectConverter();
    }

    public static MTJProjectConverter getInstance() {
        return instance;
    }

    private MTJProjectConverter() {
    }

    public synchronized void convertEclipseMeProject(IProject iProject, IProgressMonitor iProgressMonitor) throws ProjectConvertionException {
        File file = null;
        File file2 = new File(iProject.getLocationURI());
        List<File> list = this.getChildrenFiles(file2);
        iProgressMonitor.beginTask(Messages.MTJProjectConverter_convert_taskname, 10);
        for (File file3 : list) {
            this.renameEclipseMETmpFolder(file3, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            this.renamePreferenceStoreFile(iProject, file3, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            this.modifyMetadata(iProject, file3, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            if (!file3.isFile() || !file3.getName().equals(FILENAME_PROJECT)) continue;
            file = file3;
        }
        this.renameProjectJAD(iProject);
        try {
            iProject.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            this.convertProject(iProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 3));
            this.recoverJADFileNameInMetadata(iProject);
            this.removeBuilderAndNature(file, iProgressMonitor);
            iProject.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            iProject.build(15, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            iProgressMonitor.done();
        }
        catch (CoreException coreException) {
            throw new ProjectConvertionException(coreException.getMessage(), coreException);
        }
    }

    public void convertJavaProject(IJavaProject iJavaProject, IMIDPDevice iMIDPDevice, IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException, JavaModelException {
        IProject iProject = iJavaProject.getProject();
        String string = MidletSuiteProject.getDefaultJadFileName(iProject);
        MidletSuiteFactory.getMidletSuiteCreationRunnable(iProject, iJavaProject, iMIDPDevice, string).run(iProgressMonitor);
        this.removeJ2SELibraries(iJavaProject, iProgressMonitor);
    }

    private void convertProject(IProject iProject, IProgressMonitor iProgressMonitor) throws ProjectConvertionException {
        IMIDPDevice iMIDPDevice = this.getDevice(iProject);
        this.deleteDeviceFromMetadata(iProject);
        if (iMIDPDevice == null) {
            throw new ProjectConvertionException(Messages.MTJProjectConverter_convertProject_device_unavailable);
        }
        try {
            IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
            MidletSuiteFactory.removeMidletSuiteProject(iJavaProject);
            this.removeJ2SEAndEclipseMELibraries(iJavaProject, iProgressMonitor);
            String string = MidletSuiteProject.getDefaultJadFileName(iProject);
            MidletSuiteFactory.getMidletSuiteCreationRunnable(iProject, iJavaProject, iMIDPDevice, string).run(iProgressMonitor);
        }
        catch (Exception exception) {
            throw new ProjectConvertionException(Messages.MTJProjectConverter_convertProject_convertion_error);
        }
    }

    private void deleteDeviceFromMetadata(IProject iProject) {
        IFile iFile = iProject.getFile(".mtj");
        try {
            Document document = XMLUtils.readDocument(iFile.getLocation().toFile());
            Element element = (Element)document.getElementsByTagName("device").item(0);
            element.getParentNode().removeChild(element);
            XMLUtils.writeDocument(iFile.getLocation().toFile(), document);
        }
        catch (Exception exception) {
            MTJLogger.log(4, exception);
        }
    }

    private List<File> getChildrenFiles(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (file.isDirectory()) {
            String[] stringArray;
            String[] stringArray2 = stringArray = file.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                arrayList.add(new File(file, string));
                ++n2;
            }
        }
        return arrayList;
    }

    private IMIDPDevice getDevice(IProject iProject) {
        IMIDPDevice iMIDPDevice = null;
        IFile iFile = iProject.getFile(".mtj");
        try {
            Document document = XMLUtils.readDocument(iFile.getLocation().toFile());
            Element element = (Element)document.getElementsByTagName("device").item(0);
            String string = element.getAttribute("group");
            String string2 = element.getAttribute("name");
            iMIDPDevice = (IMIDPDevice)MTJCore.getDeviceRegistry().getDevice(string, string2);
        }
        catch (Exception exception) {
            iMIDPDevice = null;
        }
        if (iMIDPDevice == null) {
            iMIDPDevice = (IMIDPDevice)MTJCore.getDeviceRegistry().getDefaultDevice();
        }
        return iMIDPDevice;
    }

    private IMidletSuiteProject getMidletSuiteProject(IProject iProject) {
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(iJavaProject);
        return iMidletSuiteProject;
    }

    private String getOldJadFilePath(File file, String string) {
        String string2 = null;
        try {
            Document document = XMLUtils.readDocument(file);
            Element element = document.getDocumentElement();
            string2 = element.getAttribute("jad");
            if (string2.length() == 0) {
                string2 = string;
            }
        }
        catch (Exception exception) {
            MTJLogger.log(4, exception);
        }
        return string2;
    }

    private boolean isEclipseMELibraryEntry(IClasspathEntry iClasspathEntry) {
        boolean bl = false;
        if (iClasspathEntry.getEntryKind() == 5 && iClasspathEntry.getPath().lastSegment().equals(EclipseME_JAVAME_CONTAINER)) {
            bl = true;
        }
        return bl;
    }

    private boolean isJ2SELibraryEntry(IClasspathEntry iClasspathEntry) {
        boolean bl = false;
        if (iClasspathEntry.getEntryKind() == 1) {
            if (iClasspathEntry.getPath().lastSegment().equals("JRE_LIB")) {
                bl = true;
            }
        } else if (iClasspathEntry.getEntryKind() == 5 && iClasspathEntry.getPath().lastSegment().equals("org.eclipse.jdt.launching.JRE_CONTAINER")) {
            bl = true;
        }
        return bl;
    }

    private void modifyMetadata(IProject iProject, File file, IProgressMonitor iProgressMonitor) {
        if (file.isFile() && file.getName().equals(EclipseME_METADATA_FILE)) {
            oldJadFilePath = this.getOldJadFilePath(file, MidletSuiteProject.getDefaultJadFileName(iProject));
            iProgressMonitor.beginTask(Messages.MTJProjectConverter_modifyMetadata_taskname, 2);
            Path path = new Path(file.getPath());
            File file2 = new File(path.removeLastSegments(1) + File.separator + ".mtj");
            file.renameTo(file2);
            iProgressMonitor.worked(1);
            try {
                Document document = XMLUtils.readDocument(file2);
                Element element = document.getDocumentElement();
                if (!element.getNodeName().equals(EclipseME_METADATA_ELEM_ROOT)) {
                    file2.delete();
                    return;
                }
                Element element2 = document.createElement(MTJ_METADATA_ELEM_ROOT);
                while (element.hasChildNodes()) {
                    element2.appendChild(element.getFirstChild());
                }
                document.replaceChild(element2, element);
                Element element3 = (Element)document.getElementsByTagName(MTJ_METADATA_ELEM_PASSWORDS).item(0);
                if (element3 != null) {
                    element3.getParentNode().removeChild(element3);
                }
                XMLUtils.writeDocument(file2, document);
            }
            catch (Exception exception) {
                MTJLogger.log(4, Messages.MTJProjectConverter_modifyMetadata_exception, exception);
                file2.delete();
            }
            iProgressMonitor.done();
        }
    }

    private void recoverJADFileNameInMetadata(IProject iProject) throws CoreException {
        String string;
        IMidletSuiteProject iMidletSuiteProject = this.getMidletSuiteProject(iProject);
        IFile iFile = iProject.getFile(oldJadFilePath);
        String string2 = iFile.getName();
        if (!string2.equals(string = iMidletSuiteProject.getJadFileName())) {
            iMidletSuiteProject.setJadFileName(string2);
            iMidletSuiteProject.saveMetaData();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void removeBuilderAndNature(File file, IProgressMonitor iProgressMonitor) {
        if (file.isFile() && file.getName().equals(FILENAME_PROJECT)) {
            iProgressMonitor.beginTask(Messages.MTJProjectConverter_removeBuilderAndNature_taskname, 2);
            try {
                Object object;
                Object object2;
                void node;
                Document document = XMLUtils.readDocument(file);
                NodeList nodeList = document.getElementsByTagName("name");
                ArrayList arrayList = new ArrayList();
                boolean n = false;
                while (node < nodeList.getLength()) {
                    object2 = nodeList.item((int)node);
                    if (object2.getTextContent().indexOf(EclipseME_NATURE_PREFIX) >= 0) {
                        arrayList.add(object2);
                    }
                    ++node;
                }
                for (Node nodeList2 : arrayList) {
                    Node n2 = nodeList2.getParentNode();
                    n2.getParentNode().removeChild(n2);
                }
                iProgressMonitor.worked(1);
                NodeList nodeList2 = document.getElementsByTagName("nature");
                object2 = new ArrayList<Object>();
                int node3 = 0;
                while (node3 < nodeList2.getLength()) {
                    object = nodeList2.item(node3);
                    if (object.getTextContent().indexOf(EclipseME_NATURE_PREFIX) >= 0) {
                        object2.add(object);
                    }
                    ++node3;
                }
                object = object2.iterator();
                while (object.hasNext()) {
                    Node node2 = (Node)object.next();
                    node2.getParentNode().removeChild(node2);
                }
                XMLUtils.writeDocument(file, document);
            }
            catch (Exception exception) {
                MTJLogger.log(4, ".project error", exception);
            }
            iProgressMonitor.done();
        }
    }

    private void removeJ2SEAndEclipseMELibraries(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException {
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
        ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>();
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            if (!this.isJ2SELibraryEntry(iClasspathEntryArray[n]) && !this.isEclipseMELibraryEntry(iClasspathEntryArray[n])) {
                arrayList.add(iClasspathEntryArray[n]);
            }
            ++n;
        }
        iClasspathEntryArray = arrayList.toArray(new IClasspathEntry[arrayList.size()]);
        iJavaProject.setRawClasspath(iClasspathEntryArray, iProgressMonitor);
    }

    private void removeJ2SELibraries(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException {
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
        ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>();
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            if (!this.isJ2SELibraryEntry(iClasspathEntryArray[n])) {
                arrayList.add(iClasspathEntryArray[n]);
            }
            ++n;
        }
        iClasspathEntryArray = arrayList.toArray(new IClasspathEntry[arrayList.size()]);
        iJavaProject.setRawClasspath(iClasspathEntryArray, iProgressMonitor);
    }

    private void renameEclipseMETmpFolder(File file, IProgressMonitor iProgressMonitor) {
        if (file.isDirectory() && file.getName().equals(EcliseME_TEMP_FOLDER_NAME)) {
            iProgressMonitor.beginTask(Messages.MTJProjectConverter_renameEclipseMETmpFolder_taskname, 1);
            Path path = new Path(file.getPath());
            IPath iPath = path.removeLastSegments(1).append(".mtj.tmp");
            File file2 = new File(iPath.toFile().getPath());
            file.renameTo(file2);
            iProgressMonitor.done();
        }
    }

    private void renamePreferenceStoreFile(IProject iProject, File file, IProgressMonitor iProgressMonitor) {
        if (file.isDirectory() && file.getName().equals(DEFAULT_PREFERENCES_DIRNAME)) {
            iProgressMonitor.beginTask(Messages.MTJProjectConverter_renamePreferenceStoreFile_taskname, 1);
            List<File> list = this.getChildrenFiles(file);
            for (File file2 : list) {
                if (!file2.getName().equals(EclipseME_PREFERENCE_STORE)) continue;
                ProjectScope projectScope = new ProjectScope(iProject);
                IEclipsePreferences iEclipsePreferences = projectScope.getNode("org.eclipse.mtj.core");
                Path path = new Path(file2.getPath());
                File file3 = new File(path.removeLastSegments(1) + File.separator + iEclipsePreferences.name() + "." + PREFS_FILE_EXTENSION);
                file2.renameTo(file3);
                break;
            }
            iProgressMonitor.done();
        }
    }

    private void renameProjectJAD(IProject iProject) {
        IFile iFile = iProject.getFile(oldJadFilePath);
        File file = iFile.getLocation().toFile();
        IMidletSuiteProject iMidletSuiteProject = this.getMidletSuiteProject(iProject);
        File file2 = iMidletSuiteProject.getApplicationDescriptorFile().getLocation().toFile();
        file.renameTo(file2);
    }
}

