/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.project.midp;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.preverifier.IPreverificationError;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.build.preverifier.PreverifierNotFoundException;
import org.eclipse.mtj.core.build.sign.ISignatureProperties;
import org.eclipse.mtj.core.project.IMTJProjectListener;
import org.eclipse.mtj.core.project.midp.IApplicationDescriptor;
import org.eclipse.mtj.core.project.midp.IMIDPMetaData;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProjectListener;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.build.BuildSpecManipulator;
import org.eclipse.mtj.internal.core.build.BuildStateMachine;
import org.eclipse.mtj.internal.core.build.sign.PreferencesSignatureProperties;
import org.eclipse.mtj.internal.core.project.midp.ApplicationDescriptor;
import org.eclipse.mtj.internal.core.project.midp.MetaData;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.osgi.util.NLS;

public final class MidletSuiteProject
implements IMidletSuiteProject {
    public static final String CLASSES_DIRECTORY = "classes";
    public static final String LIBS_DIRECTORY = "libs";
    private static final String APP_DESCRIPTOR_FILE_EXT = "jad";
    private static final String DEPLOYED_APP_FILE_EXT = "jar";
    private IJavaProject javaProject;
    private IMIDPMetaData metaData;
    private String tempKeyPassword;
    private String tempKeystorePassword;
    List<IMidletSuiteProjectListener> listenerList = new ArrayList<IMidletSuiteProjectListener>();

    public static String getDefaultJadFileName(IProject iProject) {
        String string = iProject.getName();
        return NLS.bind((String)"{0}.{1}", (Object[])new String[]{string.replace(' ', '_'), APP_DESCRIPTOR_FILE_EXT});
    }

    public MidletSuiteProject(IJavaProject iJavaProject) throws IllegalArgumentException {
        if (iJavaProject == null) {
            throw new IllegalArgumentException("A non-null IJavaProject must be passed to constructor.");
        }
        this.javaProject = iJavaProject;
        this.initializeMetadata();
        MTJRuntime mTJRuntime = this.getRuntimeList().getActiveMTJRuntime();
        if (mTJRuntime != null && mTJRuntime.getDevice() == null) {
            try {
                if (this.getProject().findMarkers("org.eclipse.mtj.core.device.missing", false, 0).length == 0) {
                    IMarker iMarker = this.getProject().createMarker("org.eclipse.mtj.core.device.missing");
                    iMarker.setAttribute("message", (Object)Messages.MidletSuiteProject_device_not_available);
                    iMarker.setAttribute("severity", 2);
                }
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
    }

    public void addMTJProjectListener(IMTJProjectListener iMTJProjectListener) {
        if (!this.listenerList.contains(iMTJProjectListener) && iMTJProjectListener instanceof IMidletSuiteProjectListener) {
            this.listenerList.add((IMidletSuiteProjectListener)iMTJProjectListener);
        }
    }

    public void createPackage(boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) throws CoreException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("_do_package", Boolean.TRUE.toString());
        hashMap.put("_do_obfuscation", Boolean.valueOf(bl).toString());
        hashMap.put("_update_version", Boolean.TRUE.toString());
        Utils.switchAutoBuild(false);
        BuildStateMachine buildStateMachine = BuildStateMachine.getInstance(this);
        buildStateMachine.start(iProgressMonitor);
        BuildSpecManipulator buildSpecManipulator = new BuildSpecManipulator(this.getProject());
        buildSpecManipulator.setBuilderArguments("org.eclipse.mtj.core.packageBuilder", hashMap);
        buildSpecManipulator.commitChanges(iProgressMonitor);
        this.getProject().build(6, iProgressMonitor);
        if (bl2) {
            this.createPackageForInactiveConfigs(hashMap, iProgressMonitor);
        }
        buildSpecManipulator.setBuilderArguments("org.eclipse.mtj.core.packageBuilder", new HashMap<String, String>());
        buildSpecManipulator.commitChanges(iProgressMonitor);
        Utils.switchAutoBuild(true);
        for (IMidletSuiteProjectListener iMidletSuiteProjectListener : this.listenerList) {
            iMidletSuiteProjectListener.packageCreated();
        }
    }

    public IApplicationDescriptor getApplicationDescriptor() {
        ApplicationDescriptor applicationDescriptor = null;
        IFile iFile = this.getApplicationDescriptorFile();
        iFile.exists();
        try {
            File file = iFile.getLocation().toFile();
            applicationDescriptor = new ApplicationDescriptor(file);
        }
        catch (IOException iOException) {
            MTJLogger.log(4, "getApplicationDescriptor", iOException);
        }
        return applicationDescriptor;
    }

    public IFile getApplicationDescriptorFile() {
        IFile iFile = null;
        IProject iProject = this.javaProject.getProject();
        iFile = iProject.getFile("Application Descriptor");
        return iFile;
    }

    public String getJadFileName() {
        return this.metaData.getJadFileName();
    }

    public String getJarFilename() {
        String string = null;
        String string2 = this.getApplicationDescriptor().getMIDletJarURL();
        if (string2 != null) {
            int n = string2.lastIndexOf(47);
            string = n != -1 ? string2.substring(n + 1) : string2;
        }
        if (string == null) {
            string = NLS.bind((String)"{0}.{1}", (Object[])new String[]{this.getProjectNameWithoutSpaces(), DEPLOYED_APP_FILE_EXT});
        }
        return string;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public IProject getProject() {
        return this.javaProject.getProject();
    }

    public MTJRuntimeList getRuntimeList() {
        return this.metaData.getRuntimeList();
    }

    public ISignatureProperties getSignatureProperties() throws CoreException {
        ISignatureProperties iSignatureProperties = this.metaData.getSignatureProperties();
        if (iSignatureProperties != null && !iSignatureProperties.isProjectSpecific()) {
            boolean bl = iSignatureProperties.isSignProject();
            String string = iSignatureProperties.getKeyAlias();
            iSignatureProperties = new PreferencesSignatureProperties();
            iSignatureProperties.setSignProject(bl);
            if (string != null && string.length() > 0) {
                iSignatureProperties.setKeyAlias(string);
            }
        }
        return iSignatureProperties;
    }

    public String getTempKeyPassword() {
        return this.tempKeyPassword;
    }

    public String getTempKeystorePassword() {
        return this.tempKeystorePassword;
    }

    public IFolder getVerifiedClassesOutputFolder(IProgressMonitor iProgressMonitor) {
        return this.getVerifiedOutputFolder(iProgressMonitor).getFolder(CLASSES_DIRECTORY);
    }

    public IFolder getVerifiedLibrariesOutputFolder(IProgressMonitor iProgressMonitor) {
        return this.getVerifiedOutputFolder(iProgressMonitor).getFolder(LIBS_DIRECTORY);
    }

    public IFolder getVerifiedOutputFolder(IProgressMonitor iProgressMonitor) {
        IFolder iFolder = this.getProject().getFolder(".mtj.tmp");
        return iFolder.getFolder("verified");
    }

    public boolean isPreprocessedProject() {
        IProject iProject = this.getProject();
        boolean bl = false;
        if (iProject.exists() && iProject.isOpen()) {
            try {
                bl = iProject.hasNature("org.eclipse.mtj.core.preprocessingNature");
            }
            catch (CoreException coreException) {}
        }
        return bl;
    }

    public IPreverificationError[] preverify(IResource[] iResourceArray, IFolder iFolder, IProgressMonitor iProgressMonitor) throws CoreException, PreverifierNotFoundException {
        return this.getPreverifier().preverify(this, iResourceArray, iFolder, iProgressMonitor);
    }

    public IPreverificationError[] preverifyJarFile(File file, IFolder iFolder, IProgressMonitor iProgressMonitor) throws CoreException, PreverifierNotFoundException {
        return this.getPreverifier().preverifyJarFile(this, file, iFolder, iProgressMonitor);
    }

    public void refreshClasspath(IProgressMonitor iProgressMonitor) throws CoreException {
        IDevice iDevice;
        MTJRuntime mTJRuntime = this.getRuntimeList().getActiveMTJRuntime();
        if (mTJRuntime != null && (iDevice = mTJRuntime.getDevice()) != null) {
            this.getProject().deleteMarkers("org.eclipse.mtj.core.device.missing", false, 0);
            this.changeJavaMEClasspathContainer(iDevice, iProgressMonitor);
            for (IMidletSuiteProjectListener iMidletSuiteProjectListener : this.listenerList) {
                iMidletSuiteProjectListener.classpathRefreshed();
            }
        }
    }

    public void removeMTJProjectListener(IMTJProjectListener iMTJProjectListener) {
        this.listenerList.remove(iMTJProjectListener);
    }

    public void saveMetaData() throws CoreException {
        this.metaData.saveMetaData();
        for (IMTJProjectListener iMTJProjectListener : this.listenerList) {
            iMTJProjectListener.metaDataSaved();
        }
    }

    public void setJadFileName(String string) {
        this.metaData.setJadFileName(string);
        for (IMTJProjectListener iMTJProjectListener : this.listenerList) {
            ((IMidletSuiteProjectListener)iMTJProjectListener).jadFileNameChanged();
        }
    }

    public void setSignatureProperties(ISignatureProperties iSignatureProperties) {
        this.metaData.setSignatureProperties(iSignatureProperties);
        for (IMTJProjectListener iMTJProjectListener : this.listenerList) {
            iMTJProjectListener.signaturePropertiesChanged();
        }
    }

    public void setTempKeyPassword(String string) {
        this.tempKeyPassword = string;
        for (IMidletSuiteProjectListener iMidletSuiteProjectListener : this.listenerList) {
            iMidletSuiteProjectListener.tempKeyPasswordChanged();
        }
    }

    public void setTempKeystorePassword(String string) {
        this.tempKeystorePassword = string;
        for (IMidletSuiteProjectListener iMidletSuiteProjectListener : this.listenerList) {
            iMidletSuiteProjectListener.tempKeystorePasswordChanged();
        }
    }

    private void addClasspathContainerIfMissing(IProgressMonitor iProgressMonitor) throws JavaModelException {
        boolean bl = this.containsJavaMEClasspathContainer(this.getJavaProject());
        boolean bl2 = this.isPreprocessedProject();
        if (!bl && !bl2) {
            IClasspathEntry[] iClasspathEntryArray;
            Object object;
            Path path = new Path("org.elipse.mtj.JavaMEContainer/" + this.getRuntimeList().getActiveMTJRuntime().getDevice());
            IClasspathEntry iClasspathEntry = JavaCore.newContainerEntry((IPath)path);
            IClasspathEntry[] iClasspathEntryArray2 = this.javaProject.getRawClasspath();
            LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>(iClasspathEntryArray2.length);
            IClasspathEntry[] iClasspathEntryArray3 = iClasspathEntryArray2;
            int n = iClasspathEntryArray2.length;
            int n2 = 0;
            while (n2 < n) {
                object = iClasspathEntryArray3[n2];
                if (object.getEntryKind() == 4) {
                    object = JavaCore.getResolvedClasspathEntry((IClasspathEntry)object);
                }
                linkedHashSet.add(object);
                ++n2;
            }
            object = this.getRuntimeList().getActiveMTJRuntime().getDevice().getClasspath().asClasspathEntries();
            IClasspathEntry[] iClasspathEntryArray4 = iClasspathEntryArray = object.toArray(new IClasspathEntry[object.size()]);
            int n3 = iClasspathEntryArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IClasspathEntry iClasspathEntry2 = iClasspathEntryArray4[n4];
                if (linkedHashSet.contains(iClasspathEntry2)) {
                    linkedHashSet.remove(iClasspathEntry2);
                }
                ++n4;
            }
            linkedHashSet.add(iClasspathEntry);
            IClasspathEntry[] iClasspathEntryArray5 = linkedHashSet.toArray(new IClasspathEntry[linkedHashSet.size()]);
            this.javaProject.setRawClasspath(iClasspathEntryArray5, iProgressMonitor);
        }
    }

    private void changeJavaMEClasspathContainer(IDevice iDevice, IProgressMonitor iProgressMonitor) throws CoreException, JavaModelException, OperationCanceledException {
        this.addClasspathContainerIfMissing(iProgressMonitor);
        IClasspathEntry[] iClasspathEntryArray = this.javaProject.getRawClasspath();
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            Path path;
            IPath iPath;
            IClasspathEntry iClasspathEntry = iClasspathEntryArray[n];
            if (iClasspathEntry.getEntryKind() == 5 && (iPath = iClasspathEntry.getPath()).segment(0).equals("org.elipse.mtj.JavaMEContainer") && !iClasspathEntry.equals(path = new Path("org.elipse.mtj.JavaMEContainer/" + iDevice))) {
                iClasspathEntryArray[n] = JavaCore.newContainerEntry((IPath)path);
                this.javaProject.setRawClasspath(iClasspathEntryArray, iProgressMonitor);
                this.getProject().build(6, iProgressMonitor);
                break;
            }
            ++n;
        }
    }

    private boolean containsJavaMEClasspathContainer(IJavaProject iJavaProject) throws JavaModelException {
        IClasspathEntry[] iClasspathEntryArray;
        boolean bl = false;
        IClasspathEntry[] iClasspathEntryArray2 = iClasspathEntryArray = iJavaProject.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry iClasspathEntry = iClasspathEntryArray2[n2];
            if (iClasspathEntry.getEntryKind() == 5 && iClasspathEntry.getPath().segment(0).equals("org.elipse.mtj.JavaMEContainer")) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    private void createPackageForInactiveConfigs(Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        MTJRuntimeList mTJRuntimeList = this.getRuntimeList();
        MTJRuntime mTJRuntime = mTJRuntimeList.getActiveMTJRuntime();
        IDevice iDevice = mTJRuntime.getDevice();
        for (MTJRuntime mTJRuntime2 : mTJRuntimeList) {
            if (mTJRuntime2 == mTJRuntime) continue;
            mTJRuntimeList.switchActiveMTJRuntime(mTJRuntime2);
            IDevice iDevice2 = mTJRuntime2.getDevice();
            if (iDevice != iDevice2) {
                this.changeJavaMEClasspathContainer(iDevice2, iProgressMonitor);
                iDevice = iDevice2;
            }
            BuildStateMachine buildStateMachine = BuildStateMachine.getInstance(this);
            buildStateMachine.start(iProgressMonitor);
            this.getProject().build(6, "org.eclipse.mtj.core.packageBuilder", map, iProgressMonitor);
        }
        this.restoreProjectSettings(mTJRuntimeList, mTJRuntime, iDevice, iProgressMonitor);
    }

    private IPreverifier getPreverifier() throws CoreException, PreverifierNotFoundException {
        IPreverifier iPreverifier = null;
        IMIDPDevice iMIDPDevice = (IMIDPDevice)this.getRuntimeList().getActiveMTJRuntime().getDevice();
        if (iMIDPDevice == null) {
            throw new PreverifierNotFoundException(Messages.MidletSuiteProject_preverifier_missing_device);
        }
        IPreverifier iPreverifier2 = iPreverifier = iMIDPDevice.getPreverifier() != null ? iMIDPDevice.getPreverifier() : MTJCore.getDeviceRegistry().getDefaultPreferifier();
        if (iPreverifier == null) {
            throw new PreverifierNotFoundException(Messages.MidletSuiteProject_preverifier_missing_default);
        }
        return iPreverifier;
    }

    private String getProjectNameWithoutSpaces() {
        String string = this.javaProject.getProject().getName();
        return string.replace(' ', '_');
    }

    private void initializeMetadata() {
        try {
            if (this.isPreprocessedProject()) {
                IProject iProject;
                Object object;
                ICommand[] iCommandArray;
                Object object2 = null;
                ICommand[] iCommandArray2 = iCommandArray = this.getProject().getDescription().getBuildSpec();
                int n = iCommandArray.length;
                int n2 = 0;
                while (n2 < n) {
                    object = iCommandArray2[n2];
                    if (object.getBuilderName().equals("org.eclipse.mtj.core.preverifier")) {
                        object2 = object;
                        break;
                    }
                    ++n2;
                }
                if (object2 != null && (object = (String)object2.getArguments().get("preverifyTargetProject")) != null && (iProject = MTJCore.getWorkspace().getRoot().getProject((String)object)) != null && iProject.exists()) {
                    this.metaData = new MetaData(iProject);
                }
            }
        }
        catch (CoreException coreException) {
            MTJLogger.log(4, coreException);
        }
        if (this.metaData == null) {
            this.metaData = new MetaData(this);
        }
    }

    private void restoreProjectSettings(MTJRuntimeList mTJRuntimeList, MTJRuntime mTJRuntime, IDevice iDevice, IProgressMonitor iProgressMonitor) throws CoreException, JavaModelException {
        mTJRuntimeList.switchActiveMTJRuntime(mTJRuntime);
        if (iDevice != mTJRuntime.getDevice()) {
            this.changeJavaMEClasspathContainer(mTJRuntime.getDevice(), iProgressMonitor);
        } else {
            this.getProject().build(6, iProgressMonitor);
        }
    }
}

