/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sign;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.internal.core.sign.PermissionsGroup;
import org.eclipse.mtj.internal.core.sign.PermissionsGroupsRegistry;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.commons.EmptyVisitor;
import org.objectweb.asm.tree.ClassNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityPermissionsScanner
extends EmptyVisitor
implements IResourceVisitor {
    private static final String DOT = ".";
    private static final String SLASH = "/";
    private static final String CLASS_DESCRIPTOR_REGEXP = "L([a-zA-Z]\\w+)(/\\w+)*;";
    private List<PermissionsGroup> permissions = new ArrayList<PermissionsGroup>();
    private IFolder classFolder;

    public SecurityPermissionsScanner(IFolder iFolder) {
        this.classFolder = iFolder;
    }

    public synchronized List<PermissionsGroup> getRequiredPermissions() {
        ArrayList<PermissionsGroup> arrayList = new ArrayList<PermissionsGroup>();
        try {
            try {
                this.permissions.clear();
                this.classFolder.accept((IResourceVisitor)this);
            }
            catch (CoreException coreException) {
                MTJLogger.log(4, coreException);
                arrayList.addAll(this.permissions);
            }
        }
        finally {
            arrayList.addAll(this.permissions);
        }
        return arrayList;
    }

    public void visitMethodInsn(int n, String string, String string2, String string3) {
        String string4 = string.replace(SLASH, DOT);
        this.inspectClass(string4);
    }

    public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
        if (string2.matches(CLASS_DESCRIPTOR_REGEXP)) {
            StringBuffer stringBuffer = new StringBuffer(string2);
            stringBuffer.deleteCharAt(0);
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            this.inspectClass(stringBuffer.toString().replace(SLASH, DOT));
        }
        return super.visitField(n, string, string2, string3, object);
    }

    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
        if (string2.matches(CLASS_DESCRIPTOR_REGEXP)) {
            StringBuffer stringBuffer = new StringBuffer(string2);
            stringBuffer.deleteCharAt(0);
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            this.inspectClass(stringBuffer.toString().replace(SLASH, DOT));
        }
        super.visitLocalVariable(string, string2, string3, label, label2, n);
    }

    public boolean visit(IResource iResource) throws CoreException {
        if (iResource instanceof IFolder) {
            return true;
        }
        if (!(iResource instanceof IFile) || !Pattern.matches(".+(.class)", iResource.getName())) {
            return false;
        }
        try {
            ClassReader classReader = new ClassReader(((IFile)iResource).getContents());
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            classNode.accept((ClassVisitor)this);
        }
        catch (IOException iOException) {
            MTJLogger.log(4, iOException);
        }
        return false;
    }

    private void inspectClass(String string) {
        List<PermissionsGroup> list = PermissionsGroupsRegistry.getInstance().getPermissions();
        for (PermissionsGroup permissionsGroup : list) {
            if (!permissionsGroup.getClassName().equals(string) || this.permissions.contains(permissionsGroup)) continue;
            this.permissions.add(permissionsGroup);
        }
    }
}

