/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.refactoring;

import java.util.regex.Matcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.refactoring.MidletJadTextFileMidletChange;
import org.eclipse.mtj.internal.core.util.AbstractClasspathEntryVisitor;

class MidletJadFileChangesCollector
extends AbstractClasspathEntryVisitor {
    static final int MODE_RENAME = 1;
    static final int MODE_DELETE = 2;
    private int mode;
    private String oldName;
    private String newName;
    private CompositeChange change;

    public static CompositeChange collectChange(int n, IType iType, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        IJavaProject iJavaProject = (IJavaProject)iType.getAncestor(2);
        MidletJadFileChangesCollector midletJadFileChangesCollector = new MidletJadFileChangesCollector(n, iJavaProject, iType, string);
        midletJadFileChangesCollector.addJavaProjectChanges(iJavaProject, iProgressMonitor);
        midletJadFileChangesCollector.getRunner().run(iJavaProject, midletJadFileChangesCollector, iProgressMonitor);
        return midletJadFileChangesCollector.getChange();
    }

    public MidletJadFileChangesCollector(int n, IJavaProject iJavaProject, IType iType, String string) {
        this.mode = n;
        this.newName = string;
        this.oldName = iType.getFullyQualifiedName();
        this.change = new CompositeChange("Update Application Descriptor Midlet References");
    }

    public CompositeChange getChange() {
        return this.change;
    }

    public boolean visitProject(IClasspathEntry iClasspathEntry, IJavaProject iJavaProject, IJavaProject iJavaProject2, IProgressMonitor iProgressMonitor) throws CoreException {
        this.addJavaProjectChanges(iJavaProject, iProgressMonitor);
        return true;
    }

    private void addJadFileChanges(IFile iFile, IProgressMonitor iProgressMonitor) throws CoreException {
        MidletJadTextFileMidletChange midletJadTextFileMidletChange = new MidletJadTextFileMidletChange(this.mode, iFile.getName(), iFile, this.oldName, this.newName);
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 3);
        Matcher matcher = midletJadTextFileMidletChange.getMatcher(iProgressMonitor);
        if (matcher.find()) {
            midletJadTextFileMidletChange.initializeTextEdit(iProgressMonitor);
            this.change.add((Change)midletJadTextFileMidletChange);
        }
        subProgressMonitor.done();
    }

    private void addJavaProjectChanges(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException {
        IFile iFile;
        IMidletSuiteProject iMidletSuiteProject;
        iProgressMonitor.setTaskName("Creating Application Descriptor for " + iJavaProject.getElementName());
        if (this.isMidletSuite(iJavaProject) && (iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(iJavaProject)) != null && (iFile = iMidletSuiteProject.getApplicationDescriptorFile()).exists()) {
            this.addJadFileChanges(iFile, iProgressMonitor);
        }
        iProgressMonitor.worked(1);
    }

    private boolean isMidletSuite(IJavaProject iJavaProject) throws CoreException {
        return iJavaProject.getProject().hasNature("org.eclipse.mtj.core.nature");
    }
}

