/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.crypto.io.raes.KeyManagerRaesParameters;
import de.schlichtherle.crypto.io.raes.RaesOutputStream;
import de.schlichtherle.crypto.io.raes.RaesParameters;
import de.schlichtherle.crypto.io.raes.RaesReadOnlyFile;
import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.File;
import de.schlichtherle.io.FileInputStream;
import de.schlichtherle.io.FileOutputStream;
import de.schlichtherle.io.rof.ReadOnlyFile;
import de.schlichtherle.io.rof.ReadOnlyFileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RaesFiles {
    protected RaesFiles() {
    }

    public static void encrypt(String plainFilePath, String raesFilePath) throws IOException {
        RaesFiles.encrypt(plainFilePath, raesFilePath, File.getDefaultArchiveDetector());
    }

    public static void encrypt(String plainFilePath, String raesFilePath, ArchiveDetector detector) throws IOException {
        RaesOutputStream out;
        File plainFile = RaesFiles.getNonArchiveFile(plainFilePath, detector);
        FileInputStream in = detector.createFileInputStream(plainFile);
        try {
            File raesFile = RaesFiles.getNonArchiveFile(raesFilePath, detector);
            KeyManagerRaesParameters params = new KeyManagerRaesParameters(raesFile.getCanonicalPath());
            out = RaesOutputStream.getInstance(detector.createFileOutputStream(raesFile, false), params);
        }
        catch (IOException failure) {
            ((InputStream)in).close();
            throw failure;
        }
        File.cp(in, (OutputStream)((Object)out));
    }

    public static void decrypt(String raesFilePath, String plainFilePath, boolean strongAuthentication) throws IOException {
        RaesFiles.decrypt(raesFilePath, plainFilePath, strongAuthentication, File.getDefaultArchiveDetector());
    }

    public static void decrypt(String raesFilePath, String plainFilePath, boolean strongAuthentication, ArchiveDetector detector) throws IOException {
        FileOutputStream out;
        ReadOnlyFileInputStream in;
        File raesFile = RaesFiles.getNonArchiveFile(raesFilePath, detector);
        KeyManagerRaesParameters params = new KeyManagerRaesParameters(raesFile.getCanonicalPath());
        RaesReadOnlyFile rrof = RaesReadOnlyFile.getInstance(raesFile, (RaesParameters)params);
        try {
            if (strongAuthentication) {
                rrof.authenticate();
            }
            in = new ReadOnlyFileInputStream((ReadOnlyFile)((Object)rrof));
            File plainFile = RaesFiles.getNonArchiveFile(plainFilePath, detector);
            out = detector.createFileOutputStream(plainFile, false);
        }
        catch (IOException failure) {
            rrof.close();
            throw failure;
        }
        File.cp(in, out);
    }

    private static final File getNonArchiveFile(String path, ArchiveDetector detector) {
        File file = detector.createFile(path);
        return ArchiveDetector.NULL.createFile(file.getParentFile(), file.getName());
    }
}

