/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.jad.form.pages;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.mtj.core.build.sign.ISignatureProperties;
import org.eclipse.mtj.core.project.IMTJProjectListener;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProjectListener;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.sign.DefaultKeyStoreManager;
import org.eclipse.mtj.internal.core.sign.KeyStoreEntry;
import org.eclipse.mtj.internal.core.sign.KeyStoreManagerException;
import org.eclipse.mtj.internal.core.sign.SecurityPermissionsScanner;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.dialog.SecurityPermissionsDialog;
import org.eclipse.mtj.internal.ui.dialog.SigningPasswordDialog;
import org.eclipse.mtj.internal.ui.editors.jad.form.JADFormEditor;
import org.eclipse.mtj.internal.ui.forms.blocks.GenericListBlock;
import org.eclipse.mtj.internal.ui.forms.blocks.GenericListBlockItem;
import org.eclipse.mtj.internal.ui.forms.blocks.GenericListBlockListener;
import org.eclipse.mtj.ui.editors.jad.AbstractJADEditorPage;
import org.eclipse.mtj.ui.editors.jad.IManifestPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SigningJADEditorPage
extends AbstractJADEditorPage {
    public static final String ID = "signing";
    private static final String COMMA = ",";
    private static final String TITLE = MTJUIMessages.PermissionsPage_title;
    private Combo combo;
    private Button enableButton;
    private GenericListBlock<SecurityPermissionListItem> optPermissionBlock;
    private List<SecurityPermissionListItem> optPermissions;
    private IMidletSuiteProjectListener projectListener;
    private GenericListBlock<SecurityPermissionListItem> reqPermissionBlock;
    private List<SecurityPermissionListItem> reqPermissions = new LinkedList<SecurityPermissionListItem>();

    public SigningJADEditorPage(JADFormEditor jADFormEditor) {
        super(jADFormEditor, ID, TITLE);
        this.optPermissions = new LinkedList<SecurityPermissionListItem>();
        this.listenForProjectSignatureUpdates();
    }

    @Override
    public void dispose() {
        super.dispose();
        IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)this.getJavaProject());
        if (iMidletSuiteProject != null) {
            iMidletSuiteProject.removeMTJProjectListener((IMTJProjectListener)this.projectListener);
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        IManifestPreferenceStore iManifestPreferenceStore = this.getPreferenceStore();
        String string = this.getPermissionsListAsString(ListId.Required);
        iManifestPreferenceStore.setValue("MIDlet-Permissions", string);
        String string2 = this.getPermissionsListAsString(ListId.Optional);
        iManifestPreferenceStore.setValue("MIDlet-Permissions-Opt", string2);
        this.updateProjectSigningState();
        this.setDirty(false);
    }

    @Override
    public void editorInputChanged() {
        Object object;
        int n;
        Object object2;
        IManifestPreferenceStore iManifestPreferenceStore = this.getPreferenceStore();
        this.reqPermissions.clear();
        this.optPermissions.clear();
        String string = iManifestPreferenceStore.getString("MIDlet-Permissions");
        if (string.length() > 0) {
            Object object3 = object2 = string.split(COMMA);
            n = ((Object)object3).length;
            int n2 = 0;
            while (n2 < n) {
                object = object3[n2];
                this.reqPermissions.add(new SecurityPermissionListItem((String)object));
                ++n2;
            }
        }
        if (((String)(object2 = iManifestPreferenceStore.getString("MIDlet-Permissions-Opt"))).length() > 0) {
            String[] stringArray = object = ((String)object2).split(COMMA);
            int n3 = ((String[])object).length;
            n = 0;
            while (n < n3) {
                String string2 = stringArray[n];
                this.optPermissions.add(new SecurityPermissionListItem(string2));
                ++n;
            }
        }
        if (this.reqPermissionBlock != null) {
            this.reqPermissionBlock.update();
        }
        if (this.optPermissionBlock != null) {
            this.optPermissionBlock.update();
        }
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public boolean isManagingProperty(String string) {
        return false;
    }

    public void setActive(boolean bl) {
        super.setActive(bl);
        if (bl) {
            this.getErrorMessageManager().removeAllMessages();
        }
    }

    private void addPermissions(ListId listId) {
        CheckedTreeSelectionDialog checkedTreeSelectionDialog = SecurityPermissionsDialog.createDialog(this.getPartControl().getShell());
        if (checkedTreeSelectionDialog.open() == 0) {
            Object[] objectArray = checkedTreeSelectionDialog.getResult();
            GenericListBlock<SecurityPermissionListItem> genericListBlock = null;
            List<SecurityPermissionListItem> list = null;
            switch (listId) {
                case Required: {
                    genericListBlock = this.reqPermissionBlock;
                    list = this.reqPermissions;
                    break;
                }
                case Optional: {
                    genericListBlock = this.optPermissionBlock;
                    list = this.optPermissions;
                }
            }
            if (list != null) {
                this.addPermissionsToList(list, objectArray);
                genericListBlock.update();
            }
        }
    }

    private void addPermissionsToList(List<SecurityPermissionListItem> list, Object[] objectArray) {
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (object instanceof SecurityPermissionsDialog.PermissionNode) {
                boolean bl = true;
                String string = ((SecurityPermissionsDialog.PermissionNode)object).getPermission();
                for (SecurityPermissionListItem securityPermissionListItem : list) {
                    if (!securityPermissionListItem.getText().equals(string)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    list.add(new SecurityPermissionListItem(string));
                }
            }
            ++n2;
        }
        this.setDirty(true);
    }

    private void createAliasSection(IManagedForm iManagedForm, Composite composite) {
        FormToolkit formToolkit = iManagedForm.getToolkit();
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        Composite composite2 = this.createSection(iManagedForm, composite, MTJUIMessages.PermissionsPage_signProperties, null, gridData);
        composite2.setLayout((Layout)new GridLayout(2, false));
        formToolkit.createLabel(composite2, MTJUIMessages.PermissionsPage_keyAlias);
        this.combo = new Combo(composite2, 12);
        gridData = new GridData(4, 0x1000000, true, false);
        this.combo.setLayoutData((Object)gridData);
        this.combo.setFocus();
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                SigningJADEditorPage.this.setDirty(true);
            }
        });
    }

    private void createListsSection(IManagedForm iManagedForm, Composite composite) {
        Composite composite2 = this.createSection(iManagedForm, composite, MTJUIMessages.PermissionsPage_requiredPermissionsTitle, MTJUIMessages.PermissionsPage_requiredPermissionsMessage, new GridData(4, 4, true, true));
        composite2.setLayout((Layout)new GridLayout(1, false));
        this.reqPermissionBlock = new GenericListBlock<SecurityPermissionListItem>(composite2, 2050, 62, this.reqPermissions);
        this.reqPermissionBlock.addGenericListBlockListener(new GenericListBlockListener<SecurityPermissionListItem>(){

            @Override
            public void addButtonPressed() {
                SigningJADEditorPage.this.addPermissions(ListId.Required);
            }

            @Override
            public void downButtonPressed() {
                SigningJADEditorPage.this.setDirty(true);
            }

            @Override
            public void itemsRemoved(List<SecurityPermissionListItem> list) {
                SigningJADEditorPage.this.setDirty(true);
            }

            @Override
            public void scan() {
                SigningJADEditorPage.this.scanProjectClasses(ListId.Required);
            }

            @Override
            public void upButtonPressed() {
                SigningJADEditorPage.this.setDirty(true);
            }
        });
        Composite composite3 = this.createSection(iManagedForm, composite, MTJUIMessages.PermissionsPage_optionalPermissionsTitle, MTJUIMessages.PermissionsPage_optionalPermissionsMessage, new GridData(4, 4, true, true));
        composite3.setLayout((Layout)new GridLayout(1, false));
        this.optPermissionBlock = new GenericListBlock<SecurityPermissionListItem>(composite3, 2050, 62, this.optPermissions);
        this.optPermissionBlock.addGenericListBlockListener(new GenericListBlockListener<SecurityPermissionListItem>(){

            @Override
            public void addButtonPressed() {
                SigningJADEditorPage.this.addPermissions(ListId.Optional);
            }

            @Override
            public void downButtonPressed() {
                SigningJADEditorPage.this.setDirty(true);
            }

            @Override
            public void itemsRemoved(List<SecurityPermissionListItem> list) {
                SigningJADEditorPage.this.setDirty(true);
            }

            @Override
            public void scan() {
                SigningJADEditorPage.this.scanProjectClasses(ListId.Optional);
            }

            @Override
            public void upButtonPressed() {
                SigningJADEditorPage.this.setDirty(true);
            }
        });
    }

    private Composite createSection(IManagedForm iManagedForm, Composite composite, String string, String string2, GridData gridData) {
        FormToolkit formToolkit = iManagedForm.getToolkit();
        Section section = formToolkit.createSection(composite, 384);
        if (string != null) {
            section.setText(string);
        }
        if (string2 != null) {
            section.setDescription(string2);
        }
        section.setLayoutData((Object)gridData);
        section.setLayout((Layout)new GridLayout(1, false));
        Composite composite2 = formToolkit.createComposite((Composite)section, 0);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        section.setClient((Control)composite2);
        return composite2;
    }

    private void createTopSection(IManagedForm iManagedForm, Composite composite) {
        FormToolkit formToolkit = iManagedForm.getToolkit();
        this.enableButton = formToolkit.createButton(composite, MTJUIMessages.PermissionsPage_signPackage, 32);
        this.enableButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                SigningJADEditorPage.this.updateWidgetsStates(SigningJADEditorPage.this.enableButton.getSelection());
                SigningJADEditorPage.this.setDirty(true);
            }
        });
        ISignatureProperties iSignatureProperties = this.getProjectSignatureProperties();
        if (iSignatureProperties != null) {
            this.enableButton.setSelection(iSignatureProperties.isSignProject());
        }
        GridData gridData = new GridData(16384, 0x1000000, false, false);
        gridData.horizontalSpan = 2;
        this.enableButton.setLayoutData((Object)gridData);
    }

    private String getPermissionsListAsString(ListId listId) {
        StringBuffer stringBuffer = new StringBuffer();
        List<SecurityPermissionListItem> list = null;
        switch (listId) {
            case Required: {
                list = this.reqPermissions;
                break;
            }
            case Optional: {
                list = this.optPermissions;
            }
        }
        if (list != null) {
            for (SecurityPermissionListItem securityPermissionListItem : list) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(COMMA);
                }
                stringBuffer.append(securityPermissionListItem.getText().trim());
            }
        }
        return stringBuffer.toString();
    }

    private ISignatureProperties getProjectSignatureProperties() {
        ISignatureProperties iSignatureProperties = null;
        IMidletSuiteProject iMidletSuiteProject = null;
        try {
            iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)this.getJavaProject());
            iSignatureProperties = iMidletSuiteProject.getSignatureProperties();
        }
        catch (CoreException coreException) {
            String string = NLS.bind((String)"Unable to get project signing properties: {0}", (Object)coreException.getMessage());
            MTJLogger.log((int)4, (String)string);
            this.getErrorMessageManager().addMessage((Object)string, string, null, 3);
        }
        return iSignatureProperties;
    }

    private void listAliases(final Combo combo) {
        Display.getDefault().asyncExec(new Runnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                Object object;
                Object object2;
                ISignatureProperties iSignatureProperties = null;
                String string = null;
                String string2 = null;
                File file = null;
                combo.removeAll();
                iSignatureProperties = SigningJADEditorPage.this.getProjectSignatureProperties();
                if (iSignatureProperties == null) {
                    return;
                }
                try {
                    string2 = iSignatureProperties.getAbsoluteKeyStorePath(SigningJADEditorPage.this.getJavaProject().getProject());
                    if (string2 == null) {
                        return;
                    }
                }
                catch (CoreException coreException) {
                    MTJLogger.log((int)4, (String)NLS.bind((String)"Unable to get keystore path: {0}", (Object)coreException.getMessage()));
                }
                file = new File(string2);
                if (!file.exists() || !file.isFile()) {
                    return;
                }
                if (iSignatureProperties.getPasswordStorageMethod() == 0) {
                    object2 = new SigningPasswordDialog(SigningJADEditorPage.this.getPartControl().getShell(), false);
                    ((SigningPasswordDialog)((Object)object2)).setTitle("KeyStore Password");
                    if (object2.open() != 0) return;
                    string = ((SigningPasswordDialog)((Object)object2)).getPassword();
                } else {
                    string = iSignatureProperties.getKeyStorePassword();
                }
                try {
                    object2 = new DefaultKeyStoreManager(file, string);
                    object2.setProvider(iSignatureProperties.getKeyStoreProvider());
                    object2.setKeystoreType(iSignatureProperties.getKeyStoreType());
                    object = object2.getEntries();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        KeyStoreEntry keyStoreEntry = (KeyStoreEntry)iterator.next();
                        if (keyStoreEntry.getType() != KeyStoreEntry.Type.KEY_PAIR) continue;
                        combo.add(keyStoreEntry.getAlias());
                    }
                }
                catch (KeyStoreManagerException keyStoreManagerException) {
                    object = NLS.bind((String)"Unable to get keystore aliases: {0}", (Object)keyStoreManagerException.getMessage());
                    MTJLogger.log((int)4, (String)object);
                    SigningJADEditorPage.this.getErrorMessageManager().addMessage(object, (String)object, null, 3);
                }
                catch (Exception exception) {
                    object = exception.getMessage();
                    MTJLogger.log((int)4, (String)object);
                    SigningJADEditorPage.this.getErrorMessageManager().addMessage(object, (String)object, null, 3);
                }
                object2 = iSignatureProperties.getKeyAlias();
                if (object2 == null) {
                    return;
                }
                int n = 0;
                while (n < combo.getItemCount()) {
                    if (((String)object2).equals(combo.getItem(n))) {
                        combo.select(n);
                    }
                    ++n;
                }
            }
        });
    }

    private void listenForProjectSignatureUpdates() {
        this.projectListener = new IMidletSuiteProjectListener(){

            public void classpathRefreshed() {
            }

            public void jadFileNameChanged() {
            }

            public void metaDataSaved() {
            }

            public void packageCreated() {
            }

            public void signaturePropertiesChanged() {
                if (SigningJADEditorPage.this.enableButton != null && !SigningJADEditorPage.this.enableButton.isDisposed() && SigningJADEditorPage.this.enableButton.getSelection()) {
                    SigningJADEditorPage.this.listAliases(SigningJADEditorPage.this.combo);
                }
            }

            public void tempKeyPasswordChanged() {
            }

            public void tempKeystorePasswordChanged() {
            }
        };
        IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)this.getJavaProject());
        if (iMidletSuiteProject != null) {
            iMidletSuiteProject.addMTJProjectListener((IMTJProjectListener)this.projectListener);
        }
    }

    private void scanProjectClasses(ListId listId) {
        IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)this.getJavaProject());
        if (iMidletSuiteProject == null) {
            return;
        }
        CheckedTreeSelectionDialog checkedTreeSelectionDialog = SecurityPermissionsDialog.createDialog(this.getPartControl().getShell());
        SecurityPermissionsScanner securityPermissionsScanner = new SecurityPermissionsScanner(iMidletSuiteProject.getVerifiedClassesOutputFolder(null));
        List list = securityPermissionsScanner.getRequiredPermissions();
        checkedTreeSelectionDialog.setInitialSelections(list.toArray());
        if (checkedTreeSelectionDialog.open() == 0) {
            Object[] objectArray = checkedTreeSelectionDialog.getResult();
            GenericListBlock<SecurityPermissionListItem> genericListBlock = null;
            List<SecurityPermissionListItem> list2 = null;
            switch (listId) {
                case Required: {
                    genericListBlock = this.reqPermissionBlock;
                    list2 = this.reqPermissions;
                    break;
                }
                case Optional: {
                    genericListBlock = this.optPermissionBlock;
                    list2 = this.optPermissions;
                }
            }
            if (list2 != null) {
                this.addPermissionsToList(list2, objectArray);
                genericListBlock.update();
            }
        }
    }

    private void updateProjectSigningState() {
        ISignatureProperties iSignatureProperties = null;
        IMidletSuiteProject iMidletSuiteProject = null;
        iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)this.getJavaProject());
        iSignatureProperties = this.getProjectSignatureProperties();
        if (iSignatureProperties == null) {
            return;
        }
        try {
            iSignatureProperties.setSignProject(this.enableButton.getSelection());
            int n = this.combo.getSelectionIndex();
            if (n >= 0) {
                iSignatureProperties.setKeyAlias(this.combo.getItem(n));
            }
            iMidletSuiteProject.setSignatureProperties(iSignatureProperties);
            iMidletSuiteProject.saveMetaData();
        }
        catch (CoreException coreException) {
            MTJLogger.log((int)4, (Throwable)coreException);
        }
    }

    @Override
    protected void createFormContent(IManagedForm iManagedForm) {
        FormToolkit formToolkit = iManagedForm.getToolkit();
        ScrolledForm scrolledForm = iManagedForm.getForm();
        scrolledForm.setExpandHorizontal(true);
        scrolledForm.setExpandVertical(true);
        formToolkit.decorateFormHeading(scrolledForm.getForm());
        this.createErrorMessageHandler(iManagedForm);
        scrolledForm.setText(this.getTitle());
        Composite composite = scrolledForm.getBody();
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 20;
        composite.setLayout((Layout)gridLayout);
        this.createTopSection(iManagedForm, composite);
        this.createAliasSection(iManagedForm, composite);
        this.createListsSection(iManagedForm, composite);
        this.updateWidgetsStates(this.enableButton.getSelection());
        scrolledForm.reflow(true);
    }

    @Override
    protected String getHelpResource() {
        return null;
    }

    protected void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        this.editorInputChanged();
    }

    protected void updateWidgetsStates(boolean bl) {
        this.combo.setEnabled(bl);
        if (bl) {
            this.listAliases(this.combo);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ListId {
        Optional,
        Required;

    }

    private class SecurityPermissionListItem
    implements GenericListBlockItem {
        private String permission;

        public SecurityPermissionListItem(String string) {
            this.permission = string;
        }

        public boolean equals(Object object) {
            if (object instanceof SecurityPermissionListItem) {
                SecurityPermissionListItem securityPermissionListItem = (SecurityPermissionListItem)object;
                return this.getText().equals(securityPermissionListItem.getText());
            }
            return super.equals(object);
        }

        public Image getImage() {
            return MTJUIPluginImages.DESC_PERMISSION_OBJ.createImage();
        }

        public String getText() {
            return this.permission;
        }

        public int hashCode() {
            String string = this.getText();
            int n = 0;
            int n2 = 0;
            while (n2 < string.length()) {
                n += string.charAt(n2);
                ++n2;
            }
            return n;
        }
    }
}

