/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mtj.internal.ui.IPreferenceConstants;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.editor.text.ColorManager;
import org.eclipse.mtj.internal.ui.preferences.TabFolderLayout;
import org.eclipse.mtj.internal.ui.preferences.XMLSyntaxColorTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class EditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IPreferenceConstants {
    private ColorManager fColorManager;
    private XMLSyntaxColorTab fXMLTab;

    public EditorPreferencePage() {
        this.setDescription(MTJUIMessages.EditorPreferencePage_description);
        this.fColorManager = new ColorManager();
    }

    public void dispose() {
        this.fColorManager.disposeColors(false);
        this.fXMLTab.dispose();
        super.dispose();
    }

    public void init(IWorkbench iWorkbench) {
    }

    public boolean performOk() {
        this.fXMLTab.performOk();
        MTJUIPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }

    private void createXMLTab(TabFolder tabFolder) {
        this.fXMLTab = new XMLSyntaxColorTab(this.fColorManager);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(MTJUIMessages.EditorPreferencePage_localization_tab_title);
        tabItem.setControl(this.fXMLTab.createContents((Composite)tabFolder));
    }

    protected Control createContents(Composite composite) {
        final Link link = new Link(composite, 0);
        link.setText(MTJUIMessages.EditorPreferencePage_generalTextEditor_link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PreferencesUtil.createPreferenceDialogOn((Shell)link.getShell(), (String)"org.eclipse.ui.preferencePages.GeneralTextEditor", null, null);
            }
        });
        GridData gridData = new GridData(32);
        Button button = new Button(composite, 16480);
        button.setText(MTJUIMessages.EditorPreferencePage_folding_label);
        button.setLayoutData((Object)gridData);
        button.setSelection(MTJUIPlugin.getDefault().getPreferenceStore().getBoolean("editor.folding"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IPreferenceStore iPreferenceStore = MTJUIPlugin.getDefault().getPreferenceStore();
                iPreferenceStore.setValue("editor.folding", ((Button)selectionEvent.getSource()).getSelection());
            }
        });
        TabFolder tabFolder = new TabFolder(composite, 0);
        tabFolder.setLayout((Layout)new TabFolderLayout());
        tabFolder.setLayoutData((Object)new GridData(1808));
        this.createXMLTab(tabFolder);
        Dialog.applyDialogFont((Control)this.getControl());
        return composite;
    }

    protected void performDefaults() {
        this.fXMLTab.performDefaults();
        super.performDefaults();
    }
}

