/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.pulsar.core.action;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Util;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IFileArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.mtj.internal.pulsar.core.Messages;
import org.eclipse.mtj.pulsar.core.Activator;

public class ExecuteAction
extends ProvisioningAction {
    public static final String ACTION_EXECUTE = "execute";
    private static final String PARM_EXECUTABLE = "executable";

    public IStatus execute(Map map) {
        String string = (String)map.get(PARM_EXECUTABLE);
        if (string == null) {
            return Activator.makeErrorStatus(MessageFormat.format(Messages.ExecuteAction_ParamNotSetError, PARM_EXECUTABLE, ACTION_EXECUTE), null);
        }
        IInstallableUnit iInstallableUnit = (IInstallableUnit)map.get("iu");
        if (string.equals("@artifact")) {
            IFileArtifactRepository iFileArtifactRepository;
            IArtifactKey iArtifactKey = iInstallableUnit.getArtifacts()[0];
            try {
                iFileArtifactRepository = Util.getDownloadCacheRepo();
            }
            catch (ProvisionException provisionException) {
                return provisionException.getStatus();
            }
            File file = iFileArtifactRepository.getArtifactFile(iArtifactKey);
            if (file == null || !file.exists()) {
                return Activator.makeErrorStatus(MessageFormat.format(Messages.ExecuteAction_MissingArtifactError, iArtifactKey), null);
            }
            string = file.getAbsolutePath();
        }
        try {
            this.execute(string, iInstallableUnit);
        }
        catch (Exception exception) {
            return Activator.makeErrorStatus(MessageFormat.format(Messages.ExecuteAction_ExecuteError, string), exception);
        }
        return Status.OK_STATUS;
    }

    private void execute(String string, IInstallableUnit iInstallableUnit) throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder(string);
        Process process = processBuilder.start();
        process.waitFor();
    }

    public IStatus undo(Map map) {
        return Activator.makeErrorStatus(Messages.ExecuteAction_UndoUnsupportedError, null);
    }
}

