/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor.context;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.mtj.internal.core.IModelChangedEvent;
import org.eclipse.mtj.internal.core.text.IDocumentAttributeNode;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.IDocumentTextNode;
import org.eclipse.mtj.internal.core.util.xml.MTJXMLHelper;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditor;
import org.eclipse.mtj.internal.ui.editor.context.UTF8InputContext;
import org.eclipse.mtj.internal.ui.editor.context.XMLDocumentSetupParticipant;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MoveSourceEdit;
import org.eclipse.text.edits.MoveTargetEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XMLInputContext
extends UTF8InputContext {
    protected HashMap<IDocumentElementNode, MoveSourceEdit> fMoveOperations = new HashMap();
    protected HashMap<Object, TextEdit> fOperationTable = new HashMap();

    public XMLInputContext(MTJFormEditor mTJFormEditor, IEditorInput iEditorInput, boolean bl) {
        super(mTJFormEditor, iEditorInput, bl);
    }

    private void addAttributeOperation(IDocumentAttributeNode iDocumentAttributeNode, ArrayList<TextEdit> arrayList, IModelChangedEvent iModelChangedEvent) {
        TextEdit textEdit;
        int n = iDocumentAttributeNode.getValueOffset();
        Object object = iModelChangedEvent.getNewValue();
        IDocumentAttributeNode iDocumentAttributeNode2 = iDocumentAttributeNode;
        ReplaceEdit replaceEdit = null;
        if (n > -1) {
            if (object == null || object.toString().length() == 0) {
                int n2 = iDocumentAttributeNode.getValueOffset() + iDocumentAttributeNode.getValueLength() + 1 - iDocumentAttributeNode.getNameOffset();
                replaceEdit = this.getAttributeDeleteEditOperation(iDocumentAttributeNode.getNameOffset(), n2);
            } else {
                replaceEdit = new ReplaceEdit(n, iDocumentAttributeNode.getValueLength(), this.getWritableAttributeNodeValue(iModelChangedEvent.getNewValue().toString()));
            }
        }
        if (replaceEdit == null) {
            IDocumentElementNode iDocumentElementNode = iDocumentAttributeNode.getEnclosingElement();
            IDocument iDocument = this.getDocumentProvider().getDocument((Object)this.getInput());
            if (iDocumentElementNode.getOffset() > -1) {
                iDocumentAttributeNode2 = iDocumentElementNode;
                int n3 = this.getNextPosition(iDocument, iDocumentElementNode.getOffset(), '>');
                replaceEdit = new ReplaceEdit(iDocumentElementNode.getOffset(), n3 + 1, iDocumentElementNode.writeShallow(this.shouldTerminateElement(iDocument, iDocumentElementNode.getOffset() + n3)));
            } else {
                this.insertNode(iDocumentElementNode, arrayList);
                return;
            }
        }
        if ((textEdit = this.fOperationTable.get(iDocumentAttributeNode2)) != null) {
            arrayList.remove(textEdit);
        }
        arrayList.add((TextEdit)replaceEdit);
        this.fOperationTable.put(iDocumentAttributeNode2, (TextEdit)replaceEdit);
    }

    private void addElementContentOperation(IDocumentTextNode iDocumentTextNode, ArrayList<TextEdit> arrayList) {
        Object object;
        ReplaceEdit replaceEdit = null;
        IDocumentTextNode iDocumentTextNode2 = iDocumentTextNode;
        if (iDocumentTextNode.getOffset() > -1) {
            object = this.getWritableTextNodeString(iDocumentTextNode);
            replaceEdit = new ReplaceEdit(iDocumentTextNode.getOffset(), iDocumentTextNode.getLength(), (String)object);
        } else {
            object = iDocumentTextNode.getEnclosingElement();
            if (object.getOffset() > -1) {
                String string;
                IDocument iDocument = this.getDocumentProvider().getDocument((Object)this.getInput());
                try {
                    string = iDocument.get(object.getOffset() + object.getLength() - 2, 2);
                    if ("/>".equals(string)) {
                        this.insertNode((IDocumentElementNode)object, arrayList);
                        return;
                    }
                }
                catch (BadLocationException badLocationException) {}
                iDocumentTextNode2 = object;
                string = TextUtilities.getDefaultLineDelimiter((IDocument)this.getDocumentProvider().getDocument((Object)this.getInput()));
                StringBuffer stringBuffer = new StringBuffer(string);
                int n = 0;
                while (n < object.getLineIndent()) {
                    stringBuffer.append(" ");
                    ++n;
                }
                stringBuffer.append("   " + this.getWritableTextNodeString(iDocumentTextNode));
                n = object.getOffset();
                int n2 = this.getNextPosition(iDocument, n, '>');
                replaceEdit = new InsertEdit(n + n2 + 1, stringBuffer.toString());
            } else {
                this.insertNode((IDocumentElementNode)object, arrayList);
                return;
            }
        }
        object = this.fOperationTable.get(iDocumentTextNode2);
        if (object != null) {
            arrayList.remove(object);
        }
        arrayList.add((TextEdit)replaceEdit);
        this.fOperationTable.put(iDocumentTextNode2, (TextEdit)replaceEdit);
    }

    private DeleteEdit getAttributeDeleteEditOperation(int n, int n2) {
        try {
            IDocument iDocument = this.getDocumentProvider().getDocument((Object)this.getInput());
            int n3 = n - 1;
            while (n3 >= 0) {
                char c = iDocument.getChar(n3);
                if (Character.isWhitespace(c)) {
                    ++n2;
                    --n;
                    --n3;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException badLocationException) {}
        return new DeleteEdit(n, n2);
    }

    private DeleteEdit getDeleteNodeOperation(IDocumentElementNode iDocumentElementNode) {
        int n = iDocumentElementNode.getOffset();
        int n2 = iDocumentElementNode.getLength();
        try {
            int n3;
            int n4;
            int n5;
            int n6;
            IDocument iDocument;
            block5: {
                iDocument = this.getDocumentProvider().getDocument((Object)this.getInput());
                n6 = iDocument.getLineOfOffset(n);
                n5 = iDocument.getLineOffset(n6);
                n4 = n - 1;
                while (n4 >= n5) {
                    if (!Character.isWhitespace(iDocument.getChar(n4))) break;
                    --n4;
                }
                ++n4;
                int n7 = iDocument.getLineOfOffset(n + n2);
                int n8 = iDocument.getLineDelimiter(n7).length();
                n3 = n2;
                do {
                    if (Character.isWhitespace(iDocument.getChar(n + ++n3))) continue;
                    --n3;
                    break block5;
                } while (iDocument.getLineOfOffset(n + n3) <= n7);
                n3 -= n8;
            }
            if (n4 == n5) {
                n4 -= iDocument.getLineDelimiter(n6 - 1).length();
            }
            n2 = n3 + (n - n4);
            n = n4;
        }
        catch (BadLocationException badLocationException) {}
        return new DeleteEdit(n, n2);
    }

    private IDocumentElementNode getHighestNodeToBeWritten(IDocumentElementNode iDocumentElementNode) {
        IDocumentElementNode iDocumentElementNode2 = iDocumentElementNode.getParentNode();
        if (iDocumentElementNode2 == null) {
            return iDocumentElementNode;
        }
        if (iDocumentElementNode2.getOffset() > -1) {
            IDocument iDocument = this.getDocumentProvider().getDocument((Object)this.getInput());
            try {
                String string = iDocument.get(iDocumentElementNode2.getOffset() + iDocumentElementNode2.getLength() - 2, 2);
                return "/>".equals(string) ? iDocumentElementNode2 : iDocumentElementNode;
            }
            catch (BadLocationException badLocationException) {
                return iDocumentElementNode;
            }
        }
        return this.getHighestNodeToBeWritten(iDocumentElementNode2);
    }

    private IRegion getMoveRegion(IDocumentElementNode iDocumentElementNode) {
        int n = iDocumentElementNode.getOffset();
        int n2 = iDocumentElementNode.getLength();
        int n3 = 1;
        try {
            IDocument iDocument = this.getDocumentProvider().getDocument((Object)this.getInput());
            while (true) {
                char c;
                if (!Character.isWhitespace(c = iDocument.get(n - n3, 1).toCharArray()[0])) {
                    --n3;
                    break;
                }
                ++n3;
            }
        }
        catch (BadLocationException badLocationException) {}
        return new Region(n - n3, n2 + n3);
    }

    private int getNextPosition(IDocument iDocument, int n, char c) {
        int n2 = 0;
        try {
            n2 = 0;
            while (n2 + n < iDocument.getLength()) {
                if (c != iDocument.getChar(n + n2)) {
                    ++n2;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException badLocationException) {}
        return n2;
    }

    private InsertEdit insertAfterSibling(IDocumentElementNode iDocumentElementNode) {
        for (IDocumentElementNode iDocumentElementNode2 = iDocumentElementNode.getPreviousSibling(); iDocumentElementNode2 != null; iDocumentElementNode2 = iDocumentElementNode2.getPreviousSibling()) {
            if (iDocumentElementNode2.getOffset() <= -1) continue;
            iDocumentElementNode.setLineIndent(iDocumentElementNode2.getLineIndent());
            String string = TextUtilities.getDefaultLineDelimiter((IDocument)this.getDocumentProvider().getDocument((Object)this.getInput()));
            return new InsertEdit(iDocumentElementNode2.getOffset() + iDocumentElementNode2.getLength(), String.valueOf(string) + iDocumentElementNode.write(true));
        }
        return null;
    }

    private InsertEdit insertAsFirstChild(IDocumentElementNode iDocumentElementNode) {
        int n = iDocumentElementNode.getParentNode().getOffset();
        int n2 = this.getNextPosition(this.getDocumentProvider().getDocument((Object)this.getInput()), n, '>');
        iDocumentElementNode.setLineIndent(iDocumentElementNode.getParentNode().getLineIndent() + 3);
        String string = TextUtilities.getDefaultLineDelimiter((IDocument)this.getDocumentProvider().getDocument((Object)this.getInput()));
        return new InsertEdit(n + n2 + 1, String.valueOf(string) + iDocumentElementNode.write(true));
    }

    private void insertNode(IDocumentElementNode iDocumentElementNode, ArrayList<TextEdit> arrayList) {
        TextEdit textEdit;
        InsertEdit insertEdit = null;
        if ((iDocumentElementNode = this.getHighestNodeToBeWritten(iDocumentElementNode)).getParentNode() == null) {
            if (iDocumentElementNode.isRoot()) {
                insertEdit = new InsertEdit(0, iDocumentElementNode.write(true));
            }
        } else if (iDocumentElementNode.getOffset() > -1) {
            insertEdit = new ReplaceEdit(iDocumentElementNode.getOffset(), iDocumentElementNode.getLength(), iDocumentElementNode.write(false));
        } else {
            insertEdit = this.insertAfterSibling(iDocumentElementNode);
            if (insertEdit == null) {
                insertEdit = this.insertAsFirstChild(iDocumentElementNode);
            }
        }
        if ((textEdit = this.fOperationTable.get(iDocumentElementNode)) != null) {
            arrayList.remove(textEdit);
        }
        if (insertEdit != null) {
            arrayList.add((TextEdit)insertEdit);
            this.fOperationTable.put(iDocumentElementNode, (TextEdit)insertEdit);
        }
    }

    private void modifyNode(IDocumentElementNode iDocumentElementNode, ArrayList<TextEdit> arrayList, IModelChangedEvent iModelChangedEvent) {
        IDocumentElementNode iDocumentElementNode2;
        IDocumentElementNode iDocumentElementNode3 = (IDocumentElementNode)iModelChangedEvent.getOldValue();
        IDocumentElementNode iDocumentElementNode4 = (IDocumentElementNode)iModelChangedEvent.getNewValue();
        IDocumentElementNode iDocumentElementNode5 = iDocumentElementNode3.getPreviousSibling() == null || iDocumentElementNode3.equals(iDocumentElementNode4.getPreviousSibling()) ? iDocumentElementNode3 : iDocumentElementNode4;
        IDocumentElementNode iDocumentElementNode6 = iDocumentElementNode2 = iDocumentElementNode5.equals(iDocumentElementNode3) ? iDocumentElementNode4 : iDocumentElementNode3;
        if (iDocumentElementNode5.getOffset() < 0 && iDocumentElementNode2.getOffset() < 2) {
            TextEdit textEdit = this.fOperationTable.get(iDocumentElementNode5);
            if (textEdit == null) {
                this.insertNode(iDocumentElementNode, arrayList);
            } else {
                TextEdit textEdit2 = this.fOperationTable.get(iDocumentElementNode2);
                arrayList.set(arrayList.indexOf(textEdit), textEdit2);
                arrayList.set(arrayList.indexOf(textEdit2), textEdit);
            }
        } else if (iDocumentElementNode5.getOffset() > -1 && iDocumentElementNode2.getOffset() > -1) {
            IRegion iRegion = this.getMoveRegion(iDocumentElementNode5);
            MoveSourceEdit moveSourceEdit = new MoveSourceEdit(iRegion.getOffset(), iRegion.getLength());
            iRegion = this.getMoveRegion(iDocumentElementNode2);
            moveSourceEdit.setTargetEdit(new MoveTargetEdit(iRegion.getOffset()));
            MoveSourceEdit moveSourceEdit2 = this.fMoveOperations.get(iDocumentElementNode5);
            if (moveSourceEdit2 != null) {
                arrayList.set(arrayList.indexOf(moveSourceEdit2), (TextEdit)moveSourceEdit);
            } else {
                moveSourceEdit2 = this.fMoveOperations.get(iDocumentElementNode2);
                if (moveSourceEdit2 != null && moveSourceEdit2.getTargetEdit().getOffset() == moveSourceEdit.getOffset()) {
                    this.fMoveOperations.remove(iDocumentElementNode2);
                    arrayList.remove(moveSourceEdit2);
                    return;
                }
                arrayList.add((TextEdit)moveSourceEdit);
            }
            this.fMoveOperations.put(iDocumentElementNode5, moveSourceEdit);
        } else {
            this.insertNode(iDocumentElementNode5.getOffset() < 0 ? iDocumentElementNode5 : iDocumentElementNode2, arrayList);
        }
    }

    private void removeNode(IDocumentElementNode iDocumentElementNode, ArrayList<TextEdit> arrayList) {
        TextEdit textEdit;
        TextEdit textEdit2 = this.fOperationTable.get(iDocumentElementNode);
        if (textEdit2 != null) {
            arrayList.remove(textEdit2);
            this.fOperationTable.remove(iDocumentElementNode);
        }
        if ((textEdit = (TextEdit)this.fMoveOperations.get(iDocumentElementNode)) != null) {
            arrayList.remove(textEdit);
            this.fMoveOperations.remove(iDocumentElementNode);
        }
        if (iDocumentElementNode.getOffset() > -1) {
            DeleteEdit deleteEdit = this.getDeleteNodeOperation(iDocumentElementNode);
            arrayList.add((TextEdit)deleteEdit);
            this.fOperationTable.put(iDocumentElementNode, (TextEdit)deleteEdit);
        } else if (textEdit2 == null && textEdit == null) {
            this.insertNode(iDocumentElementNode, arrayList);
        }
    }

    private boolean shouldTerminateElement(IDocument iDocument, int n) {
        try {
            return iDocument.get(n - 1, 1).toCharArray()[0] == '/';
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    @Override
    protected void addTextEditOperation(ArrayList<TextEdit> arrayList, IModelChangedEvent iModelChangedEvent) {
        Object[] objectArray = iModelChangedEvent.getChangedObjects();
        if (objectArray != null) {
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray2[n2];
                switch (iModelChangedEvent.getChangeType()) {
                    case 2: {
                        if (!(object instanceof IDocumentElementNode)) break;
                        this.removeNode((IDocumentElementNode)object, arrayList);
                        break;
                    }
                    case 1: {
                        if (!(object instanceof IDocumentElementNode)) break;
                        this.insertNode((IDocumentElementNode)object, arrayList);
                        break;
                    }
                    case 3: {
                        if (object instanceof IDocumentElementNode) {
                            IDocumentElementNode iDocumentElementNode = (IDocumentElementNode)object;
                            IDocumentAttributeNode iDocumentAttributeNode = iDocumentElementNode.getDocumentAttribute(iModelChangedEvent.getChangedProperty());
                            if (iDocumentAttributeNode != null) {
                                this.addAttributeOperation(iDocumentAttributeNode, arrayList, iModelChangedEvent);
                                break;
                            }
                            if (!(iModelChangedEvent.getOldValue() instanceof IDocumentElementNode) || !(iModelChangedEvent.getNewValue() instanceof IDocumentElementNode)) break;
                            this.modifyNode(iDocumentElementNode, arrayList, iModelChangedEvent);
                            break;
                        }
                        if (!(object instanceof IDocumentTextNode)) break;
                        this.addElementContentOperation((IDocumentTextNode)object, arrayList);
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    protected void flushModel(IDocument iDocument) {
        Object object;
        this.removeUnnecessaryOperations();
        if (this.fOperationTable.size() == 1 && (object = this.fOperationTable.keySet().iterator().next()) instanceof IDocumentElementNode && this.fEditOperations.get(0) instanceof InsertEdit && ((IDocumentElementNode)object).getParentNode() == null) {
            iDocument.set(((IDocumentElementNode)object).write(true));
            this.fOperationTable.clear();
            this.fEditOperations.clear();
            return;
        }
        this.reorderInsertEdits(this.fEditOperations);
        this.fOperationTable.clear();
        this.fMoveOperations.clear();
        super.flushModel(iDocument);
    }

    @Override
    protected IDocumentSetupParticipant getDocumentSetupParticipant() {
        return new XMLDocumentSetupParticipant();
    }

    protected HashMap<Object, TextEdit> getOperationTable() {
        return this.fOperationTable;
    }

    protected String getWritableAttributeNodeValue(String string) {
        return MTJXMLHelper.getWritableString((String)string);
    }

    protected String getWritableTextNodeString(IDocumentTextNode iDocumentTextNode) {
        return iDocumentTextNode.write();
    }

    protected void printDeletionRange(int n, int n2) {
        try {
            String string = this.getDocumentProvider().getDocument((Object)this.getInput()).get(n, n2);
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n3 < string.length()) {
                char c = string.charAt(n3);
                if (c == '\n') {
                    stringBuffer.append("\\n");
                } else if (c == '\r') {
                    stringBuffer.append("\\r");
                } else if (c == '\t') {
                    stringBuffer.append("\\t");
                } else if (c == ' ') {
                    stringBuffer.append('*');
                } else {
                    stringBuffer.append(c);
                }
                ++n3;
            }
            System.out.println(stringBuffer.toString());
        }
        catch (BadLocationException badLocationException) {}
    }

    protected void removeUnnecessaryOperations() {
        for (TextEdit textEdit : this.fOperationTable.values()) {
            TextEdit textEdit2;
            IDocumentTextNode iDocumentTextNode;
            IDocumentAttributeNode[] iDocumentAttributeNodeArray;
            IDocumentElementNode iDocumentElementNode;
            if (!(textEdit instanceof IDocumentElementNode) || (iDocumentElementNode = (IDocumentElementNode)textEdit).getOffset() <= -1) continue;
            IDocumentAttributeNode[] iDocumentAttributeNodeArray2 = iDocumentAttributeNodeArray = iDocumentElementNode.getNodeAttributes();
            int n = iDocumentAttributeNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                iDocumentTextNode = iDocumentAttributeNodeArray2[n2];
                TextEdit textEdit3 = this.fOperationTable.remove(iDocumentTextNode);
                if (textEdit3 != null) {
                    this.fEditOperations.remove(textEdit3);
                }
                ++n2;
            }
            iDocumentTextNode = iDocumentElementNode.getTextNode();
            if (iDocumentTextNode == null || (textEdit2 = this.fOperationTable.remove(iDocumentTextNode)) == null) continue;
            this.fEditOperations.remove(textEdit2);
        }
    }

    protected abstract void reorderInsertEdits(ArrayList<TextEdit> var1);
}

