/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.pulsar.ui.view;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.mtj.internal.provisional.pulsar.core.ISDK;
import org.eclipse.mtj.internal.provisional.pulsar.core.ISDKRepository;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.PlatformUI;

public class InstallersLabelProvider
extends ColumnLabelProvider {
    private Device device;
    private Map<Object, Image> imageCache;
    private static final int IMAGE_DIMENSION = 16;

    public InstallersLabelProvider(Device device) {
        this.device = device;
    }

    private Image getRepositoryImage(ISDKRepository iSDKRepository) {
        this.ensureImageCache();
        if (!this.imageCache.containsKey(iSDKRepository)) {
            Image image = null;
            try {
                ImageDescriptor imageDescriptor = iSDKRepository.getIconImageDescriptor();
                ImageData imageData = imageDescriptor.getImageData();
                if (imageData != null) {
                    if (imageData.width == 16 && imageData.height == 16) {
                        image = imageDescriptor.createImage(this.device);
                    } else {
                        ImageData imageData2 = imageData.scaledTo(16, 16);
                        image = new Image(this.device, imageData2);
                    }
                }
            }
            catch (Exception exception) {}
            if (image == null) {
                image = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER").createImage();
            }
            this.imageCache.put(iSDKRepository, image);
        }
        return this.imageCache.get(iSDKRepository);
    }

    private void ensureImageCache() {
        if (this.imageCache == null) {
            this.imageCache = new HashMap<Object, Image>();
        }
    }

    private Image getProvUIImage(String string) {
        this.ensureImageCache();
        if (!this.imageCache.containsKey(string)) {
            ImageDescriptor imageDescriptor = ProvUIActivator.getDefault().getImageRegistry().getDescriptor(string);
            this.imageCache.put(string, imageDescriptor.createImage(this.device));
        }
        return this.imageCache.get(string);
    }

    public Image getImage(Object object) {
        Object object2 = ((TreeNode)object).getValue();
        if (object2 instanceof ISDKRepository) {
            return this.getRepositoryImage((ISDKRepository)object2);
        }
        if (object2 instanceof ISDK) {
            return this.getProvUIImage("obj/iu_obj.gif");
        }
        if (object2 instanceof String) {
            return this.getProvUIImage("obj/category_obj.gif");
        }
        return null;
    }

    public String getText(Object object) {
        Object object2 = ((TreeNode)object).getValue();
        if (object2 instanceof ISDK) {
            return ((ISDK)object2).getName();
        }
        if (object2 instanceof ISDKRepository) {
            return ((ISDKRepository)object2).getName();
        }
        if (object2 instanceof String) {
            return (String)object2;
        }
        return null;
    }

    public void dispose() {
        for (Image image : this.imageCache.values()) {
            image.dispose();
        }
        super.dispose();
    }
}

