/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.IMetaData;
import org.eclipse.mtj.core.project.ProjectType;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.sdk.device.IAPI;
import org.eclipse.mtj.core.sdk.device.IDeviceClasspath;
import org.eclipse.mtj.core.sdk.device.IDeviceFinder;
import org.eclipse.mtj.core.sdk.device.IDeviceRegistry;
import org.eclipse.mtj.core.sdk.device.ILibrary;
import org.eclipse.mtj.core.sdk.device.ILibraryImporter;
import org.eclipse.mtj.core.symbol.ISymbolSetFactory;
import org.eclipse.mtj.core.symbol.ISymbolSetRegistry;
import org.eclipse.mtj.internal.core.build.preprocessor.PreprocessedSourceMapper;
import org.eclipse.mtj.internal.core.build.preverifier.StandardPreverifierFactory;
import org.eclipse.mtj.internal.core.hook.sourceMapper.SourceMapper;
import org.eclipse.mtj.internal.core.hook.sourceMapper.SourceMapperAccess;
import org.eclipse.mtj.internal.core.project.midp.MetaData;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.sdk.device.DeviceClasspath;
import org.eclipse.mtj.internal.core.sdk.device.DeviceFinder;
import org.eclipse.mtj.internal.core.sdk.device.DeviceRegistry;
import org.eclipse.mtj.internal.core.sdk.device.midp.MIDPAPI;
import org.eclipse.mtj.internal.core.sdk.device.midp.MIDPLibrary;
import org.eclipse.mtj.internal.core.sdk.device.midp.UEILibraryImporter;
import org.eclipse.mtj.internal.core.symbol.SymbolSetFactory;
import org.eclipse.mtj.internal.core.symbol.SymbolSetRegistry;
import org.eclipse.mtj.internal.core.util.MTJBuildPropertiesResourceListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class MTJCore
extends Plugin {
    private static MTJCore plugin;

    public static IMetaData createMetaData(IProject iProject, ProjectType projectType) {
        switch (projectType) {
            case MIDLET_SUITE: {
                return new MetaData(iProject);
            }
        }
        return null;
    }

    public static IAPI createNewAPI(ProjectType projectType) {
        switch (projectType) {
            case MIDLET_SUITE: {
                return new MIDPAPI();
            }
        }
        return null;
    }

    public static IDeviceClasspath createNewDeviceClasspath() {
        return new DeviceClasspath();
    }

    public static ILibrary createNewLibrary(ProjectType projectType) {
        switch (projectType) {
            case MIDLET_SUITE: {
                return new MIDPLibrary();
            }
        }
        return null;
    }

    public static IPreverifier createPreverifier(String string, Object object) throws CoreException {
        IPreverifier iPreverifier = null;
        if (string.equals("org.eclipse.mtj.preverifier.standard") && object instanceof File) {
            iPreverifier = StandardPreverifierFactory.createPreverifier((File)object);
        }
        return iPreverifier;
    }

    public static IMTJProject geMTJProject(IProject iProject) {
        if (MidletSuiteFactory.isMidletSuiteProject(iProject)) {
            IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
            IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(iJavaProject);
            return iMidletSuiteProject;
        }
        return null;
    }

    public static String getDeploymentDirectoryName() {
        return MTJCore.getMTJCore().getPluginPreferences().getString("deployment_dir");
    }

    public static IDeviceFinder getDeviceFinder() {
        return DeviceFinder.getInstance();
    }

    public static IDeviceRegistry getDeviceRegistry() {
        return DeviceRegistry.getInstance();
    }

    public static ILibraryImporter getLibraryImporter(String string) {
        UEILibraryImporter uEILibraryImporter = null;
        if (string.equals("org.eclipse.mtj.libraryimporter.uei")) {
            uEILibraryImporter = new UEILibraryImporter();
        }
        return uEILibraryImporter;
    }

    public static MTJCore getMTJCore() {
        return plugin;
    }

    public static String getMTJCoreVersion() {
        Bundle bundle = MTJCore.getMTJCore().getBundle();
        return (String)bundle.getHeaders().get("Bundle-Version");
    }

    public static File getProguardJarFile() {
        String string = MTJCore.getMTJCore().getPluginPreferences().getString("proguard_dir");
        File file = new File(string);
        File file2 = new File(file, "lib");
        File file3 = new File(file2, "proguard.jar");
        return file3;
    }

    public static InputStream getResourceAsStream(IPath iPath) {
        InputStream inputStream = null;
        URL uRL = FileLocator.find((Bundle)MTJCore.getMTJCore().getBundle(), (IPath)iPath, null);
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return inputStream;
    }

    public static String getResourcesDirectoryName() {
        return MTJCore.getMTJCore().getPluginPreferences().getString("resources_dir");
    }

    public static ISymbolSetFactory getSymbolSetFactory() {
        return SymbolSetFactory.getInstance();
    }

    public static ISymbolSetRegistry getSymbolSetRegistry() {
        return SymbolSetRegistry.getInstance();
    }

    public static String getVerifiedOutputDirectoryName() {
        return MTJCore.getMTJCore().getPluginPreferences().getString("verified_dir");
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public MTJCore() {
        if (plugin == null) {
            plugin = this;
        }
        MTJCore.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
                switch (iResourceChangeEvent.getType()) {
                    case 4: {
                        IProject iProject;
                        IMTJProject iMTJProject;
                        IResource iResource = iResourceChangeEvent.getResource();
                        if (!(iResource instanceof IProject) || (iMTJProject = MidletSuiteFactory.getMidletSuiteProject((iProject = (IProject)iResource).getName())) == null) break;
                        MidletSuiteFactory.removeMidletSuiteProject(iMTJProject.getJavaProject());
                    }
                }
            }
        });
        MTJCore.getWorkspace().addResourceChangeListener((IResourceChangeListener)new MTJBuildPropertiesResourceListener(), 1);
    }

    public static String getPluginId() {
        return MTJCore.getMTJCore().getBundle().getSymbolicName();
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        SourceMapperAccess.setSourceMapper((SourceMapper)new PreprocessedSourceMapper());
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
    }
}

