/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.jmunit.core.api;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.internal.jmunit.JMUnitMessages;
import org.eclipse.mtj.internal.jmunit.core.api.ITestFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMUnitTestFinder
implements ITestFinder {
    private String fSuperclass;

    public JMUnitTestFinder(String string) {
        this.fSuperclass = string;
    }

    public void findTestImplementorClasses(ITypeHierarchy iTypeHierarchy, IType iType, IRegion iRegion, Set<IType> set) throws JavaModelException {
        IType[] iTypeArray;
        IType[] iTypeArray2 = iTypeArray = iTypeHierarchy.getAllSubtypes(iType);
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType iType2 = iTypeArray2[n2];
            int n3 = iTypeHierarchy.getCachedFlags(iType2);
            if (!Flags.isInterface((int)n3) && !Flags.isAbstract((int)n3) && iRegion.contains((IJavaElement)iType2) && this.isAccessibleClass(iType2)) {
                set.add(iType2);
            }
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void findTestsInContainer(IJavaElement iJavaElement, Set<IType> set, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iJavaElement == null || set == null) {
            throw new IllegalArgumentException();
        }
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask(JMUnitMessages.JMUnitTestFinder_findTestsInContainer_taskName, 10);
        try {
            if (iJavaElement instanceof IType) {
                if (this.isTest((IType)iJavaElement)) {
                    set.add((IType)iJavaElement);
                }
            } else if (iJavaElement instanceof ICompilationUnit) {
                IType[] iTypeArray;
                IType[] iTypeArray2 = iTypeArray = ((ICompilationUnit)iJavaElement).getAllTypes();
                int n = iTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IType iType = iTypeArray2[n2];
                    if (this.isTest(iType)) {
                        set.add(iType);
                    }
                    ++n2;
                }
            } else {
                this.findTestCases(iJavaElement, set, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 7));
                if (iProgressMonitor.isCanceled()) {
                    return;
                }
            }
            if (!iProgressMonitor.isCanceled()) return;
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public IRegion getRegion(IJavaElement iJavaElement) throws JavaModelException {
        IRegion iRegion = JavaCore.newRegion();
        if (iJavaElement.getElementType() == 2) {
            IPackageFragmentRoot[] iPackageFragmentRootArray = ((IJavaProject)iJavaElement).getPackageFragmentRoots();
            int n = 0;
            while (n < iPackageFragmentRootArray.length) {
                if (!iPackageFragmentRootArray[n].isArchive()) {
                    iRegion.add((IJavaElement)iPackageFragmentRootArray[n]);
                }
                ++n;
            }
        } else {
            iRegion.add(iJavaElement);
        }
        return iRegion;
    }

    public boolean isAccessibleClass(IType iType) throws JavaModelException {
        int n = iType.getFlags();
        if (Flags.isInterface((int)n)) {
            return false;
        }
        IJavaElement iJavaElement = iType.getParent();
        while (!(iJavaElement instanceof ICompilationUnit) && !(iJavaElement instanceof IClassFile)) {
            if (!(iJavaElement instanceof IType && Flags.isStatic((int)n) && Flags.isPublic((int)n))) {
                return false;
            }
            n = ((IType)iJavaElement).getFlags();
            iJavaElement = iJavaElement.getParent();
        }
        return true;
    }

    @Override
    public boolean isTest(IType iType) throws CoreException {
        return this.isAccessibleClass(iType) && !Flags.isAbstract((int)iType.getFlags()) && this.isTestImplementor(iType);
    }

    public boolean isTestImplementor(IType iType) throws JavaModelException {
        IType[] iTypeArray;
        ITypeHierarchy iTypeHierarchy = iType.newSupertypeHierarchy(null);
        IType[] iTypeArray2 = iTypeArray = iTypeHierarchy.getAllClasses();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType iType2 = iTypeArray2[n2];
            if (this.fSuperclass.equals(iType2.getFullyQualifiedName('.'))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void findTestCases(IJavaElement iJavaElement, Set<IType> set, IProgressMonitor iProgressMonitor) throws JavaModelException {
        IJavaProject iJavaProject = iJavaElement.getJavaProject();
        IType iType = iJavaProject.findType(this.fSuperclass);
        if (iType == null) {
            return;
        }
        IRegion iRegion = this.getRegion(iJavaElement);
        ITypeHierarchy iTypeHierarchy = iJavaProject.newTypeHierarchy(iType, iRegion, iProgressMonitor);
        this.findTestImplementorClasses(iTypeHierarchy, iType, iRegion, set);
    }
}

