/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.internal.core.build.MTJBuildProperties;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTJBuildPropertiesResourceListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
        if (iResourceDelta == null) {
            return;
        }
        try {
            AddsAndRemovesCollector addsAndRemovesCollector = new AddsAndRemovesCollector();
            iResourceDelta.accept((IResourceDeltaVisitor)addsAndRemovesCollector);
            List<IResourceDelta> list = this.filterResourceDeltas(addsAndRemovesCollector.getResourceDeltas());
            this.updateBuildProperties(list);
        }
        catch (Exception exception) {
            MTJLogger.log(4, exception);
        }
    }

    private void updateBuildProperties(List<IResourceDelta> list) throws IOException {
        for (IResourceDelta iResourceDelta : list) {
            IResource iResource = iResourceDelta.getResource();
            IProject iProject = iResource.getProject();
            IMTJProject iMTJProject = MidletSuiteFactory.getMidletSuiteProject(iProject.getName());
            MTJBuildProperties mTJBuildProperties = MTJBuildProperties.getBuildProperties(iMTJProject);
            MTJRuntimeList mTJRuntimeList = iMTJProject.getRuntimeList();
            for (MTJRuntime mTJRuntime : mTJRuntimeList) {
                ArrayList<IResource> arrayList = new ArrayList<IResource>();
                arrayList.addAll(Arrays.asList(mTJBuildProperties.getBuildProperty(mTJRuntime)));
                if (iResourceDelta.getKind() == 2) {
                    arrayList.remove(iResource);
                } else if (iResourceDelta.getKind() == 1 && !arrayList.contains(iResource)) {
                    arrayList.add(iResource);
                }
                mTJBuildProperties.setBuildProperty(mTJRuntime, arrayList.toArray(new IResource[arrayList.size()]));
            }
            mTJBuildProperties.store();
        }
    }

    private List<IResourceDelta> filterResourceDeltas(List<IResourceDelta> list) throws CoreException {
        ArrayList<IResourceDelta> arrayList = new ArrayList<IResourceDelta>();
        for (IResourceDelta iResourceDelta : list) {
            IResource iResource = iResourceDelta.getResource();
            IProject iProject = iResource.getProject();
            if (!iProject.exists() || !iProject.hasNature("org.eclipse.jdt.core.javanature")) continue;
            IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
            IResource[] iResourceArray = Utils.getSourceFolders(iJavaProject);
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource2 = iResourceArray[n2];
                if (iResource2.getProjectRelativePath().isPrefixOf(iResource.getProjectRelativePath())) {
                    arrayList.add(iResourceDelta);
                }
                ++n2;
            }
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AddsAndRemovesCollector
    implements IResourceDeltaVisitor {
        private List<IResourceDelta> deltas = new ArrayList<IResourceDelta>();

        public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
            IResource iResource = iResourceDelta.getResource();
            int n = iResourceDelta.getKind();
            if ((n == 1 || n == 2) && iResource.getProject() != null && iResource.getType() == 1) {
                this.deltas.add(iResourceDelta);
            }
            return true;
        }

        public List<IResourceDelta> getResourceDeltas() {
            return this.deltas;
        }
    }
}

