/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.provisional.pulsar.core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mtj.internal.provisional.pulsar.core.IInstallationEnvironment;

public class IUInstallationEnvironment
implements IInstallationEnvironment {
    private String os = "all";
    private String ws = "all";
    private String arch = "all";

    public IUInstallationEnvironment(String string) {
        if (string != null) {
            Matcher matcher = Pattern.compile("osgi[.]([^=])+[=]([^)])+").matcher(string);
            while (matcher.find()) {
                String[] stringArray = matcher.group().split("=");
                this.processKeyValuePair(stringArray);
            }
        }
    }

    private void processKeyValuePair(String[] stringArray) {
        String string = stringArray[0];
        if (string.equals("osgi.os")) {
            this.os = stringArray[1].trim();
        } else if (string.equals("osgi.ws")) {
            this.ws = stringArray[1].trim();
        } else if (string.equals("osgi.arch")) {
            this.arch = stringArray[1].trim();
        }
    }

    public String getTargetOS() {
        return this.os;
    }

    public String getTargetOSArch() {
        return this.arch;
    }

    public String getTargetWS() {
        return this.ws;
    }
}

