/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.preverifier.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mtj.preverifier.IPreverificationPolicy;
import org.eclipse.mtj.preverifier.internal.PreverifierMethodNode;
import org.eclipse.mtj.preverifier.internal.results.ClassNodeErrorInformation;
import org.eclipse.mtj.preverifier.internal.results.FieldErrorInformation;
import org.eclipse.mtj.preverifier.internal.results.MethodNodeErrorInformation;
import org.eclipse.mtj.preverifier.results.PreverificationError;
import org.eclipse.mtj.preverifier.results.PreverificationErrorLocation;
import org.eclipse.mtj.preverifier.results.PreverificationErrorLocationType;
import org.eclipse.mtj.preverifier.results.PreverificationErrorType;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public class PreverificationClassNode
extends ClassNode {
    private static final Type BOOLEAN_TYPE = Type.getType((String)"Ljava/lang/Boolean;");
    private static final Type CHARACTER_TYPE = Type.getType((String)"Ljava/lang/Character;");
    private static final Type BYTE_TYPE = Type.getType((String)"Ljava/lang/Byte;");
    private static final Type SHORT_TYPE = Type.getType((String)"Ljava/lang/Short;");
    private static final Type INTEGER_TYPE = Type.getType((String)"Ljava/lang/Integer;");
    private static final Type FLOAT_TYPE = Type.getType((String)"Ljava/lang/Float;");
    private static final Type LONG_TYPE = Type.getType((String)"Ljava/lang/Long;");
    private static final Type DOUBLE_TYPE = Type.getType((String)"Ljava/lang/Double;");
    private static final Type VOID_TYPE = Type.getType((String)"Ljava/lang/Void;");
    private IPreverificationPolicy preverificationPolicy;
    private ArrayList errorList;
    private ClassLoader classLoader;
    private Map validTypes;
    private Class objectClass;
    private Class floatClass;
    private Class doubleClass;

    public PreverificationClassNode(IPreverificationPolicy iPreverificationPolicy, ClassLoader classLoader) {
        this.preverificationPolicy = iPreverificationPolicy;
        this.errorList = new ArrayList();
        this.classLoader = classLoader;
        this.validTypes = new HashMap();
        try {
            this.objectClass = Class.forName("java.lang.Object", true, this.classLoader);
            this.floatClass = Class.forName("java.lang.Float", true, this.classLoader);
            this.doubleClass = Class.forName("java.lang.Double", true, this.classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    public List getErrorList() {
        return this.errorList;
    }

    public boolean hasError() {
        return this.errorList.size() > 0;
    }

    public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
        FieldVisitor fieldVisitor = null;
        Type type = Type.getType((String)string2);
        PreverificationErrorType preverificationErrorType = this.validateType(type);
        if (preverificationErrorType == PreverificationErrorType.NO_ERROR) {
            Object object2 = (n & 8) != 0 ? object : null;
            fieldVisitor = super.visitField(n, string, string2, string3, object2);
        } else {
            ClassNodeErrorInformation classNodeErrorInformation = new ClassNodeErrorInformation(this);
            FieldErrorInformation fieldErrorInformation = new FieldErrorInformation(string, string2);
            PreverificationErrorLocation preverificationErrorLocation = new PreverificationErrorLocation(PreverificationErrorLocationType.CLASS_FIELD, classNodeErrorInformation, null, fieldErrorInformation, -1);
            PreverificationError preverificationError = new PreverificationError(preverificationErrorType, preverificationErrorLocation, null);
            this.getErrorList().add(preverificationError);
        }
        return fieldVisitor;
    }

    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        boolean bl;
        PreverifierMethodNode preverifierMethodNode = new PreverifierMethodNode(this, n, string, string2, string3, stringArray);
        boolean bl2 = !this.preverificationPolicy.areNativeMethodsAllowed() && (n & 0x100) != 0;
        boolean bl3 = !this.preverificationPolicy.areFinalizersAllowed() && string.equals("finalize") && Type.getArgumentTypes((String)string2).length == 0;
        PreverificationErrorType preverificationErrorType = this.getMethodSignatureError(string2);
        boolean bl4 = bl = preverificationErrorType != PreverificationErrorType.NO_ERROR;
        if (bl2 || bl3 || bl) {
            PreverificationError preverificationError;
            ClassNodeErrorInformation classNodeErrorInformation = new ClassNodeErrorInformation(this);
            MethodNodeErrorInformation methodNodeErrorInformation = new MethodNodeErrorInformation(classNodeErrorInformation, preverifierMethodNode);
            PreverificationErrorLocation preverificationErrorLocation = new PreverificationErrorLocation(PreverificationErrorLocationType.METHOD_SIGNATURE, classNodeErrorInformation, methodNodeErrorInformation, null, -1);
            if (bl2) {
                preverificationError = new PreverificationError(PreverificationErrorType.NATIVE, preverificationErrorLocation, null);
                this.getErrorList().add(preverificationError);
            }
            if (bl3) {
                preverificationError = new PreverificationError(PreverificationErrorType.FINALIZERS, preverificationErrorLocation, null);
                this.getErrorList().add(preverificationError);
            }
            if (bl) {
                preverificationError = new PreverificationError(preverificationErrorType, preverificationErrorLocation, null);
                this.getErrorList().add(preverificationError);
            }
        }
        return preverifierMethodNode;
    }

    private Type getObjectType(Type type) {
        Type type2 = type;
        switch (type.getSort()) {
            case 1: {
                type2 = BOOLEAN_TYPE;
                break;
            }
            case 2: {
                type2 = CHARACTER_TYPE;
                break;
            }
            case 3: {
                type2 = BYTE_TYPE;
                break;
            }
            case 4: {
                type2 = SHORT_TYPE;
                break;
            }
            case 5: {
                type2 = INTEGER_TYPE;
                break;
            }
            case 6: {
                type2 = FLOAT_TYPE;
                break;
            }
            case 7: {
                type2 = LONG_TYPE;
                break;
            }
            case 8: {
                type2 = DOUBLE_TYPE;
                break;
            }
            case 0: {
                type2 = VOID_TYPE;
                break;
            }
            case 9: {
                type2 = this.getObjectType(type.getElementType());
            }
        }
        return type2;
    }

    ClassLoader getClassLoader() {
        return this.classLoader;
    }

    IPreverificationPolicy getPreverificationPolicy() {
        return this.preverificationPolicy;
    }

    private Class getTypeClass(Type type) throws ClassNotFoundException {
        String string = type.getInternalName().replace('/', '.');
        return Class.forName(string, true, this.classLoader);
    }

    private boolean isDisallowedType(Class clazz) {
        boolean bl = false;
        if (!this.getPreverificationPolicy().isFloatingPointAllowed()) {
            bl = this.isFloatingPointType(clazz);
        }
        return bl;
    }

    private boolean isFloatingPointType(Class clazz) {
        return clazz == this.floatClass || clazz == this.doubleClass;
    }

    private PreverificationErrorType getMethodSignatureError(String string) {
        Type type = Type.getReturnType((String)string);
        PreverificationErrorType preverificationErrorType = this.validateType(type);
        if (preverificationErrorType != PreverificationErrorType.NO_ERROR) {
            Type[] typeArray = Type.getArgumentTypes((String)string);
            int n = 0;
            while (n < typeArray.length && preverificationErrorType != PreverificationErrorType.NO_ERROR) {
                preverificationErrorType = this.validateType(typeArray[n]);
                ++n;
            }
        }
        return preverificationErrorType;
    }

    PreverificationErrorType validateType(Type type) {
        PreverificationErrorType preverificationErrorType = (PreverificationErrorType)this.validTypes.get(type);
        if (preverificationErrorType == null) {
            Type type2 = this.getObjectType(type);
            try {
                Class clazz = this.getTypeClass(type2);
                preverificationErrorType = this.validateHierarchy(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                preverificationErrorType = PreverificationErrorType.MISSING_TYPE;
            }
            this.validTypes.put(type, preverificationErrorType);
        }
        return preverificationErrorType;
    }

    private PreverificationErrorType validateHierarchy(Class clazz) {
        PreverificationErrorType preverificationErrorType = null;
        preverificationErrorType = clazz == null || clazz == this.objectClass ? PreverificationErrorType.NO_ERROR : (this.isDisallowedType(clazz) ? PreverificationErrorType.FLOATING_POINT : this.validateHierarchy(clazz.getSuperclass()));
        return preverificationErrorType;
    }
}

