/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.editor.jad.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.ui.MTJUIStrings;
import org.eclipse.mtj.ui.internal.editor.jad.form.JADFormEditor;
import org.eclipse.mtj.ui.internal.utils.ManifestPreferenceStore;
import org.eclipse.mtj.ui.jadEditor.AbstractJADEditorPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class JADUserDefinedPropertiesEditorPage
extends AbstractJADEditorPage {
    private static final String PROP_KEY = "key";
    private static final String PROP_VALUE = "value";
    private static final String[] PROPERTIES = new String[]{"key", "value"};
    private static final List PROPERTY_LIST = Arrays.asList(PROPERTIES);
    private List userDefinedProperties = new ArrayList();
    private TableViewer tableViewer;
    private Button removeButton;
    private Button addButton;

    public JADUserDefinedPropertiesEditorPage(JADFormEditor jADFormEditor, String string) {
        super(jADFormEditor, "user_defined", string);
    }

    public JADUserDefinedPropertiesEditorPage() {
        super("user_defined", JADUserDefinedPropertiesEditorPage.getResourceString("editor.jad.tab.user_defined_properties"));
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        ManifestPreferenceStore manifestPreferenceStore = this.getPreferenceStore();
        for (KeyValuePair keyValuePair : this.userDefinedProperties) {
            manifestPreferenceStore.setValue(keyValuePair.fields[0], keyValuePair.fields[1]);
        }
        this.setDirty(false);
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        FormToolkit formToolkit = iManagedForm.getToolkit();
        Composite composite = this.createSectionComposite(iManagedForm);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(2, false));
        new Label(composite, 0);
        new Label(composite, 0);
        this.createTableViewer(formToolkit, composite);
        this.createButtons(formToolkit, composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.mtj.ui.help_JADUserDefinedPropertiesEditorPage");
    }

    protected String getSectionTitle() {
        return "User Defined Properties";
    }

    protected String getSectionDescription() {
        return "User Defined properties may be specified on this page";
    }

    public void setFocus() {
        this.tableViewer.getTable().setFocus();
    }

    protected void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        if (this.tableViewer != null) {
            this.tableViewer.setInput((Object)iEditorInput);
        }
        this.updateMidletProperties();
    }

    public void editorInputChanged() {
        this.updateMidletProperties();
    }

    private void addItem() {
        KeyValuePair keyValuePair = new KeyValuePair("New Key", "New Value");
        this.userDefinedProperties.add(keyValuePair);
        this.tableViewer.refresh();
        this.setDirty(true);
    }

    private void createButtons(FormToolkit formToolkit, Composite composite) {
        Composite composite2 = formToolkit.createComposite(composite);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 512;
        composite2.setLayout((Layout)fillLayout);
        this.addButton = formToolkit.createButton(composite2, JADUserDefinedPropertiesEditorPage.getResourceString("editor.button.add"), 8);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JADUserDefinedPropertiesEditorPage.this.addItem();
            }
        });
        formToolkit.createLabel(composite2, "");
        this.removeButton = formToolkit.createButton(composite2, JADUserDefinedPropertiesEditorPage.getResourceString("editor.button.remove"), 8);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JADUserDefinedPropertiesEditorPage.this.removeSelectedItems();
            }
        });
    }

    private void createTableViewer(FormToolkit formToolkit, Composite composite) {
        String[] stringArray = new String[]{JADUserDefinedPropertiesEditorPage.getResourceString("property.jad.userdef.key"), JADUserDefinedPropertiesEditorPage.getResourceString("property.jad.userdef.value")};
        int n = 68356;
        Table table = formToolkit.createTable(composite, n);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem tableItem = (TableItem)selectionEvent.item;
                JADUserDefinedPropertiesEditorPage.this.removeButton.setEnabled(tableItem.getParent().getSelectionCount() > 0);
            }
        });
        this.tableViewer = new TableViewer(table);
        TableLayout tableLayout = new TableLayout();
        int n2 = 100 / stringArray.length;
        int n3 = 0;
        while (n3 < stringArray.length) {
            TableColumn tableColumn = new TableColumn(table, 0);
            tableColumn.setText(stringArray[n3]);
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(n2));
            ++n3;
        }
        table.setLayout((Layout)tableLayout);
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.setCellModifier((ICellModifier)new CellModifier());
        this.tableViewer.setColumnProperties(PROPERTIES);
        this.tableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)});
        this.tableViewer.setInput((Object)this.getEditorInput());
        this.tableViewer.refresh();
    }

    private boolean isUserDefinedPropertyKey(String string) {
        JADFormEditor jADFormEditor = (JADFormEditor)this.getEditor();
        return jADFormEditor.isUserDefinedPropertyKey(string);
    }

    private void removeSelectedItems() {
        int[] nArray = this.tableViewer.getTable().getSelectionIndices();
        int n = nArray.length;
        while (n > 0) {
            int n2 = nArray[n - 1];
            KeyValuePair keyValuePair = (KeyValuePair)this.userDefinedProperties.remove(n2);
            this.getPreferenceStore().setToDefault(keyValuePair.fields[0]);
            --n;
        }
        this.setDirty(true);
        this.tableViewer.refresh();
    }

    private void updateMidletProperties() {
        this.userDefinedProperties.clear();
        ManifestPreferenceStore manifestPreferenceStore = this.getPreferenceStore();
        String[] stringArray = manifestPreferenceStore.preferenceNames();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (this.isUserDefinedPropertyKey(string)) {
                this.userDefinedProperties.add(new KeyValuePair(string, manifestPreferenceStore.getString(string)));
            }
            ++n;
        }
        if (this.tableViewer != null) {
            this.tableViewer.refresh();
        }
    }

    private static String getResourceString(String string) {
        return MTJUIStrings.getString(string);
    }

    private class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        public boolean canModify(Object object, String string) {
            return true;
        }

        public Object getValue(Object object, String string) {
            String string2 = null;
            if (object instanceof KeyValuePair) {
                KeyValuePair keyValuePair = (KeyValuePair)object;
                int n = this.getFieldIndex(string);
                if (n != -1) {
                    string2 = keyValuePair.fields[n];
                }
            }
            return string2;
        }

        public void modify(Object object, String string, Object object2) {
            if (object instanceof TableItem) {
                Object object3 = ((TableItem)object).getData();
                String string2 = (String)object2;
                if (object3 instanceof KeyValuePair) {
                    int n = this.getFieldIndex(string);
                    KeyValuePair keyValuePair = (KeyValuePair)object3;
                    if (n != -1) {
                        this.updateField(keyValuePair, string, n, string2);
                    }
                }
            }
        }

        private int getFieldIndex(String string) {
            return PROPERTY_LIST.indexOf(string);
        }

        private void updateField(KeyValuePair keyValuePair, String string, int n, String string2) {
            if (!keyValuePair.fields[n].equals(string2)) {
                keyValuePair.fields[n] = string2;
                JADUserDefinedPropertiesEditorPage.this.setDirty(true);
                JADUserDefinedPropertiesEditorPage.this.tableViewer.update((Object)keyValuePair, new String[]{string});
            }
        }
    }

    private static class KeyValuePair {
        String[] fields;

        KeyValuePair(String string, String string2) {
            this.fields = new String[]{string, string2};
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public Object[] getElements(Object object) {
            return JADUserDefinedPropertiesEditorPage.this.userDefinedProperties.toArray(new Object[JADUserDefinedPropertiesEditorPage.this.userDefinedProperties.size()]);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private static class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            KeyValuePair keyValuePair = (KeyValuePair)object;
            return keyValuePair.fields[n];
        }
    }
}

