/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.wizards.project;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.JavaCapabilityConfigurationPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.project.MetaData;
import org.eclipse.mtj.core.model.project.MidletSuiteFactory;
import org.eclipse.mtj.ui.MTJUIStrings;
import org.eclipse.mtj.ui.internal.MTJUIPlugin;
import org.eclipse.mtj.ui.internal.wizards.project.page.NewMidletProjectCreationPage;
import org.eclipse.mtj.ui.internal.wizards.project.page.NewMidletProjectJavaMECapabilityConfigPage;
import org.eclipse.mtj.ui.internal.wizards.project.page.NewMidletProjectPropertiesPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class NewMIDLetProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private IConfigurationElement configElement;
    private IDevice projectDevice = null;
    private boolean needsClasspathUpdate = true;
    private boolean projectLocationExisted = false;
    private NewMidletProjectJavaMECapabilityConfigPage javaWizardPage;
    private NewMidletProjectCreationPage mainPage;
    private NewMidletProjectPropertiesPage suitePropsPage;

    public NewMIDLetProjectWizard() {
        this.setWindowTitle(MTJUIStrings.getString("wiz.newproj.title"));
        ImageDescriptor imageDescriptor = MTJUIPlugin.getIconImageDescriptor("newjprj_wiz_M.gif");
        this.setDefaultPageImageDescriptor(imageDescriptor);
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new NewMidletProjectCreationPage();
        this.suitePropsPage = new NewMidletProjectPropertiesPage();
        this.javaWizardPage = new NewMidletProjectJavaMECapabilityConfigPage();
        this.addPage((IWizardPage)this.mainPage);
        this.addPage((IWizardPage)this.suitePropsPage);
        this.addPage((IWizardPage)this.javaWizardPage);
    }

    public boolean canFinish() {
        return this.suitePropsPage.canFlipToNextPage() && super.canFinish();
    }

    public IProject getCreatedProjectHandle() {
        return this.mainPage.getProjectHandle();
    }

    public IClasspathEntry getJavaMEClasspathContainer() {
        this.needsClasspathUpdate = false;
        Path path = new Path("org.elipse.mtj.JavaMEContainer/" + this.projectDevice);
        return JavaCore.newContainerEntry((IPath)path);
    }

    private IRunnableWithProgress getJavaNatureRunnable() {
        IRunnableWithProgress iRunnableWithProgress = this.javaWizardPage.getRunnable();
        if (iRunnableWithProgress == null) {
            iRunnableWithProgress = this.javaWizardPage.getRunnable();
        }
        return iRunnableWithProgress;
    }

    private IRunnableWithProgress getProjectCreationRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    File file = NewMIDLetProjectWizard.this.mainPage.getLocationPath().toFile();
                    NewMIDLetProjectWizard.this.projectLocationExisted = file.exists();
                    IProject iProject = NewMIDLetProjectWizard.this.mainPage.getProjectHandle();
                    JavaCapabilityConfigurationPage.createProject((IProject)iProject, (IPath)NewMIDLetProjectWizard.this.mainPage.getLocationPath(), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                }
                catch (CoreException coreException) {
                    throw new InvocationTargetException(coreException);
                }
            }
        };
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
    }

    public boolean performCancel() {
        if (!this.projectLocationExisted) {
            this.removeProject();
        }
        return super.performCancel();
    }

    public boolean performFinish() {
        boolean bl = true;
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                NewMIDLetProjectWizard.this.getProjectCreationRunnable().run(iProgressMonitor);
                IProject iProject = NewMIDLetProjectWizard.this.mainPage.getProjectHandle();
                IDevice iDevice = NewMIDLetProjectWizard.this.suitePropsPage.getSelectedDevice();
                MetaData metaData = new MetaData(iProject);
                metaData.setDevice(iDevice);
                try {
                    metaData.saveMetaData();
                }
                catch (CoreException coreException) {
                    throw new InvocationTargetException(coreException);
                }
                if (NewMIDLetProjectWizard.this.needsClasspathUpdate) {
                    NewMIDLetProjectWizard.this.javaWizardPage.updateConfiguration();
                    NewMIDLetProjectWizard.this.needsClasspathUpdate = false;
                }
                NewMIDLetProjectWizard.this.getJavaNatureRunnable().run(iProgressMonitor);
                String string = NewMIDLetProjectWizard.this.suitePropsPage.getJadFileName();
                IJavaProject iJavaProject = NewMIDLetProjectWizard.this.javaWizardPage.getJavaProject();
                MidletSuiteFactory.MidletSuiteCreationRunnable midletSuiteCreationRunnable = MidletSuiteFactory.getMidletSuiteCreationRunnable((IProject)iProject, (IJavaProject)iJavaProject, (IDevice)iDevice, (String)string);
                midletSuiteCreationRunnable.run(iProgressMonitor);
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(iRunnableWithProgress));
        }
        catch (InvocationTargetException invocationTargetException) {
            MTJCorePlugin.log((int)4, (String)"performFinish", (Throwable)invocationTargetException.getCause());
            bl = false;
        }
        catch (InterruptedException interruptedException) {
            bl = false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
        return bl;
    }

    private void removeProject() {
        IProject iProject;
        IJavaProject iJavaProject = this.javaWizardPage.getJavaProject();
        if (iJavaProject != null && (iProject = iJavaProject.getProject()) != null && iProject.exists()) {
            IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    iProgressMonitor.beginTask("##Remove Project", 3);
                    try {
                        try {
                            iProject.delete(true, false, iProgressMonitor);
                        }
                        catch (CoreException coreException) {
                            throw new InvocationTargetException(coreException);
                        }
                    }
                    finally {
                        iProgressMonitor.done();
                    }
                }
            };
            try {
                this.getContainer().run(false, true, iRunnableWithProgress);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) {
        this.configElement = iConfigurationElement;
    }

    public void setProjectDevice(IDevice iDevice) {
        this.projectDevice = iDevice;
        this.needsClasspathUpdate = true;
    }
}

