/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.jadEditor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.model.jad.DescriptorPropertyDescription;
import org.eclipse.mtj.ui.internal.editor.jad.form.JADAttributesRegistry;
import org.eclipse.mtj.ui.internal.editor.jad.form.JADFormEditor;
import org.eclipse.mtj.ui.internal.utils.ManifestPreferenceStore;
import org.eclipse.mtj.ui.jadEditor.AbstractJADEditorPage;
import org.eclipse.mtj.ui.jadEditor.ListDescriptorPropertyDescription;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class JADPropertiesEditorPage
extends AbstractJADEditorPage {
    private DescriptorPropertyDescription[] descriptors;
    protected FieldEditor[] fieldEditors;
    private Class<?> comboFieldEditorClass;
    private Constructor<?> comboEditorConstructor;

    public JADPropertiesEditorPage(String string, String string2) {
        super(string, string2);
    }

    public JADPropertiesEditorPage(JADFormEditor jADFormEditor, String string, String string2) {
        super(jADFormEditor, string, string2);
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        iProgressMonitor.setTaskName(this.getTitle());
        int n = 0;
        while (n < this.fieldEditors.length) {
            this.fieldEditors[n].store();
            ++n;
        }
        this.setDirty(false);
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        FormToolkit formToolkit = iManagedForm.getToolkit();
        Composite composite = this.createSectionComposite(iManagedForm);
        composite.setLayout((Layout)new GridLayout(2, false));
        new Label(composite, 0);
        new Label(composite, 0);
        DescriptorPropertyDescription[] descriptorPropertyDescriptionArray = this.getDescriptors();
        this.fieldEditors = new FieldEditor[descriptorPropertyDescriptionArray.length];
        int n = 0;
        while (n < descriptorPropertyDescriptionArray.length) {
            switch (descriptorPropertyDescriptionArray[n].getDataType()) {
                case 3: {
                    this.fieldEditors[n] = this.createIntegerFieldEditor(formToolkit, composite, descriptorPropertyDescriptionArray[n]);
                    break;
                }
                case 4: {
                    this.fieldEditors[n] = this.createComboFieldEditor(formToolkit, composite, descriptorPropertyDescriptionArray[n]);
                    break;
                }
                default: {
                    this.fieldEditors[n] = this.createStringFieldEditor(formToolkit, composite, descriptorPropertyDescriptionArray[n]);
                }
            }
            Label label = this.fieldEditors[n].getLabelControl(composite);
            formToolkit.adapt((Control)label, false, false);
            this.fieldEditors[n].setPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getProperty().equals("field_editor_value")) {
                        JADPropertiesEditorPage.this.setDirty(true);
                    }
                }
            });
            ++n;
        }
        Control[] controlArray = composite.getChildren();
        int n2 = 0;
        while (n2 < controlArray.length) {
            Control control = controlArray[n2];
            if (control instanceof Combo) {
                formToolkit.adapt(control, false, false);
            }
            ++n2;
        }
        this.updateEditComponents();
        this.addContextHelp(composite);
    }

    protected void addContextHelp(Composite composite) {
    }

    public void setFocus() {
        if (this.fieldEditors.length > 0) {
            this.fieldEditors[0].setFocus();
        }
    }

    protected void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        this.updateEditComponents();
        this.setDirty(false);
    }

    private FieldEditor createComboFieldEditor(FormToolkit formToolkit, Composite composite, DescriptorPropertyDescription descriptorPropertyDescription) {
        if (this.comboFieldEditorClass == null) {
            this.initializeComboFieldEditorSupport();
        }
        ListDescriptorPropertyDescription listDescriptorPropertyDescription = (ListDescriptorPropertyDescription)descriptorPropertyDescription;
        FieldEditor fieldEditor = null;
        try {
            fieldEditor = (FieldEditor)this.comboEditorConstructor.newInstance(new Object[]{listDescriptorPropertyDescription.getPropertyName(), listDescriptorPropertyDescription.getDisplayName(), listDescriptorPropertyDescription.getNamesAndValues(), composite});
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MTJCorePlugin.log((int)4, (Throwable)illegalArgumentException);
        }
        catch (InstantiationException instantiationException) {
            MTJCorePlugin.log((int)4, (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            MTJCorePlugin.log((int)4, (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            MTJCorePlugin.log((int)4, (Throwable)invocationTargetException);
        }
        return fieldEditor;
    }

    private IntegerFieldEditor createIntegerFieldEditor(FormToolkit formToolkit, Composite composite, DescriptorPropertyDescription descriptorPropertyDescription) {
        IntegerFieldEditor integerFieldEditor = new IntegerFieldEditor(descriptorPropertyDescription.getPropertyName(), descriptorPropertyDescription.getDisplayName(), composite);
        formToolkit.adapt((Control)integerFieldEditor.getTextControl(composite), true, true);
        return integerFieldEditor;
    }

    private StringFieldEditor createStringFieldEditor(FormToolkit formToolkit, Composite composite, DescriptorPropertyDescription descriptorPropertyDescription) {
        StringFieldEditor stringFieldEditor = new StringFieldEditor(descriptorPropertyDescription.getPropertyName(), descriptorPropertyDescription.getDisplayName(), composite);
        formToolkit.adapt((Control)stringFieldEditor.getTextControl(composite), true, true);
        return stringFieldEditor;
    }

    private void initializeComboFieldEditorSupport() {
        String[] stringArray = new String[]{"org.eclipse.jdt.internal.debug.ui.launcher.ComboFieldEditor", "org.eclipse.jface.preference.ComboFieldEditor"};
        int n = 0;
        while (this.comboFieldEditorClass == null && n < stringArray.length) {
            String string = stringArray[n];
            try {
                this.comboFieldEditorClass = Class.forName(string);
                this.comboEditorConstructor = this.comboFieldEditorClass.getConstructors()[0];
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (SecurityException securityException) {
                MTJCorePlugin.log((int)4, (Throwable)securityException);
            }
            ++n;
        }
    }

    private void updateEditComponents() {
        if (this.fieldEditors != null) {
            ManifestPreferenceStore manifestPreferenceStore = this.getPreferenceStore();
            int n = 0;
            while (n < this.fieldEditors.length) {
                FieldEditor fieldEditor = this.fieldEditors[n];
                fieldEditor.setPreferenceStore((IPreferenceStore)manifestPreferenceStore);
                fieldEditor.load();
                ++n;
            }
        }
    }

    protected String getSectionDescription() {
        return null;
    }

    protected String getSectionTitle() {
        return null;
    }

    public void editorInputChanged() {
        this.updateEditComponents();
    }

    public boolean isManagingProperty(String string) {
        boolean bl = false;
        int n = 0;
        while (n < this.getDescriptors().length) {
            DescriptorPropertyDescription descriptorPropertyDescription = this.getDescriptors()[n];
            if (string.equals(descriptorPropertyDescription.getPropertyName())) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    public DescriptorPropertyDescription[] getDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = this.doGetDescriptors();
        }
        return this.descriptors;
    }

    protected DescriptorPropertyDescription[] doGetDescriptors() {
        return JADAttributesRegistry.getJADAttrDescriptorsByPage(this.getId());
    }
}

