/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.editors.device.pages;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.preverifier.IPreverifier;
import org.eclipse.mtj.core.model.preverifier.StandardPreverifierFactory;
import org.eclipse.mtj.core.model.preverifier.impl.StandardPreverifier;
import org.eclipse.mtj.ui.editors.device.AbstractDeviceEditorPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DeviceBasicEditorPage
extends AbstractDeviceEditorPage {
    private static final Boolean[] BOOLEAN_VALUES = new Boolean[]{Boolean.TRUE, Boolean.FALSE};
    private Text nameText;
    private Text groupText;
    private Text descriptionText;
    private Text executableText;
    private Text launchCommandText;
    private ComboViewer debugServerCombo;
    private Text preverifyExecutableText;
    private Button preverifyBrowseButton;
    private boolean preverifierEnabled;
    private boolean javaExecutableDevice;
    private Button executableBrowseButton;

    public DeviceBasicEditorPage(Composite composite, boolean bl, int n) {
        super(composite, n);
        this.javaExecutableDevice = bl;
        this.preverifierEnabled = true;
    }

    public void commitDeviceChanges() throws CoreException {
        File file;
        this.editDevice.setName(this.nameText.getText());
        this.editDevice.setGroupName(this.groupText.getText());
        this.editDevice.setDescription(this.descriptionText.getText());
        if (!this.javaExecutableDevice) {
            this.editDevice.setExecutable(new File(this.executableText.getText()));
        }
        this.editDevice.setDebugServer(this.getBooleanSelection(this.debugServerCombo));
        this.editDevice.setLaunchCommandTemplate(this.launchCommandText.getText());
        if (this.preverifierEnabled && (file = new File(this.preverifyExecutableText.getText())).exists()) {
            StandardPreverifier standardPreverifier = StandardPreverifierFactory.createPreverifier((File)file);
            this.editDevice.setPreverifier((IPreverifier)standardPreverifier);
        }
    }

    public String getDescription() {
        return "Specify the basic information that defines the device";
    }

    public String getTitle() {
        return "Basic";
    }

    public void setDevice(IDevice iDevice) {
        super.setDevice(iDevice);
        this.initializeDeviceState();
    }

    protected void browseForExecutable(Text text) {
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        fileDialog.setText("Select Device Executable");
        File file = new File(text.getText());
        while (file != null) {
            if (file.exists()) {
                fileDialog.setFileName(file.toString());
                break;
            }
            file = file.getParentFile();
        }
        String string = fileDialog.open();
        if (string != null) {
            text.setText(string);
        }
    }

    private ComboViewer createBooleanComboViewer(Composite composite) {
        ComboViewer comboViewer = new ComboViewer(composite, 8);
        comboViewer.setContentProvider((IContentProvider)new BooleanContentProvider());
        comboViewer.setLabelProvider((IBaseLabelProvider)new BooleanLabelProvider());
        comboViewer.setInput(new Object());
        return comboViewer;
    }

    protected void addPageControls(Composite composite) {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                DeviceBasicEditorPage.this.updateState();
            }
        };
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(3, false));
        new Label(composite, 0).setText("Name:");
        this.nameText = new Text(composite, 2048);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addModifyListener(modifyListener);
        new Label(composite, 0);
        new Label(composite, 0).setText("Group:");
        this.groupText = new Text(composite, 2048);
        this.groupText.setLayoutData((Object)new GridData(768));
        this.groupText.addModifyListener(modifyListener);
        new Label(composite, 0);
        new Label(composite, 0).setText("Description:");
        this.descriptionText = new Text(composite, 2048);
        this.descriptionText.setLayoutData((Object)new GridData(768));
        new Label(composite, 0);
        new Label(composite, 0).setText("Executable:");
        this.executableText = new Text(composite, 2048);
        this.executableText.setLayoutData((Object)new GridData(768));
        this.executableText.addModifyListener(modifyListener);
        this.executableBrowseButton = new Button(composite, 8);
        this.executableBrowseButton.setText("Browse...");
        this.executableBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeviceBasicEditorPage.this.browseForExecutable(DeviceBasicEditorPage.this.executableText);
            }
        });
        new Label(composite, 0).setText("Preverifier:");
        this.preverifyExecutableText = new Text(composite, 2048);
        this.preverifyExecutableText.setLayoutData((Object)new GridData(768));
        this.preverifyExecutableText.addModifyListener(modifyListener);
        this.preverifyBrowseButton = new Button(composite, 8);
        this.preverifyBrowseButton.setText("Browse...");
        this.preverifyBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeviceBasicEditorPage.this.browseForExecutable(DeviceBasicEditorPage.this.preverifyExecutableText);
            }
        });
        new Label(composite, 0).setText("Debug Server:");
        this.debugServerCombo = this.createBooleanComboViewer(composite);
        this.debugServerCombo.getCombo().setLayoutData((Object)new GridData(768));
        new Label(composite, 0);
        Label label = new Label(composite, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        Label label2 = new Label(composite, 0);
        label2.setText("Launch Command Template:");
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label2.setLayoutData((Object)gridData);
        this.launchCommandText = new Text(composite, 2114);
        this.launchCommandText.setTextLimit(1000);
        this.launchCommandText.addModifyListener(modifyListener);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        gridData.widthHint = 500;
        gridData.heightHint = 300;
        this.launchCommandText.setLayoutData((Object)gridData);
        this.initializeDeviceState();
    }

    private boolean getBooleanSelection(ComboViewer comboViewer) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)comboViewer.getSelection();
        Boolean bl = (Boolean)iStructuredSelection.getFirstElement();
        return bl;
    }

    private void initializeDeviceState() {
        if (this.nameText != null && this.editDevice != null) {
            this.nameText.setText(this.editDevice.getName());
            this.groupText.setText(this.editDevice.getGroupName());
            this.descriptionText.setText(this.editDevice.getDescription());
            String string = this.javaExecutableDevice ? "Java" : this.editDevice.getExecutable().toString();
            this.executableText.setText(string);
            this.executableText.setEnabled(!this.javaExecutableDevice);
            this.executableBrowseButton.setEnabled(!this.javaExecutableDevice);
            this.setBooleanSelection(this.debugServerCombo, this.editDevice.isDebugServer());
            this.launchCommandText.setText(this.editDevice.getLaunchCommandTemplate());
            this.preverifierEnabled = true;
            IPreverifier iPreverifier = this.editDevice.getPreverifier();
            if (iPreverifier instanceof StandardPreverifier) {
                this.preverifierEnabled = true;
                StandardPreverifier standardPreverifier = (StandardPreverifier)iPreverifier;
                this.preverifyExecutableText.setText(standardPreverifier.getPreverifierExecutable().toString());
            }
            this.preverifyBrowseButton.setEnabled(this.preverifierEnabled);
            this.preverifyExecutableText.setEnabled(this.preverifierEnabled);
        }
    }

    private void setBooleanSelection(ComboViewer comboViewer, boolean bl) {
        StructuredSelection structuredSelection = new StructuredSelection((Object)bl);
        comboViewer.setSelection((ISelection)structuredSelection, true);
    }

    private void updateState() {
        String string = null;
        if (this.nameText.getText().length() == 0) {
            string = "Device name must be specified.";
        } else if (this.groupText.getText().length() == 0) {
            string = "Device group must be specified";
        } else if (this.launchCommandText.getText().length() == 0) {
            string = "Launch command must be specified.";
        } else {
            File file = new File(this.executableText.getText());
            if (!this.javaExecutableDevice && !file.exists()) {
                string = "Valid executable must be specified";
            } else {
                file = new File(this.preverifyExecutableText.getText());
                if (!file.exists() && !(file = new File(String.valueOf(this.preverifyExecutableText.getText()) + ".exe")).exists()) {
                    string = "Valid preverifier executable must be specified";
                }
            }
        }
        this.setErrorMessage(string);
        this.setValid(string == null);
    }

    private static class BooleanContentProvider
    implements IStructuredContentProvider {
        private BooleanContentProvider() {
        }

        public Object[] getElements(Object object) {
            return BOOLEAN_VALUES;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private static class BooleanLabelProvider
    extends LabelProvider {
        private BooleanLabelProvider() {
        }

        public String getText(Object object) {
            Boolean bl = (Boolean)object;
            return bl != false ? "Yes" : "No";
        }
    }
}

