/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.internal.editors.jad.form.pages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.ui.MTJUIStrings;
import org.eclipse.mtj.ui.editors.jad.AbstractJADEditorPage;
import org.eclipse.mtj.ui.internal.editors.jad.form.JADFormEditor;
import org.eclipse.mtj.ui.internal.utils.ManifestPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class JADUserDefinedPropertiesEditorPage
extends AbstractJADEditorPage {
    private static final String USER_DEFINED_PAGEID = "user_defined";
    private static final String NEW_VALUE = "New Value";
    private static final String NEW_KEY = "New_Key";
    private static final String PROP_KEY = "key";
    private static final String PROP_VALUE = "value";
    private static final String[] PROPERTIES = new String[]{"key", "value"};
    private static final List<String> PROPERTY_LIST = Arrays.asList(PROPERTIES);
    private Button addButton;
    private Button removeButton;
    private TableViewer tableViewer;
    private List<KeyValuePair> userDefinedProperties = new ArrayList<KeyValuePair>();

    private static String getResourceString(String string) {
        return MTJUIStrings.getString(string);
    }

    public JADUserDefinedPropertiesEditorPage() {
        super(USER_DEFINED_PAGEID, JADUserDefinedPropertiesEditorPage.getResourceString("editor.jad.tab.user_defined_properties"));
    }

    public JADUserDefinedPropertiesEditorPage(JADFormEditor jADFormEditor, String string) {
        super(jADFormEditor, USER_DEFINED_PAGEID, string);
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        ManifestPreferenceStore manifestPreferenceStore = this.getPreferenceStore();
        for (KeyValuePair keyValuePair : this.userDefinedProperties) {
            manifestPreferenceStore.setValue(keyValuePair.fields[0], keyValuePair.fields[1]);
        }
        this.setDirty(false);
    }

    public void editorInputChanged() {
        this.updateMidletProperties();
    }

    public String getTitle() {
        return JADUserDefinedPropertiesEditorPage.getResourceString("editor.jad.tab.user_defined_properties");
    }

    public boolean isManagingProperty(String string) {
        return false;
    }

    public void setFocus() {
        this.tableViewer.getTable().setFocus();
    }

    private void addItem() {
        KeyValuePair keyValuePair = new KeyValuePair(NEW_KEY, NEW_VALUE);
        this.userDefinedProperties.add(keyValuePair);
        this.tableViewer.refresh();
        this.setDirty(true);
    }

    private void createButtons(FormToolkit formToolkit, Composite composite) {
        Composite composite2 = formToolkit.createComposite(composite);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 512;
        composite2.setLayout((Layout)fillLayout);
        this.addButton = formToolkit.createButton(composite2, JADUserDefinedPropertiesEditorPage.getResourceString("editor.button.add"), 8);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JADUserDefinedPropertiesEditorPage.this.addItem();
            }
        });
        formToolkit.createLabel(composite2, "");
        this.removeButton = formToolkit.createButton(composite2, JADUserDefinedPropertiesEditorPage.getResourceString("editor.button.remove"), 8);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JADUserDefinedPropertiesEditorPage.this.removeSelectedItems();
            }
        });
    }

    private void createTableViewer(FormToolkit formToolkit, Composite composite) {
        String[] stringArray = new String[]{JADUserDefinedPropertiesEditorPage.getResourceString("property.jad.userdef.key"), JADUserDefinedPropertiesEditorPage.getResourceString("property.jad.userdef.value")};
        int n = 68356;
        Table table = formToolkit.createTable(composite, n);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem tableItem = (TableItem)selectionEvent.item;
                JADUserDefinedPropertiesEditorPage.this.removeButton.setEnabled(tableItem.getParent().getSelectionCount() > 0);
            }
        });
        this.tableViewer = new TableViewer(table);
        TableLayout tableLayout = new TableLayout();
        int n2 = 100 / stringArray.length;
        String[] stringArray2 = stringArray;
        int n3 = stringArray.length;
        int n4 = 0;
        while (n4 < n3) {
            String string = stringArray2[n4];
            TableColumn tableColumn = new TableColumn(table, 0);
            tableColumn.setText(string);
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(n2));
            ++n4;
        }
        table.setLayout((Layout)tableLayout);
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.setCellModifier((ICellModifier)new CellModifier());
        this.tableViewer.setColumnProperties(PROPERTIES);
        this.tableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)});
        this.tableViewer.setInput((Object)this.getEditorInput());
        this.tableViewer.refresh();
    }

    private boolean isUserDefinedPropertyKey(String string) {
        JADFormEditor jADFormEditor = (JADFormEditor)this.getEditor();
        return jADFormEditor.isUserDefinedPropertyKey(string);
    }

    private void removeSelectedItems() {
        int[] nArray = this.tableViewer.getTable().getSelectionIndices();
        int n = nArray.length;
        while (n > 0) {
            int n2 = nArray[n - 1];
            KeyValuePair keyValuePair = this.userDefinedProperties.remove(n2);
            this.getPreferenceStore().setToDefault(keyValuePair.fields[0]);
            --n;
        }
        this.setDirty(true);
        this.tableViewer.refresh();
    }

    private void updateMidletProperties() {
        String[] stringArray;
        this.userDefinedProperties.clear();
        ManifestPreferenceStore manifestPreferenceStore = this.getPreferenceStore();
        String[] stringArray2 = stringArray = manifestPreferenceStore.preferenceNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            if (this.isUserDefinedPropertyKey(string)) {
                this.userDefinedProperties.add(new KeyValuePair(string, manifestPreferenceStore.getString(string)));
            }
            ++n2;
        }
        if (this.tableViewer != null) {
            this.tableViewer.refresh();
        }
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        super.createFormContent(iManagedForm);
        FormToolkit formToolkit = iManagedForm.getToolkit();
        Composite composite = iManagedForm.getForm().getBody();
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(2, false));
        new Label(composite, 0);
        new Label(composite, 0);
        this.createTableViewer(formToolkit, composite);
        this.createButtons(formToolkit, composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.mtj.ui.help_JADUserDefinedPropertiesEditorPage");
    }

    protected String getHelpResource() {
        return "/org.eclipse.mtj.docs/docs/jadeditor.html";
    }

    protected String getSectionDescription() {
        return "User Defined properties may be specified on this page";
    }

    protected String getSectionTitle() {
        return "User Defined Properties";
    }

    protected void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        if (this.tableViewer != null) {
            this.tableViewer.setInput((Object)iEditorInput);
        }
        this.updateMidletProperties();
    }

    private class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        public boolean canModify(Object object, String string) {
            return true;
        }

        public Object getValue(Object object, String string) {
            String string2 = null;
            if (object instanceof KeyValuePair) {
                KeyValuePair keyValuePair = (KeyValuePair)object;
                int n = this.getFieldIndex(string);
                if (n != -1) {
                    string2 = keyValuePair.fields[n];
                }
            }
            return string2;
        }

        public void modify(Object object, String string, Object object2) {
            if (object instanceof TableItem) {
                Object object3 = ((TableItem)object).getData();
                String string2 = (String)object2;
                if (object3 instanceof KeyValuePair) {
                    int n = this.getFieldIndex(string);
                    KeyValuePair keyValuePair = (KeyValuePair)object3;
                    if (n != -1) {
                        this.updateField(keyValuePair, string, n, string2);
                    }
                }
            }
        }

        private int getFieldIndex(String string) {
            return PROPERTY_LIST.indexOf(string);
        }

        private void updateField(KeyValuePair keyValuePair, String string, int n, String string2) {
            if (!keyValuePair.fields[n].equals(string2)) {
                keyValuePair.fields[n] = string2;
                JADUserDefinedPropertiesEditorPage.this.setDirty(true);
                JADUserDefinedPropertiesEditorPage.this.tableViewer.update((Object)keyValuePair, new String[]{string});
            }
        }
    }

    private static class KeyValuePair {
        String[] fields;

        KeyValuePair(String string, String string2) {
            this.fields = new String[]{string, string2};
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            return JADUserDefinedPropertiesEditorPage.this.userDefinedProperties.toArray(new Object[JADUserDefinedPropertiesEditorPage.this.userDefinedProperties.size()]);
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private static class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            KeyValuePair keyValuePair = (KeyValuePair)object;
            return keyValuePair.fields[n];
        }
    }
}

