/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.library.manager;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mtj.core.library.LibraryPlugin;
import org.eclipse.mtj.core.library.model.ILibrary;
import org.eclipse.mtj.core.library.model.impl.MidletLibrary;

public class LibraryManager {
    private static final String EXT_MIDLETLIBRARY = "MIDletLibrary";
    private static LibraryManager LibraryManagerInstance;
    private Map<String, MidletLibrary> midletLibraries;

    public static synchronized LibraryManager getInstance() {
        if (LibraryManagerInstance == null) {
            LibraryManagerInstance = new LibraryManager();
        }
        return LibraryManagerInstance;
    }

    private LibraryManager() {
        this.initialize();
    }

    public synchronized ILibrary getMidletLibrary(String string) {
        return this.midletLibraries.get(string);
    }

    public synchronized String[] getMidletLibraryNames() {
        Set<String> set = this.midletLibraries.keySet();
        return set.toArray(new String[set.size()]);
    }

    private void initialize() {
        IConfigurationElement[] iConfigurationElementArray;
        this.midletLibraries = new HashMap<String, MidletLibrary>();
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.mtj.core.library", EXT_MIDLETLIBRARY);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
            MidletLibrary midletLibrary = null;
            try {
                midletLibrary = new MidletLibrary(iConfigurationElement);
            }
            catch (Throwable throwable) {
                LibraryPlugin.log(4, "Failed to load MidletLibrary", throwable);
            }
            if (midletLibrary != null) {
                this.midletLibraries.put(midletLibrary.getName(), midletLibrary);
            }
            ++n2;
        }
    }
}

