/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.library.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.library.LibraryPlugin;
import org.eclipse.mtj.core.library.internal.MIDletLibraryClasspathContainer;
import org.eclipse.mtj.core.library.manager.LibraryManager;
import org.eclipse.mtj.core.library.model.ILibrary;

public class MIDletLibraryClasspathContainerInitializer
extends ClasspathContainerInitializer {
    String description = null;

    public boolean canUpdateClasspathContainer(IPath iPath, IJavaProject iJavaProject) {
        return false;
    }

    public void initialize(IPath iPath, IJavaProject iJavaProject) throws CoreException {
        if (this.isMidletLibraryContainer(iPath)) {
            String string = iPath.segment(1);
            ILibrary iLibrary = LibraryManager.getInstance().getMidletLibrary(string);
            if (iLibrary != null) {
                MIDletLibraryClasspathContainer mIDletLibraryClasspathContainer = new MIDletLibraryClasspathContainer(iLibrary);
                this.description = String.valueOf(string) + " [" + iLibrary.getVersion().toString() + "]";
                JavaCore.setClasspathContainer((IPath)iPath, (IJavaProject[])new IJavaProject[]{iJavaProject}, (IClasspathContainer[])new IClasspathContainer[]{mIDletLibraryClasspathContainer}, null);
            } else {
                LibraryPlugin.log(4, "Could not load " + iPath.toString(), null);
            }
        }
    }

    private boolean isMidletLibraryContainer(IPath iPath) {
        return iPath != null && iPath.segmentCount() == 2 && "org.eclipse.mtj.core.library.MIDLET_LIBRARY".equals(iPath.segment(0));
    }

    public String getDescription(IPath iPath, IJavaProject iJavaProject) {
        if (this.description != null) {
            return this.description;
        }
        return super.getDescription(iPath, iJavaProject);
    }
}

