/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.preverifier;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.mtj.preverifier.ClassPreverifier;
import org.eclipse.mtj.preverifier.IArchivePreverificationListener;
import org.eclipse.mtj.preverifier.IPreverificationPolicy;
import org.eclipse.mtj.preverifier.NullArchivePreverificationListener;
import org.eclipse.mtj.preverifier.results.PreverificationResults;

public class ArchivePreverifier {
    private ClassPreverifier classPreverifier;
    private IArchivePreverificationListener listener;

    public ArchivePreverifier(IPreverificationPolicy iPreverificationPolicy, IArchivePreverificationListener iArchivePreverificationListener) {
        this.classPreverifier = new ClassPreverifier(iPreverificationPolicy);
        this.listener = iArchivePreverificationListener == null ? new NullArchivePreverificationListener() : iArchivePreverificationListener;
    }

    public void preverify(File file, File file2, URL[] uRLArray) throws IOException {
        if (file == null || !file.exists()) {
            throw new IllegalArgumentException("Archive must not be null or does not exist");
        }
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, Thread.currentThread().getContextClassLoader());
        ZipFile zipFile = new ZipFile(file, 1);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
        try {
            this.listener.fileBegin(zipFile);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                this.handleEntry(zipEntry, zipFile, zipOutputStream, uRLClassLoader);
            }
            this.listener.fileEnd(zipFile);
        }
        finally {
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    private ZipEntry copyEntry(ZipEntry zipEntry) {
        ZipEntry zipEntry2 = new ZipEntry(zipEntry.getName());
        zipEntry2.setComment(zipEntry.getComment());
        zipEntry2.setSize(zipEntry.getSize());
        zipEntry2.setTime(zipEntry.getTime());
        return zipEntry2;
    }

    private void copyEntryAndContents(ZipEntry zipEntry, ZipFile zipFile, ZipOutputStream zipOutputStream) throws IOException {
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        ZipEntry zipEntry2 = this.copyEntry(zipEntry);
        zipOutputStream.putNextEntry(zipEntry2);
        this.copyInputToOutput(inputStream, zipOutputStream);
    }

    private void copyInputToOutput(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n = 0;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    private void handleEntry(ZipEntry zipEntry, ZipFile zipFile, ZipOutputStream zipOutputStream, ClassLoader classLoader) throws IOException {
        if (!zipEntry.isDirectory()) {
            String string = zipEntry.getName();
            if (string.endsWith(".class")) {
                this.preverifyEntry(zipEntry, zipFile, zipOutputStream, classLoader);
            } else {
                this.copyEntryAndContents(zipEntry, zipFile, zipOutputStream);
            }
        }
    }

    private boolean preverifyEntry(ZipEntry zipEntry, ZipFile zipFile, ZipOutputStream zipOutputStream, ClassLoader classLoader) throws IOException {
        boolean bl = this.listener.classBegin(zipFile, zipEntry);
        if (bl) {
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            PreverificationResults preverificationResults = this.classPreverifier.preverify(inputStream, classLoader);
            if (!preverificationResults.isErrorResult()) {
                ZipEntry zipEntry2 = this.copyEntry(zipEntry);
                zipOutputStream.putNextEntry(zipEntry2);
                zipOutputStream.write(preverificationResults.getPreverifiedClassBytes());
            }
            bl = this.listener.classEnd(zipFile, zipEntry, preverificationResults);
        }
        return bl;
    }
}

