/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.preverifier.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.mtj.preverifier.internal.PreverificationClassNode;
import org.eclipse.mtj.preverifier.internal.PreverifierMethodNode;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Value;

public class MethodRewriter {
    private PreverificationClassNode classNode;
    private PreverifierMethodNode srcMethod;
    private MethodNode updatedMethod;
    private Map subroutineMap;
    private Map lineNumberMap;
    private Map localVariableByStartLabelMap;
    private Map localVariableByEndLabelMap;

    public MethodRewriter(PreverificationClassNode preverificationClassNode, PreverifierMethodNode preverifierMethodNode) {
        this.classNode = preverificationClassNode;
        this.srcMethod = preverifierMethodNode;
        this.localVariableByEndLabelMap = new HashMap();
    }

    public MethodNode getUpdatedMethod() throws AnalyzerException {
        boolean bl;
        boolean bl2 = bl = this.srcMethod.getJsrInstructionIndices().size() > 0;
        if (bl) {
            this.inlineSubroutines();
        } else {
            this.updatedMethod = this.srcMethod;
        }
        this.createStackMapAttribute();
        return this.updatedMethod;
    }

    private void createStackMapAttribute() throws AnalyzerException {
    }

    private void inlineSubroutines() throws AnalyzerException {
    }

    private void addNewLocalVariableByEnd(LocalVariableNode localVariableNode) {
        ArrayList<LocalVariableNode> arrayList = (ArrayList<LocalVariableNode>)this.localVariableByEndLabelMap.get(localVariableNode.end);
        if (arrayList == null) {
            arrayList = new ArrayList<LocalVariableNode>();
            this.localVariableByEndLabelMap.put(localVariableNode.end, arrayList);
        }
        arrayList.add(localVariableNode);
    }

    private void addStackMapType(List list, Label label, Value value) {
    }

    private void copyTryCatchBlocks(MethodNode methodNode, Region region, List list) {
    }

    private Map createLineNumberMap() {
        HashMap hashMap = new HashMap();
        return hashMap;
    }

    private Map createLocalVariableMap() {
        HashMap<LabelNode, ArrayList<LocalVariableNode>> hashMap = new HashMap<LabelNode, ArrayList<LocalVariableNode>>();
        for (LocalVariableNode localVariableNode : this.srcMethod.localVariables) {
            ArrayList<LocalVariableNode> arrayList = (ArrayList<LocalVariableNode>)hashMap.get(localVariableNode.start);
            if (arrayList == null) {
                arrayList = new ArrayList<LocalVariableNode>();
                hashMap.put(localVariableNode.start, arrayList);
            }
            arrayList.add(localVariableNode);
        }
        return hashMap;
    }

    private MethodNode copyMethodMetadata(MethodNode methodNode) {
        String[] stringArray = methodNode.exceptions.toArray(new String[methodNode.exceptions.size()]);
        return new MethodNode(methodNode.access, methodNode.name, methodNode.desc, methodNode.signature, stringArray);
    }

    private void copyRegion(MethodNode methodNode, Region region) throws AnalyzerException {
    }

    private void removeTrailingTops(ArrayList arrayList) {
        while (this.removeTrailingTop(arrayList)) {
        }
    }

    private boolean removeTrailingTop(ArrayList arrayList) {
        boolean bl = false;
        return bl;
    }

    private void createSubroutineMap() throws AnalyzerException {
        this.subroutineMap = new HashMap();
    }

    private boolean shouldCopy(TryCatchBlockNode tryCatchBlockNode) {
        boolean bl = true;
        return bl;
    }

    private boolean shouldReduceVariableVisibility(MethodNode methodNode) {
        boolean bl = false;
        return bl;
    }

    private void sortTryCatchBlocks(Region region) {
        Iterator iterator = this.srcMethod.tryCatchBlocks.iterator();
        while (iterator.hasNext()) {
            Region region2 = region;
            TryCatchBlockNode tryCatchBlockNode = (TryCatchBlockNode)iterator.next();
            for (Region region3 : this.subroutineMap.values()) {
                if (!region3.encloses(tryCatchBlockNode)) continue;
                if (region2 == null) {
                    region2 = region3;
                    continue;
                }
                if (region3.getLength() >= region2.getLength()) continue;
                region2 = region3;
            }
            region2.addTryCatchBlock(tryCatchBlockNode);
        }
    }

    private Set findTargetLabels() {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Object object : this.updatedMethod.instructions) {
            switch (object.getType()) {
                case 6: {
                    JumpInsnNode jumpInsnNode = (JumpInsnNode)object;
                    hashSet.add(jumpInsnNode.label);
                    break;
                }
                case 11: {
                    LookupSwitchInsnNode lookupSwitchInsnNode = (LookupSwitchInsnNode)object;
                    for (Label label : lookupSwitchInsnNode.labels) {
                        hashSet.add(label);
                    }
                    hashSet.add(lookupSwitchInsnNode.dflt);
                    break;
                }
                case 10: {
                    LookupSwitchInsnNode lookupSwitchInsnNode = (TableSwitchInsnNode)object;
                    for (Label label : lookupSwitchInsnNode.labels) {
                        hashSet.add(label);
                    }
                    hashSet.add(lookupSwitchInsnNode.dflt);
                }
            }
        }
        for (JumpInsnNode jumpInsnNode : this.updatedMethod.tryCatchBlocks) {
            hashSet.add(jumpInsnNode.handler);
        }
        return hashSet;
    }

    private int getLabelIndex(PreverifierMethodNode preverifierMethodNode, Label label) {
        Integer n = (Integer)preverifierMethodNode.getLabelIndices().get(label);
        return n;
    }

    private Label[] getMappedLabelArray(Region region, List list) {
        Label[] labelArray = new Label[list.size()];
        int n = 0;
        while (n < labelArray.length) {
            labelArray[n] = region.getMappedLabel((Label)list.get(n));
            ++n;
        }
        return labelArray;
    }

    private boolean isSubroutineStart(Label label) {
        return this.subroutineMap.containsKey(label);
    }

    private void visitInstruction(MethodNode methodNode, Region region, AbstractInsnNode abstractInsnNode) throws AnalyzerException {
        int n = abstractInsnNode.getOpcode();
        switch (n) {
            case 168: {
                this.visitJumpToSubroutine(methodNode, region, (JumpInsnNode)abstractInsnNode);
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 198: 
            case 199: {
                this.visitJump(methodNode, region, (JumpInsnNode)abstractInsnNode);
                break;
            }
            case 171: {
                this.visitLookupSwitch(methodNode, region, (LookupSwitchInsnNode)abstractInsnNode);
                break;
            }
            case 170: {
                this.visitTableSwitch(methodNode, region, (TableSwitchInsnNode)abstractInsnNode);
                break;
            }
            default: {
                abstractInsnNode.accept((MethodVisitor)methodNode);
            }
        }
    }

    private void visitJump(MethodNode methodNode, Region region, JumpInsnNode jumpInsnNode) {
    }

    private void visitJumpToSubroutine(MethodNode methodNode, Region region, JumpInsnNode jumpInsnNode) throws AnalyzerException {
    }

    private void visitLabel(MethodNode methodNode, Region region, Label label) {
    }

    private void visitLookupSwitch(MethodNode methodNode, Region region, LookupSwitchInsnNode lookupSwitchInsnNode) {
    }

    private void visitTableSwitch(MethodNode methodNode, Region region, TableSwitchInsnNode tableSwitchInsnNode) {
    }

    public class MappedLabel
    extends Label {
        private Label originalLabel;

        public MappedLabel(Label label) {
            this.originalLabel = label;
        }

        public Label getOriginalLabel() {
            return this.originalLabel;
        }

        public String toString() {
            return String.valueOf(this.originalLabel.toString()) + " -> " + super.toString();
        }
    }

    class Region {
        protected Region parentRegion;
        protected int startIndex;
        protected int endIndex;
        protected Map labelMap;
        protected Set labels;
        protected List tryCatchBlocks;

        Region() {
            this(0, 0);
        }

        Region(int n, int n2) {
            this.startIndex = n;
            this.endIndex = n2;
            this.labelMap = new HashMap();
            this.labels = new HashSet();
            this.tryCatchBlocks = new ArrayList();
        }

        void addLabel(Label label) {
            this.labels.add(label);
        }

        void addTryCatchBlock(TryCatchBlockNode tryCatchBlockNode) {
            this.tryCatchBlocks.add(tryCatchBlockNode);
        }

        boolean encloses(TryCatchBlockNode tryCatchBlockNode) {
            return this.labels.contains(tryCatchBlockNode.start) && this.labels.contains(tryCatchBlockNode.end);
        }

        void enter(MethodNode methodNode) {
            this.labelMap.clear();
            MethodRewriter.this.copyTryCatchBlocks(methodNode, this, this.tryCatchBlocks);
        }

        void exit(MethodNode methodNode) {
        }

        int getLength() {
            return this.endIndex - this.startIndex;
        }

        Label getMappedLabel(Label label) {
            Label label2 = this.findMappedLabel(label);
            if (label2 == null) {
                label2 = new MappedLabel(label);
                Map map = this.findLabelMap(label);
                map.put(label, label2);
            }
            return label2;
        }

        boolean isSubroutineReturnStore(MethodNode methodNode, int n) {
            return false;
        }

        void setParentRegion(Region region) {
            this.parentRegion = region;
        }

        protected Map findLabelMap(Label label) {
            Map map = this.findLabelMapRecursive(label);
            return map != null ? map : this.labelMap;
        }

        protected Map findLabelMapRecursive(Label label) {
            Map map = null;
            if (this.labels.contains(label)) {
                map = this.labelMap;
            } else if (this.parentRegion != null) {
                map = this.parentRegion.findLabelMapRecursive(label);
            }
            return map;
        }

        protected Label findMappedLabel(Label label) {
            Label label2 = (Label)this.labelMap.get(label);
            if (label2 == null && this.parentRegion != null) {
                label2 = this.parentRegion.findMappedLabel(label);
            }
            return label2;
        }

        List getTryCatchBlocks() {
            return this.tryCatchBlocks;
        }
    }

    class Subroutine
    extends Region {
        Label label;
        int returnVariable;

        Subroutine(Label label) {
            this.label = label;
        }

        public int getReturnVariable() {
            return this.returnVariable;
        }

        boolean isSubroutineReturnStore(MethodNode methodNode, int n) {
            boolean bl = false;
            return bl;
        }

        public void setReturnVariable(int n) {
            this.returnVariable = n;
        }
    }
}

