/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal.preverifier;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mtj.preverifier.IArchivePreverificationListener;
import org.eclipse.mtj.preverifier.results.PreverificationError;
import org.eclipse.mtj.preverifier.results.PreverificationResults;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressMonitorPreverificationListener
implements IArchivePreverificationListener {
    private IProgressMonitor subMonitor;
    private ArrayList<PreverificationError> errorList = new ArrayList();

    public ProgressMonitorPreverificationListener(IProgressMonitor iProgressMonitor) {
        this.subMonitor = new SubProgressMonitor(iProgressMonitor, -1);
    }

    public void fileBegin(ZipFile zipFile) {
        this.subMonitor.beginTask("Beginning preverification of " + zipFile.getName(), -1);
    }

    public boolean classBegin(ZipFile zipFile, ZipEntry zipEntry) {
        String string = zipEntry.getName().replace('/', '.');
        this.subMonitor.subTask("Preverifying " + string + "...");
        return !this.subMonitor.isCanceled();
    }

    public boolean classEnd(ZipFile zipFile, ZipEntry zipEntry, PreverificationResults preverificationResults) {
        this.subMonitor.worked(1);
        this.errorList.addAll((Collection<PreverificationError>)Arrays.asList(preverificationResults.getErrors()));
        return !this.subMonitor.isCanceled();
    }

    public void fileEnd(ZipFile zipFile) {
        this.subMonitor.done();
    }

    public List<PreverificationError> getErrorList() {
        return this.errorList;
    }
}

