/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.converter;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.core.converter.Messages;
import org.eclipse.mtj.core.converter.ProjectConvertionException;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.utils.XMLUtils;
import org.eclipse.mtj.core.model.device.DeviceRegistry;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;
import org.eclipse.mtj.core.model.project.MidletSuiteFactory;
import org.eclipse.mtj.core.model.project.impl.MidletSuiteProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTJProjectConverter {
    private static final String DEFAULT_PREFERENCES_DIRNAME = ".settings";
    private static final String EclipseME_JAVAME_CONTAINER = "J2MELIB";
    private static final String EclipseME_METADATA_ELEM_ROOT = "eclipsemeMetadata";
    private static final String EclipseME_METADATA_FILE = ".eclipseme";
    private static final String EclipseME_NATURE_PREFIX = "eclipseme.core.";
    private static final String EclipseME_PREFERENCE_STORE = "eclipseme.core.prefs";
    private static final String EcliseME_TEMP_FOLDER_NAME = ".eclipseme.tmp";
    private static final String FILENAME_PROJECT = ".project";
    private static final String MTJ_METADATA_ELEM_PASSWORDS = "passwords";
    private static final String MTJ_METADATA_ELEM_ROOT = "mtjMetadata";
    private static final String PREFS_FILE_EXTENSION = "prefs";
    private static String oldJadFilePath;

    private MTJProjectConverter() {
    }

    private static IMidletSuiteProject getMidletSuiteProject(IProject iProject) {
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        IMidletSuiteProject iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(iJavaProject);
        return iMidletSuiteProject;
    }

    private static String getOldJadFilePath(File file) {
        String string = null;
        try {
            Document document = XMLUtils.readDocument(file);
            Element element = document.getDocumentElement();
            string = element.getAttribute("jad");
        }
        catch (Exception exception) {
            MTJCorePlugin.log(4, exception);
        }
        return string;
    }

    private static List<File> getChildrenFiles(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (file.isDirectory()) {
            String[] stringArray;
            String[] stringArray2 = stringArray = file.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                arrayList.add(new File(file, string));
                ++n2;
            }
        }
        return arrayList;
    }

    public static synchronized void convertEclipseMeProject(IProject iProject, IProgressMonitor iProgressMonitor) throws ProjectConvertionException {
        File file = new File(iProject.getLocationURI());
        List<File> list = MTJProjectConverter.getChildrenFiles(file);
        iProgressMonitor.beginTask(Messages.MTJProjectConverter_convert_taskname, 10);
        for (File file2 : list) {
            MTJProjectConverter.renameEclipseMETmpFolder(file2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            MTJProjectConverter.renamePreferenceStoreFile(iProject, file2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            MTJProjectConverter.modifyMetadata(file2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            MTJProjectConverter.removeBuilderAndNature(file2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        }
        MTJProjectConverter.renameProjectJAD(iProject);
        try {
            iProject.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            MTJProjectConverter.convertProject(iProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 3));
            MTJProjectConverter.recoverJADFileNameInMetadata(iProject);
            iProject.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            iProject.build(15, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            iProgressMonitor.done();
        }
        catch (CoreException coreException) {
            throw new ProjectConvertionException(coreException.getMessage(), coreException);
        }
    }

    public static void convertJavaProject(IJavaProject iJavaProject, IDevice iDevice, IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException, JavaModelException {
        IProject iProject = iJavaProject.getProject();
        String string = MidletSuiteProject.getDefaultJadFileName(iProject);
        MidletSuiteFactory.getMidletSuiteCreationRunnable(iProject, iJavaProject, iDevice, string).run(iProgressMonitor);
        MTJProjectConverter.removeJ2SELibraries(iJavaProject, iProgressMonitor);
    }

    private static void removeJ2SELibraries(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException {
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
        ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>();
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            if (!MTJProjectConverter.isJ2SELibraryEntry(iClasspathEntryArray[n])) {
                arrayList.add(iClasspathEntryArray[n]);
            }
            ++n;
        }
        iClasspathEntryArray = arrayList.toArray(new IClasspathEntry[arrayList.size()]);
        iJavaProject.setRawClasspath(iClasspathEntryArray, iProgressMonitor);
    }

    private static void convertProject(IProject iProject, IProgressMonitor iProgressMonitor) throws ProjectConvertionException {
        IDevice iDevice = MTJProjectConverter.getDevice(iProject);
        MTJProjectConverter.deleteDeviceFromMetadata(iProject);
        if (iDevice == null) {
            throw new ProjectConvertionException(Messages.MTJProjectConverter_convertProject_device_unavailable);
        }
        try {
            IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
            MidletSuiteFactory.removeMidletSuiteProject(iJavaProject);
            String string = MidletSuiteProject.getDefaultJadFileName(iProject);
            MidletSuiteFactory.getMidletSuiteCreationRunnable(iProject, iJavaProject, iDevice, string).run(iProgressMonitor);
            MTJProjectConverter.removeJ2SEAndEclipseMELibraries(iJavaProject, iProgressMonitor);
        }
        catch (Exception exception) {
            throw new ProjectConvertionException(Messages.MTJProjectConverter_convertProject_convertion_error);
        }
    }

    private static void deleteDeviceFromMetadata(IProject iProject) {
        IFile iFile = iProject.getFile(".mtj");
        try {
            Document document = XMLUtils.readDocument(iFile.getLocation().toFile());
            Element element = (Element)document.getElementsByTagName("device").item(0);
            element.getParentNode().removeChild(element);
            XMLUtils.writeDocument(iFile.getLocation().toFile(), document);
        }
        catch (Exception exception) {
            MTJCorePlugin.log(4, exception);
        }
    }

    private static IDevice getDevice(IProject iProject) {
        IDevice iDevice = null;
        IFile iFile = iProject.getFile(".mtj");
        try {
            Document document = XMLUtils.readDocument(iFile.getLocation().toFile());
            Element element = (Element)document.getElementsByTagName("device").item(0);
            String string = element.getAttribute("group");
            String string2 = element.getAttribute("name");
            iDevice = DeviceRegistry.singleton.getDevice(string, string2);
        }
        catch (Exception exception) {
            iDevice = null;
        }
        if (iDevice == null) {
            iDevice = DeviceRegistry.singleton.getDefaultDevice();
        }
        return iDevice;
    }

    private static boolean isEclipseMELibraryEntry(IClasspathEntry iClasspathEntry) {
        boolean bl = false;
        if (iClasspathEntry.getEntryKind() == 5 && iClasspathEntry.getPath().lastSegment().equals(EclipseME_JAVAME_CONTAINER)) {
            bl = true;
        }
        return bl;
    }

    private static boolean isJ2SELibraryEntry(IClasspathEntry iClasspathEntry) {
        boolean bl = false;
        if (iClasspathEntry.getEntryKind() == 1) {
            if (iClasspathEntry.getPath().lastSegment().equals("JRE_LIB")) {
                bl = true;
            }
        } else if (iClasspathEntry.getEntryKind() == 5 && iClasspathEntry.getPath().lastSegment().equals("org.eclipse.jdt.launching.JRE_CONTAINER")) {
            bl = true;
        }
        return bl;
    }

    private static void modifyMetadata(File file, IProgressMonitor iProgressMonitor) {
        if (file.isFile() && file.getName().equals(EclipseME_METADATA_FILE)) {
            oldJadFilePath = MTJProjectConverter.getOldJadFilePath(file);
            iProgressMonitor.beginTask(Messages.MTJProjectConverter_modifyMetadata_taskname, 2);
            Path path = new Path(file.getPath());
            File file2 = new File(path.removeLastSegments(1) + File.separator + ".mtj");
            file.renameTo(file2);
            iProgressMonitor.worked(1);
            try {
                Document document = XMLUtils.readDocument(file2);
                Element element = document.getDocumentElement();
                if (!element.getNodeName().equals(EclipseME_METADATA_ELEM_ROOT)) {
                    file2.delete();
                    return;
                }
                Element element2 = document.createElement(MTJ_METADATA_ELEM_ROOT);
                while (element.hasChildNodes()) {
                    element2.appendChild(element.getFirstChild());
                }
                document.replaceChild(element2, element);
                Element element3 = (Element)document.getElementsByTagName(MTJ_METADATA_ELEM_PASSWORDS).item(0);
                if (element3 != null) {
                    element3.getParentNode().removeChild(element3);
                }
                XMLUtils.writeDocument(file2, document);
            }
            catch (Exception exception) {
                MTJCorePlugin.log(4, Messages.MTJProjectConverter_modifyMetadata_exception, exception);
                file2.delete();
            }
            iProgressMonitor.done();
        }
    }

    private static void recoverJADFileNameInMetadata(IProject iProject) throws CoreException {
        String string;
        IMidletSuiteProject iMidletSuiteProject = MTJProjectConverter.getMidletSuiteProject(iProject);
        IFile iFile = iProject.getFile(oldJadFilePath);
        String string2 = iFile.getName();
        if (!string2.equals(string = iMidletSuiteProject.getJadFileName())) {
            iMidletSuiteProject.setJadFileName(string2);
            iMidletSuiteProject.saveMetaData();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void removeBuilderAndNature(File file, IProgressMonitor iProgressMonitor) {
        if (file.isFile() && file.getName().equals(FILENAME_PROJECT)) {
            iProgressMonitor.beginTask(Messages.MTJProjectConverter_removeBuilderAndNature_taskname, 2);
            try {
                Object object;
                Object object2;
                void node;
                Document document = XMLUtils.readDocument(file);
                NodeList nodeList = document.getElementsByTagName("name");
                ArrayList arrayList = new ArrayList();
                boolean n = false;
                while (node < nodeList.getLength()) {
                    object2 = nodeList.item((int)node);
                    if (object2.getTextContent().indexOf(EclipseME_NATURE_PREFIX) >= 0) {
                        arrayList.add(object2);
                    }
                    ++node;
                }
                for (Node nodeList2 : arrayList) {
                    Node n2 = nodeList2.getParentNode();
                    n2.getParentNode().removeChild(n2);
                }
                iProgressMonitor.worked(1);
                NodeList nodeList2 = document.getElementsByTagName("nature");
                object2 = new ArrayList<Object>();
                int node3 = 0;
                while (node3 < nodeList2.getLength()) {
                    object = nodeList2.item(node3);
                    if (object.getTextContent().indexOf(EclipseME_NATURE_PREFIX) >= 0) {
                        object2.add(object);
                    }
                    ++node3;
                }
                object = object2.iterator();
                while (object.hasNext()) {
                    Node node2 = (Node)object.next();
                    node2.getParentNode().removeChild(node2);
                }
                XMLUtils.writeDocument(file, document);
            }
            catch (Exception exception) {
                MTJCorePlugin.log(4, ".project error", exception);
            }
            iProgressMonitor.done();
        }
    }

    private static void removeJ2SEAndEclipseMELibraries(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException {
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
        ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>();
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            if (!MTJProjectConverter.isJ2SELibraryEntry(iClasspathEntryArray[n]) && !MTJProjectConverter.isEclipseMELibraryEntry(iClasspathEntryArray[n])) {
                arrayList.add(iClasspathEntryArray[n]);
            }
            ++n;
        }
        iClasspathEntryArray = arrayList.toArray(new IClasspathEntry[arrayList.size()]);
        iJavaProject.setRawClasspath(iClasspathEntryArray, iProgressMonitor);
    }

    private static void renameEclipseMETmpFolder(File file, IProgressMonitor iProgressMonitor) {
        if (file.isDirectory() && file.getName().equals(EcliseME_TEMP_FOLDER_NAME)) {
            iProgressMonitor.beginTask(Messages.MTJProjectConverter_renameEclipseMETmpFolder_taskname, 1);
            Path path = new Path(file.getPath());
            IPath iPath = path.removeLastSegments(1).append(".mtj.tmp");
            File file2 = new File(iPath.toFile().getPath());
            file.renameTo(file2);
            iProgressMonitor.done();
        }
    }

    private static void renamePreferenceStoreFile(IProject iProject, File file, IProgressMonitor iProgressMonitor) {
        if (file.isDirectory() && file.getName().equals(DEFAULT_PREFERENCES_DIRNAME)) {
            iProgressMonitor.beginTask(Messages.MTJProjectConverter_renamePreferenceStoreFile_taskname, 1);
            List<File> list = MTJProjectConverter.getChildrenFiles(file);
            for (File file2 : list) {
                if (!file2.getName().equals(EclipseME_PREFERENCE_STORE)) continue;
                ProjectScope projectScope = new ProjectScope(iProject);
                IEclipsePreferences iEclipsePreferences = projectScope.getNode("org.eclipse.mtj.core");
                Path path = new Path(file2.getPath());
                File file3 = new File(path.removeLastSegments(1) + File.separator + iEclipsePreferences.name() + "." + PREFS_FILE_EXTENSION);
                file2.renameTo(file3);
                break;
            }
            iProgressMonitor.done();
        }
    }

    private static void renameProjectJAD(IProject iProject) {
        IFile iFile = iProject.getFile(oldJadFilePath);
        File file = iFile.getLocation().toFile();
        IMidletSuiteProject iMidletSuiteProject = MTJProjectConverter.getMidletSuiteProject(iProject);
        File file2 = iMidletSuiteProject.getApplicationDescriptorFile().getLocation().toFile();
        file.renameTo(file2);
    }
}

