/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal.launching;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.text.IRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackTraceEntry {
    private static final String AT = "at ";
    private List<IRegion> regions;
    private String methodName;
    private String className;
    private File sourceFile;
    private int offset;
    private int line = Integer.MIN_VALUE;

    public StackTraceEntry(String string, String string2, int n) {
        this.methodName = string2;
        this.className = string;
        this.offset = n;
    }

    public StackTraceEntry(String string) {
        int n = string.indexOf(AT);
        string = string.substring(n += AT.length());
        int n2 = string.lastIndexOf(".");
        int n3 = string.lastIndexOf("(");
        int n4 = string.lastIndexOf(")");
        this.className = string.substring(0, n2);
        this.methodName = string.substring(++n2, n3++);
        this.offset = Integer.parseInt(string.substring(++n3, n4));
    }

    public synchronized void addRegion(IRegion iRegion) {
        if (this.regions == null) {
            this.regions = new LinkedList<IRegion>();
        }
        this.regions.add(iRegion);
    }

    public List<IRegion> getRegions() {
        return this.regions;
    }

    public void setLine(int n) {
        this.line = n;
    }

    public int getLine() {
        return this.line;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getClassName() {
        return this.className.replace(".", "/");
    }

    public int getOffset() {
        return this.offset;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.className);
        stringBuffer.append(".");
        stringBuffer.append(this.methodName);
        stringBuffer.append("(");
        stringBuffer.append(this.className);
        stringBuffer.append(".java:");
        stringBuffer.append(this.line);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void setSourcePath(File file) {
        this.sourceFile = file;
    }

    public File getJavaFile() {
        return this.sourceFile;
    }
}

