/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.text;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.mtj.core.model.IModel;
import org.eclipse.mtj.core.model.IModelChangeProvider;
import org.eclipse.mtj.core.model.ModelChangedEvent;
import org.eclipse.mtj.internal.core.text.DocumentElementNode;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.IDocumentObject;
import org.eclipse.mtj.internal.core.text.IDocumentTextNode;
import org.eclipse.mtj.internal.core.text.IEditingModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DocumentObject
extends DocumentElementNode
implements IDocumentObject {
    private static final long serialVersionUID = 1L;
    private transient boolean fInTheModel;
    private transient IModel fModel;

    public DocumentObject(IModel iModel, String string) {
        this.fModel = iModel;
        this.fInTheModel = false;
        this.setXMLTagName(string);
    }

    @Override
    public void addChildNode(IDocumentElementNode iDocumentElementNode) {
        if (iDocumentElementNode instanceof IDocumentObject) {
            ((IDocumentObject)iDocumentElementNode).setInTheModel(true);
        }
        super.addChildNode(iDocumentElementNode);
    }

    @Override
    public void addChildNode(IDocumentElementNode iDocumentElementNode, boolean bl) {
        this.addChildNode(iDocumentElementNode);
        if (bl && this.shouldFireEvent()) {
            this.fireStructureChanged(iDocumentElementNode, 1);
        }
    }

    @Override
    public void addChildNode(IDocumentElementNode iDocumentElementNode, int n) {
        if (n < 0 || n > this.getChildCount()) {
            return;
        }
        if (iDocumentElementNode instanceof IDocumentObject) {
            ((IDocumentObject)iDocumentElementNode).setInTheModel(true);
        }
        super.addChildNode(iDocumentElementNode, n);
    }

    @Override
    public void addChildNode(IDocumentElementNode iDocumentElementNode, int n, boolean bl) {
        this.addChildNode(iDocumentElementNode, n);
        if (bl && this.shouldFireEvent()) {
            this.fireStructureChanged(iDocumentElementNode, 1);
        }
    }

    @Override
    public IDocumentElementNode clone(IDocumentElementNode iDocumentElementNode) {
        IDocumentElementNode iDocumentElementNode2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(iDocumentElementNode);
            objectOutputStream.flush();
            objectOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            iDocumentElementNode2 = (IDocumentElementNode)objectInputStream.readObject();
            objectInputStream.close();
            iDocumentElementNode2.reconnect(this, this.fModel);
        }
        catch (IOException iOException) {
            iDocumentElementNode2 = null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            iDocumentElementNode2 = null;
        }
        return iDocumentElementNode2;
    }

    @Override
    public boolean getBooleanAttributeValue(String string, boolean bl) {
        String string2 = this.getXMLAttributeValue(string);
        if (string2 == null) {
            return bl;
        }
        if (string2.equalsIgnoreCase("true")) {
            return true;
        }
        if (string2.equalsIgnoreCase("false")) {
            return false;
        }
        return bl;
    }

    @Override
    public IDocumentElementNode getChildNode(Class<?> clazz) {
        ArrayList<IDocumentElementNode> arrayList = this.getChildNodesList();
        for (IDocumentElementNode iDocumentElementNode : arrayList) {
            if (!clazz.isInstance(iDocumentElementNode)) continue;
            return iDocumentElementNode;
        }
        return null;
    }

    @Override
    public int getChildNodeCount(Class<?> clazz) {
        int n = 0;
        ArrayList<IDocumentElementNode> arrayList = this.getChildNodesList();
        for (IDocumentElementNode iDocumentElementNode : arrayList) {
            if (!clazz.isInstance(iDocumentElementNode)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public ArrayList<IDocumentElementNode> getChildNodesList(Class<?> clazz, boolean bl) {
        return this.getChildNodesList(new Class[]{clazz}, bl);
    }

    @Override
    public ArrayList<IDocumentElementNode> getChildNodesList(Class<?>[] classArray, boolean bl) {
        ArrayList<IDocumentElementNode> arrayList = new ArrayList<IDocumentElementNode>();
        ArrayList<IDocumentElementNode> arrayList2 = this.getChildNodesList();
        block0: for (IDocumentElementNode iDocumentElementNode : arrayList2) {
            Class<?>[] classArray2 = classArray;
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> clazz = classArray2[n2];
                if (clazz.isInstance(iDocumentElementNode) == bl) {
                    arrayList.add(iDocumentElementNode);
                    continue block0;
                }
                ++n2;
            }
        }
        return arrayList;
    }

    @Override
    public IDocumentElementNode getNextSibling(IDocumentElementNode iDocumentElementNode, Class<?> clazz) {
        int n = this.indexOf(iDocumentElementNode);
        int n2 = this.getChildCount() - 1;
        if (n < 0 || n >= n2) {
            return null;
        }
        int n3 = n + 1;
        while (n3 <= n2) {
            IDocumentElementNode iDocumentElementNode2 = this.getChildAt(n3);
            if (clazz.isInstance(iDocumentElementNode2)) {
                return iDocumentElementNode2;
            }
            ++n3;
        }
        return null;
    }

    @Override
    public IDocumentElementNode getPreviousSibling(IDocumentElementNode iDocumentElementNode, Class<?> clazz) {
        int n = this.indexOf(iDocumentElementNode);
        if (n <= 0 || n >= this.getChildCount()) {
            return null;
        }
        int n2 = n - 1;
        while (n2 >= 0) {
            IDocumentElementNode iDocumentElementNode2 = this.getChildAt(n2);
            if (clazz.isInstance(iDocumentElementNode2)) {
                return iDocumentElementNode2;
            }
            --n2;
        }
        return null;
    }

    @Override
    public IModel getSharedModel() {
        return this.fModel;
    }

    @Override
    public boolean hasChildNodes(Class<?> clazz) {
        ArrayList<IDocumentElementNode> arrayList = this.getChildNodesList();
        for (IDocumentElementNode iDocumentElementNode : arrayList) {
            if (!clazz.isInstance(iDocumentElementNode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEditable() {
        return this.fModel.isEditable();
    }

    @Override
    public boolean isFirstChildNode(IDocumentElementNode iDocumentElementNode, Class<?> clazz) {
        int n = this.indexOf(iDocumentElementNode);
        if (n < 0 || n >= this.getChildCount()) {
            return false;
        }
        if (n == 0) {
            return true;
        }
        int n2 = 0;
        while (n2 < n) {
            if (clazz.isInstance(this.getChildAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean isInTheModel() {
        return this.fInTheModel;
    }

    @Override
    public boolean isLastChildNode(IDocumentElementNode iDocumentElementNode, Class<?> clazz) {
        int n = this.indexOf(iDocumentElementNode);
        int n2 = this.getChildCount() - 1;
        if (n < 0 || n > n2) {
            return false;
        }
        if (n == n2) {
            return true;
        }
        int n3 = n + 1;
        while (n3 <= n2) {
            if (clazz.isInstance(this.getChildAt(n3))) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    @Override
    public void moveChildNode(IDocumentElementNode iDocumentElementNode, int n, boolean bl) {
        if (n == 0) {
            return;
        }
        int n2 = this.indexOf(iDocumentElementNode);
        if (n2 == -1) {
            return;
        }
        int n3 = n + n2;
        if (n3 < 0 || n3 >= this.getChildCount()) {
            return;
        }
        if (n == -1 || n == 1) {
            IDocumentElementNode iDocumentElementNode2 = this.getChildAt(n3);
            if (iDocumentElementNode2 == null) {
                return;
            }
            this.swap(iDocumentElementNode, iDocumentElementNode2, bl);
        } else {
            this.removeChildNode(iDocumentElementNode, bl);
            IDocumentElementNode iDocumentElementNode3 = this.clone(iDocumentElementNode);
            this.addChildNode(iDocumentElementNode3, n3, bl);
        }
    }

    @Override
    public void reconnect(IDocumentElementNode iDocumentElementNode, IModel iModel) {
        super.reconnect(iDocumentElementNode, iModel);
        this.fInTheModel = true;
        this.fModel = iModel;
    }

    @Override
    public IDocumentElementNode removeChildNode(IDocumentElementNode iDocumentElementNode) {
        IDocumentElementNode iDocumentElementNode2 = super.removeChildNode(iDocumentElementNode);
        if (iDocumentElementNode2 != null && iDocumentElementNode2 instanceof IDocumentObject) {
            ((IDocumentObject)iDocumentElementNode2).setInTheModel(false);
        }
        return iDocumentElementNode2;
    }

    @Override
    public IDocumentElementNode removeChildNode(IDocumentElementNode iDocumentElementNode, boolean bl) {
        IDocumentElementNode iDocumentElementNode2 = this.removeChildNode(iDocumentElementNode);
        if (bl && this.shouldFireEvent()) {
            this.fireStructureChanged(iDocumentElementNode, 2);
        }
        return iDocumentElementNode2;
    }

    @Override
    public IDocumentElementNode removeChildNode(int n) {
        IDocumentElementNode iDocumentElementNode = super.removeChildNode(n);
        if (iDocumentElementNode != null && iDocumentElementNode instanceof IDocumentObject) {
            ((IDocumentObject)iDocumentElementNode).setInTheModel(false);
        }
        return iDocumentElementNode;
    }

    @Override
    public IDocumentElementNode removeChildNode(int n, Class<?> clazz) {
        if (n < 0 || n >= this.getChildCount() || !clazz.isInstance(this.getChildAt(n))) {
            return null;
        }
        IDocumentElementNode iDocumentElementNode = this.removeChildNode(n);
        return iDocumentElementNode;
    }

    @Override
    public IDocumentElementNode removeChildNode(int n, Class<?> clazz, boolean bl) {
        IDocumentElementNode iDocumentElementNode = this.removeChildNode(n, clazz);
        if (bl && this.shouldFireEvent()) {
            this.fireStructureChanged(iDocumentElementNode, 2);
        }
        return iDocumentElementNode;
    }

    @Override
    public void reset() {
        this.fModel = null;
        this.fInTheModel = false;
    }

    @Override
    public boolean setBooleanAttributeValue(String string, boolean bl) {
        String string2 = Boolean.valueOf(bl).toString();
        return this.setXMLAttribute(string, string2);
    }

    @Override
    public void setChildNode(IDocumentElementNode iDocumentElementNode, Class<?> clazz) {
        boolean bl = this.shouldFireEvent();
        IDocumentElementNode iDocumentElementNode2 = this.getChildNode(clazz);
        if (iDocumentElementNode == null && iDocumentElementNode2 == null) {
            return;
        }
        if (iDocumentElementNode == null) {
            this.removeChildNode(iDocumentElementNode2, bl);
        } else if (iDocumentElementNode2 == null) {
            this.addChildNode(iDocumentElementNode, bl);
        } else {
            this.replaceChildNode(iDocumentElementNode, iDocumentElementNode2, bl);
        }
    }

    @Override
    public void setInTheModel(boolean bl) {
        this.fInTheModel = bl;
    }

    @Override
    public void setSharedModel(IModel iModel) {
        this.fModel = iModel;
    }

    @Override
    public boolean setXMLAttribute(String string, String string2) {
        String string3 = this.getXMLAttributeValue(string);
        boolean bl = super.setXMLAttribute(string, string2);
        if (bl && this.shouldFireEvent()) {
            this.firePropertyChanged(string, string3, string2);
        }
        return bl;
    }

    @Override
    public boolean setXMLContent(String string) {
        String string2 = null;
        IDocumentTextNode iDocumentTextNode = this.getTextNode();
        string2 = iDocumentTextNode == null ? "" : iDocumentTextNode.getText();
        boolean bl = super.setXMLContent(string);
        if (bl && this.shouldFireEvent()) {
            this.firePropertyChanged(iDocumentTextNode, "type_pcdata", string2, string);
        }
        return bl;
    }

    @Override
    public void swap(IDocumentElementNode iDocumentElementNode, IDocumentElementNode iDocumentElementNode2, boolean bl) {
        super.swap(iDocumentElementNode, iDocumentElementNode2);
        if (bl && this.shouldFireEvent()) {
            this.firePropertyChanged(this, "type_swap", iDocumentElementNode, iDocumentElementNode2);
        }
    }

    @Override
    public void write(String string, PrintWriter printWriter) {
        printWriter.write(this.write(true));
    }

    private void firePropertyChanged(Object object, String string, Object object2, Object object3) {
        if (this.fModel.isEditable() && this.fModel instanceof IModelChangeProvider) {
            IModelChangeProvider iModelChangeProvider = (IModelChangeProvider)((Object)this.fModel);
            iModelChangeProvider.fireModelObjectChanged(object, string, object2, object3);
        }
    }

    protected void firePropertyChanged(String string, Object object, Object object2) {
        this.firePropertyChanged(this, string, object, object2);
    }

    protected void fireStructureChanged(Object object, int n) {
        this.fireStructureChanged(new Object[]{object}, n);
    }

    protected void fireStructureChanged(Object[] objectArray, int n) {
        if (this.fModel.isEditable() && this.fModel instanceof IModelChangeProvider) {
            IModelChangeProvider iModelChangeProvider = (IModelChangeProvider)((Object)this.fModel);
            ModelChangedEvent modelChangedEvent = new ModelChangedEvent(iModelChangeProvider, n, objectArray, null);
            iModelChangeProvider.fireModelChanged(modelChangedEvent);
        }
    }

    @Override
    protected String getFileEncoding() {
        if (this.fModel != null && this.fModel instanceof IEditingModel) {
            return ((IEditingModel)this.fModel).getCharset();
        }
        return super.getFileEncoding();
    }

    @Override
    protected String getLineDelimiter() {
        if (this.fModel instanceof IEditingModel) {
            IDocument iDocument = ((IEditingModel)this.fModel).getDocument();
            return TextUtilities.getDefaultLineDelimiter((IDocument)iDocument);
        }
        return super.getLineDelimiter();
    }

    protected void replaceChildNode(IDocumentElementNode iDocumentElementNode, IDocumentElementNode iDocumentElementNode2, boolean bl) {
        int n = this.indexOf(iDocumentElementNode2);
        if (n < 0) {
            return;
        }
        this.addChildNode(iDocumentElementNode, n, bl);
        this.removeChildNode(iDocumentElementNode2, bl);
    }

    protected boolean shouldFireEvent() {
        return this.isInTheModel() && this.isEditable();
    }
}

