/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal.launching;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.launching.Messages;
import org.eclipse.mtj.core.internal.launching.StackTraceEntry;
import org.eclipse.mtj.core.internal.launching.StackTraceParserException;
import org.eclipse.mtj.core.internal.utils.Utils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackTraceParser {
    private IJavaProject project;

    public StackTraceParser(IJavaProject iJavaProject) {
        this.project = iJavaProject;
    }

    /*
     * Unable to fully structure code
     */
    public Stack<StackTraceEntry> parseStackTrace(Stack<StackTraceEntry> var1_1) throws StackTraceParserException {
        var2_2 = new Stack<StackTraceEntry>();
        var3_3 = new Stack<StackTraceEntry>();
        var3_3.addAll(var1_1);
        var4_4 = null;
        var5_5 = null;
        var6_6 = null;
        block2: while (!var3_3.isEmpty() && var6_6 == null) {
            var4_4 = (StackTraceEntry)var3_3.pop();
            var6_6 = this.getStackBaseMethod(var4_4);
            if (var6_6 != null) ** GOTO lbl28
            continue;
lbl-1000:
            // 1 sources

            {
                try {
                    var5_5 = (StackTraceEntry)var3_3.pop();
                    var6_6 = this.getCalleeMethodNode(var6_6, var4_4, var5_5);
                    var2_2.push(var4_4);
                    var4_4 = var5_5;
                    continue;
                }
                catch (StackTraceParserException v0) {
                    if (var4_4.getLine() != -2147483648) {
                        var2_2.push(var4_4);
                    }
                    var3_3.push(var5_5);
                    var6_6 = null;
                    continue block2;
                }
lbl28:
                // 2 sources

                ** while (!var3_3.isEmpty())
            }
lbl29:
            // 1 sources

        }
        if (var4_4 != null && var6_6 != null) {
            var7_7 = this.getStackTopCalleeLine(var6_6, var4_4);
            var4_4.setSourcePath(this.getSourceFile(var4_4.getClassName()));
            var4_4.setLine(var7_7);
            var2_2.push(var4_4);
        }
        return var2_2;
    }

    private File getSourceFile(String string) throws StackTraceParserException {
        File file = null;
        try {
            String[] stringArray = Utils.getJavaProjectSourceDirectories(this.project);
            int n = 0;
            while (n < stringArray.length) {
                File file2 = this.project.getProject().getLocation().append(stringArray[n]).toFile();
                file = this.findClassFile(file2, string);
                if (file == null) {
                    ++n;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            MTJCorePlugin.log(4, exception.getMessage(), exception);
        }
        return file;
    }

    private File findClassFile(File file, String string) {
        File file2 = null;
        int n = string.indexOf("$");
        if (n >= 0) {
            string = string.substring(0, n);
        }
        if ((n = string.lastIndexOf(".")) >= 0) {
            String string2 = string.substring(0, n);
            String[] stringArray = string2.split(".");
            int n2 = 0;
            while (n2 < stringArray.length) {
                file2 = new File(file, stringArray[n2]);
                if (file2.exists()) {
                    file = file2;
                }
                ++n2;
            }
        } else {
            file2 = new File(file, String.valueOf(string) + ".java");
        }
        if (file2 != null && !file2.exists()) {
            file2 = null;
        }
        return file2;
    }

    private int getStackTopCalleeLine(MethodNode methodNode, StackTraceEntry stackTraceEntry) {
        int n = Integer.MIN_VALUE;
        AbstractInsnNode[] abstractInsnNodeArray = methodNode.instructions.toArray();
        int n2 = 0;
        while (n2 < abstractInsnNodeArray.length) {
            if (abstractInsnNodeArray[n2] instanceof LineNumberNode) {
                LineNumberNode lineNumberNode = (LineNumberNode)abstractInsnNodeArray[n2];
                int n3 = lineNumberNode.start.getLabel().getOffset();
                if (n3 >= stackTraceEntry.getOffset()) break;
                n = lineNumberNode.line;
            }
            ++n2;
        }
        return n;
    }

    private MethodNode getCalleeMethodNode(MethodNode methodNode, StackTraceEntry stackTraceEntry, StackTraceEntry stackTraceEntry2) throws StackTraceParserException {
        LineNumberNode lineNumberNode = null;
        int n = Integer.MIN_VALUE;
        AbstractInsnNode[] abstractInsnNodeArray = methodNode.instructions.toArray();
        int n2 = 0;
        while (n2 < abstractInsnNodeArray.length) {
            LineNumberNode lineNumberNode2;
            if (abstractInsnNodeArray[n2] instanceof LineNumberNode) {
                lineNumberNode2 = (LineNumberNode)abstractInsnNodeArray[n2];
                int n3 = lineNumberNode2.start.getLabel().getOffset();
                if (n3 >= stackTraceEntry.getOffset()) break;
                n = lineNumberNode2.line;
            } else if (abstractInsnNodeArray[n2] instanceof MethodInsnNode) {
                lineNumberNode2 = (MethodInsnNode)abstractInsnNodeArray[n2];
                if (lineNumberNode2.owner.equals(stackTraceEntry2.getClassName()) && lineNumberNode2.name.equals(stackTraceEntry2.getMethodName())) {
                    lineNumberNode = lineNumberNode2;
                }
            }
            ++n2;
        }
        stackTraceEntry.setSourcePath(this.getSourceFile(stackTraceEntry.getClassName()));
        stackTraceEntry.setLine(n);
        if (lineNumberNode == null) {
            throw new StackTraceParserException("Unable to realize target method.");
        }
        MethodNode methodNode2 = this.getMethodNode((MethodInsnNode)lineNumberNode);
        if (methodNode2 == null) {
            throw new StackTraceParserException("Unable to realize method node.");
        }
        return methodNode2;
    }

    private MethodNode getMethodNode(MethodInsnNode methodInsnNode) throws StackTraceParserException {
        MethodNode methodNode = null;
        ClassNode classNode = this.getClassNode(methodInsnNode.owner);
        List list = classNode.methods;
        for (MethodNode methodNode2 : list) {
            if (!methodNode2.name.equals(methodInsnNode.name) || !methodNode2.desc.equals(methodInsnNode.desc)) continue;
            methodNode = methodNode2;
            break;
        }
        return methodNode;
    }

    private MethodNode getStackBaseMethod(StackTraceEntry stackTraceEntry) throws StackTraceParserException {
        MethodNode methodNode = null;
        ClassNode classNode = null;
        try {
            classNode = this.getClassNode(stackTraceEntry.getClassName());
        }
        catch (StackTraceParserException stackTraceParserException) {
            return null;
        }
        List list = classNode.methods;
        for (MethodNode methodNode2 : list) {
            if (!methodNode2.name.equals(stackTraceEntry.getMethodName())) continue;
            if (methodNode == null) {
                methodNode = methodNode2;
                continue;
            }
            return null;
        }
        if (methodNode == null) {
            throw new StackTraceParserException(Messages.bind((String)Messages.StackTraceParser_getStackBaseMethod_method_not_found, (Object[])new String[]{stackTraceEntry.getClassName(), stackTraceEntry.getMethodName()}));
        }
        return methodNode;
    }

    private ClassNode getClassNode(String string) throws StackTraceParserException {
        ClassNode classNode = new ClassNode();
        try {
            IPath iPath = this.project.getProject().getLocation().append(this.project.getOutputLocation().removeFirstSegments(1));
            FileInputStream fileInputStream = new FileInputStream(new File(String.valueOf(iPath.toFile().getAbsolutePath()) + File.separator + string.replace(".", "/") + ".class"));
            ClassReader classReader = new ClassReader((InputStream)fileInputStream);
            classReader.accept((ClassVisitor)classNode, 0);
            ClassWriter classWriter = new ClassWriter(0);
            classNode.accept((ClassVisitor)classWriter);
        }
        catch (IOException iOException) {
            throw new StackTraceParserException(iOException);
        }
        catch (JavaModelException javaModelException) {
            throw new StackTraceParserException(javaModelException);
        }
        return classNode;
    }
}

