/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.text;

import org.eclipse.mtj.internal.core.text.DocumentXMLNode;
import org.eclipse.mtj.internal.core.text.IDocumentAttributeNode;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.util.MTJXMLHelper;

public class DocumentAttributeNode
extends DocumentXMLNode
implements IDocumentAttributeNode {
    private static final long serialVersionUID = 1L;
    private transient IDocumentElementNode fEnclosingElement = null;
    private String fName = null;
    private transient int fNameLength = -1;
    private transient int fNameOffset = -1;
    private String fValue = null;
    private transient int fValueLength = -1;
    private transient int fValueOffset = -1;

    public String getAttributeName() {
        return this.fName;
    }

    public String getAttributeValue() {
        return this.fValue;
    }

    public IDocumentElementNode getEnclosingElement() {
        return this.fEnclosingElement;
    }

    public int getLength() {
        int n = this.getValueOffset() - this.getNameOffset();
        int n2 = this.getValueLength();
        int n3 = 1;
        int n4 = n + n2 + n3;
        return n4;
    }

    public int getNameLength() {
        return this.fNameLength;
    }

    public int getNameOffset() {
        return this.fNameOffset;
    }

    public int getOffset() {
        return this.getNameOffset();
    }

    public int getValueLength() {
        return this.fValueLength;
    }

    public int getValueOffset() {
        return this.fValueOffset;
    }

    public int getXMLType() {
        return 1;
    }

    public void reconnect(IDocumentElementNode iDocumentElementNode) {
        this.fEnclosingElement = iDocumentElementNode;
        this.fNameLength = -1;
        this.fNameOffset = -1;
        this.fValueLength = -1;
        this.fValueOffset = -1;
    }

    public void setAttributeName(String string) {
        this.fName = string;
    }

    public void setAttributeValue(String string) {
        this.fValue = string;
    }

    public void setEnclosingElement(IDocumentElementNode iDocumentElementNode) {
        this.fEnclosingElement = iDocumentElementNode;
    }

    public void setNameLength(int n) {
        this.fNameLength = n;
    }

    public void setNameOffset(int n) {
        this.fNameOffset = n;
    }

    public void setValueLength(int n) {
        this.fValueLength = n;
    }

    public void setValueOffset(int n) {
        this.fValueOffset = n;
    }

    public String write() {
        return String.valueOf(this.fName) + "=\"" + MTJXMLHelper.getWritableAttributeString(this.fValue) + "\"";
    }
}

