/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.model.preprocessor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.persistence.XMLPersistenceProvider;
import org.eclipse.mtj.core.internal.utils.XMLUtils;
import org.eclipse.mtj.core.model.preprocessor.ISymbolDefinitionSetChangeListener;
import org.eclipse.mtj.core.model.preprocessor.SymbolDefinitionSet;
import org.eclipse.mtj.core.persistence.IPersistable;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolDefinitionSetRegistry
implements IPersistable {
    public static final SymbolDefinitionSetRegistry singleton = new SymbolDefinitionSetRegistry();
    private static final String FILENAME = "symbolDefinitions.xml";
    private Map<String, IPersistable> registryMap;
    List<ISymbolDefinitionSetChangeListener> listeners = new ArrayList<ISymbolDefinitionSetChangeListener>();

    private SymbolDefinitionSetRegistry() {
    }

    public void addDefinitionSet(SymbolDefinitionSet symbolDefinitionSet) throws PersistenceException {
        String string = symbolDefinitionSet.getName();
        if (string == null) {
            throw new IllegalStateException("Definition must have a name specified.");
        }
        this.getRegistryMap().put(symbolDefinitionSet.getName(), symbolDefinitionSet);
        this.notifyListeners();
    }

    public SymbolDefinitionSet addNewDefinitionSet(String string) throws PersistenceException {
        SymbolDefinitionSet symbolDefinitionSet = new SymbolDefinitionSet();
        symbolDefinitionSet.setName(string);
        this.addDefinitionSet(symbolDefinitionSet);
        this.notifyListeners();
        return symbolDefinitionSet;
    }

    public void addSymbolDefinitionSetChangeListener(ISymbolDefinitionSetChangeListener iSymbolDefinitionSetChangeListener) {
        this.listeners.add(iSymbolDefinitionSetChangeListener);
    }

    public void clear() throws PersistenceException {
        this.getRegistryMap().clear();
    }

    public String[] getAllDefinitionSetNames() throws PersistenceException {
        Set<String> set = this.registryMap.keySet();
        return set.toArray(new String[set.size()]);
    }

    public SymbolDefinitionSet[] getAllSetDefinitions() throws PersistenceException {
        Collection<IPersistable> collection = this.getRegistryMap().values();
        return collection.toArray(new SymbolDefinitionSet[collection.size()]);
    }

    private synchronized Map<String, IPersistable> getRegistryMap() throws PersistenceException {
        if (this.registryMap == null) {
            this.registryMap = new HashMap<String, IPersistable>();
            this.load();
        }
        return this.registryMap;
    }

    private File getStoreFile() {
        IPath iPath = MTJCorePlugin.getDefault().getStateLocation();
        IPath iPath2 = iPath.append(FILENAME);
        return iPath2.toFile();
    }

    public SymbolDefinitionSet getSymbolDefinitionSet(String string) throws PersistenceException {
        return (SymbolDefinitionSet)this.getRegistryMap().get(string);
    }

    public void load() throws PersistenceException {
        File file;
        if (this.registryMap != null) {
            this.registryMap.clear();
        }
        if ((file = this.getStoreFile()).exists()) {
            try {
                Document document = XMLUtils.readDocument(file);
                XMLPersistenceProvider xMLPersistenceProvider = new XMLPersistenceProvider(document);
                this.loadUsing(xMLPersistenceProvider);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new PersistenceException(parserConfigurationException.getMessage(), parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw new PersistenceException(sAXException.getMessage(), sAXException);
            }
            catch (IOException iOException) {
                throw new PersistenceException(iOException.getMessage(), iOException);
            }
        }
    }

    @Override
    public void loadUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        String string;
        if (this.registryMap != null && (string = iPersistenceProvider.loadString("mtjKeys")) != null && string.length() > 0) {
            String[] stringArray;
            String[] stringArray2 = stringArray = string.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                SymbolDefinitionSet symbolDefinitionSet = (SymbolDefinitionSet)iPersistenceProvider.loadPersistable(string2);
                this.registryMap.put(symbolDefinitionSet.getName(), symbolDefinitionSet);
                ++n2;
            }
        }
    }

    private void notifyListeners() {
        for (ISymbolDefinitionSetChangeListener iSymbolDefinitionSetChangeListener : this.listeners) {
            iSymbolDefinitionSetChangeListener.symbolDefinitionSetChanged();
        }
    }

    public void removeDefinitionSet(String string) {
        this.registryMap.remove(string);
        this.notifyListeners();
    }

    public void removeDefinitionSet(SymbolDefinitionSet symbolDefinitionSet) {
        this.removeDefinitionSet(symbolDefinitionSet.getName());
        this.notifyListeners();
    }

    public void removeSymbolDefinitionSetChangeListener(ISymbolDefinitionSetChangeListener iSymbolDefinitionSetChangeListener) {
        this.listeners.remove(iSymbolDefinitionSetChangeListener);
    }

    public void store() throws PersistenceException, TransformerException, IOException {
        XMLPersistenceProvider xMLPersistenceProvider = new XMLPersistenceProvider("symbolDefinitionsRegistry");
        this.storeUsing(xMLPersistenceProvider);
        XMLUtils.writeDocument(this.getStoreFile(), xMLPersistenceProvider.getDocument());
    }

    @Override
    public void storeUsing(IPersistenceProvider iPersistenceProvider) throws PersistenceException {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<IPersistable> iterator = this.getRegistryMap().values().iterator();
        while (iterator.hasNext()) {
            SymbolDefinitionSet symbolDefinitionSet = (SymbolDefinitionSet)iterator.next();
            String string = symbolDefinitionSet.getStorableName();
            iPersistenceProvider.storePersistable(string, symbolDefinitionSet);
            stringBuffer.append(string);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        iPersistenceProvider.storeString("mtjKeys", stringBuffer.toString());
    }
}

