/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal.overtheair;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.overtheair.OTAHandler;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SocketListener;
import org.mortbay.http.handler.NotFoundHandler;
import org.mortbay.log.LogImpl;
import org.mortbay.log.LogSink;
import org.mortbay.log.OutputStreamLogSink;

public class OTAServer {
    public static final OTAServer instance = new OTAServer();
    public static LogImpl logImpl = new LogImpl();
    private HttpServer httpServer;
    HttpServer server = this.getHttpServer();

    public static int getPort() {
        HttpListener httpListener = instance.getHttpServer().getListeners()[0];
        return httpListener.getPort();
    }

    private OTAServer() {
    }

    public void start() throws Exception {
        if (!this.server.isStarted()) {
            this.server.start();
        }
    }

    public void stop() throws InterruptedException {
        HttpServer httpServer = this.getHttpServer();
        if (httpServer.isStarted()) {
            httpServer.stop();
        }
    }

    private void configureContext(HttpServer httpServer) {
        HttpContext httpContext = new HttpContext();
        httpContext.setContextPath("/ota/*");
        httpServer.addContext(httpContext);
        httpContext.addHandler((HttpHandler)new OTAHandler());
        httpContext.addHandler((HttpHandler)new NotFoundHandler());
    }

    private void configureListener(HttpServer httpServer) {
        SocketListener socketListener = new SocketListener();
        socketListener.setMinThreads(1);
        socketListener.setMaxThreads(2);
        socketListener.setMaxIdleTimeMs(10000);
        socketListener.setDaemon(true);
        Preferences preferences = MTJCorePlugin.getDefault().getPluginPreferences();
        if (preferences.getBoolean("ota_port_defined")) {
            int n = preferences.getInt("ota_port");
            socketListener.setPort(n);
        }
        httpServer.addListener((HttpListener)socketListener);
    }

    private void configureLogging() throws Exception {
        System.setProperty("LOG_FILE_RETAIN_DAYS", "5");
        IPath iPath = MTJCorePlugin.getDefault().getStateLocation();
        IPath iPath2 = iPath.append("jetty");
        File file = iPath2.toFile();
        if (!file.exists()) {
            file.mkdir();
        }
        File file2 = new File(file, "logfile");
        String string = file2 + "yyyy_mm_dd.txt";
        OutputStreamLogSink outputStreamLogSink = new OutputStreamLogSink(string);
        outputStreamLogSink.start();
        logImpl.add((LogSink)outputStreamLogSink);
    }

    private HttpServer createHttpServer() {
        HttpServer httpServer = new HttpServer();
        this.configureListener(httpServer);
        this.configureContext(httpServer);
        return httpServer;
    }

    private HttpServer getHttpServer() {
        if (this.httpServer == null) {
            this.httpServer = this.createHttpServer();
            try {
                this.configureLogging();
            }
            catch (Exception exception) {
                MTJCorePlugin.log(2, "configureLogging", exception);
            }
        }
        return this.httpServer;
    }
}

