/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.console;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.mtj.core.console.IBuildConsoleProxy;

public class BuildConsoleProxy
implements IBuildConsoleProxy {
    public static final BuildConsoleProxy instance = new BuildConsoleProxy();
    private static NullOutputStream nullStream = new NullOutputStream();
    private IBuildConsoleProxy proxy;
    private PrintWriter traceWriter;

    private BuildConsoleProxy() {
    }

    public void addConsoleStreamListener(String string, IStreamMonitor iStreamMonitor) {
        final PrintWriter printWriter = this.getConsoleWriter(string);
        iStreamMonitor.addListener(new IStreamListener(){

            public void streamAppended(String string, IStreamMonitor iStreamMonitor) {
                printWriter.print(string);
                printWriter.flush();
            }
        });
        printWriter.print(iStreamMonitor.getContents());
        printWriter.flush();
    }

    public PrintWriter getConsoleWriter(String string) {
        return this.proxy == null ? new PrintWriter(nullStream) : this.proxy.getConsoleWriter(string);
    }

    public void trace(String string) {
        if (this.traceWriter == null) {
            this.traceWriter = this.getConsoleWriter("trace");
        }
        this.traceWriter.print(string);
        this.traceWriter.flush();
    }

    public void traceln(String string) {
        this.trace(String.valueOf(string) + "\n");
    }

    public void setProxy(IBuildConsoleProxy iBuildConsoleProxy) {
        this.proxy = iBuildConsoleProxy;
        this.traceWriter = null;
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        public void write(int n) throws IOException {
        }
    }
}

