/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.mtj.core.IMTJCoreConstants;
import org.eclipse.mtj.core.hook.sourceMapper.SourceMapper;
import org.eclipse.mtj.core.hook.sourceMapper.SourceMapperAccess;
import org.eclipse.mtj.core.internal.PreprocessedProjectMigrationRunnable;
import org.eclipse.mtj.core.internal.preprocessor.PreprocessedSourceMapper;
import org.eclipse.mtj.core.model.Version;
import org.eclipse.mtj.core.model.library.LibrarySpecification;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;
import org.eclipse.mtj.core.model.project.MidletSuiteFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class MTJCorePlugin
extends Plugin
implements IMTJCoreConstants {
    public static final IStatus OK_STATUS = new Status(0, "org.eclipse.mtj.core", 0, "OK", null);
    private static MTJCorePlugin plugin;
    private static final IStatus PROMPTER_STATUS;
    private ResourceBundle resourceBundle;
    private LibrarySpecification[] configSpecs;
    private LibrarySpecification[] profileSpecs;

    static {
        PROMPTER_STATUS = new Status(1, "org.eclipse.debug.ui", 200, "", null);
    }

    public static LibrarySpecification[] getConfigurationSpecifications() throws CoreException {
        MTJCorePlugin mTJCorePlugin = MTJCorePlugin.getDefault();
        if (mTJCorePlugin.configSpecs == null) {
            IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.mtj.core", "configurations");
            IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            mTJCorePlugin.configSpecs = new LibrarySpecification[iConfigurationElementArray.length];
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                mTJCorePlugin.configSpecs[n] = MTJCorePlugin.createComponentSpecification(iConfigurationElementArray[n]);
                ++n;
            }
        }
        return mTJCorePlugin.configSpecs;
    }

    public static MTJCorePlugin getDefault() {
        return plugin;
    }

    public static String getDeploymentDirectoryName() {
        return MTJCorePlugin.getDefault().getPluginPreferences().getString("deployment_dir");
    }

    public static String getPluginVersion() {
        Bundle bundle = MTJCorePlugin.getDefault().getBundle();
        return (String)bundle.getHeaders().get("Bundle-Version");
    }

    public static LibrarySpecification[] getProfileSpecifications() throws CoreException {
        MTJCorePlugin mTJCorePlugin = MTJCorePlugin.getDefault();
        if (mTJCorePlugin.profileSpecs == null) {
            IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.mtj.core", "profiles");
            IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            mTJCorePlugin.profileSpecs = new LibrarySpecification[iConfigurationElementArray.length];
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                mTJCorePlugin.profileSpecs[n] = MTJCorePlugin.createComponentSpecification(iConfigurationElementArray[n]);
                ++n;
            }
        }
        return mTJCorePlugin.profileSpecs;
    }

    public static File getProguardJarFile() {
        String string = MTJCorePlugin.getDefault().getPluginPreferences().getString("proguard_dir");
        File file = new File(string);
        File file2 = new File(file, "lib");
        File file3 = new File(file2, "proguard.jar");
        return file3;
    }

    public static boolean getProjectBooleanPreference(IProject iProject, String string) {
        IScopeContext[] iScopeContextArray = new IScopeContext[]{new ProjectScope(iProject), new InstanceScope(), new DefaultScope()};
        IPreferencesService iPreferencesService = Platform.getPreferencesService();
        return iPreferencesService.getBoolean("org.eclipse.mtj.core", string, false, iScopeContextArray);
    }

    public static IEclipsePreferences getProjectPreferences(IProject iProject) {
        ProjectScope projectScope = new ProjectScope(iProject);
        return projectScope.getNode("org.eclipse.mtj.core");
    }

    public static String getProjectStringPreference(IProject iProject, String string) {
        IScopeContext[] iScopeContextArray = new IScopeContext[]{new ProjectScope(iProject), new InstanceScope(), new DefaultScope()};
        IPreferencesService iPreferencesService = Platform.getPreferencesService();
        return iPreferencesService.getString("org.eclipse.mtj.core", string, null, iScopeContextArray);
    }

    public static String getResourcesDirectoryName() {
        return MTJCorePlugin.getDefault().getPluginPreferences().getString("resources_dir");
    }

    public static String getVerifiedOutputDirectoryName() {
        return MTJCorePlugin.getDefault().getPluginPreferences().getString("verified_dir");
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static void log(int n, String string) {
        MTJCorePlugin.log(n, string, null);
    }

    public static void log(int n, String string, Throwable throwable) {
        if (string == null) {
            string = throwable.getMessage();
        }
        if (string == null) {
            string = "No Message";
        }
        MTJCorePlugin mTJCorePlugin = MTJCorePlugin.getDefault();
        String string2 = "org.eclipse.mtj.core";
        Status status = new Status(n, string2, 0, string, throwable);
        mTJCorePlugin.getLog().log((IStatus)status);
    }

    public static void log(int n, Throwable throwable) {
        MTJCorePlugin.log(n, throwable.getMessage(), throwable);
    }

    public static IStatus newStatus(int n, int n2, String string) {
        return MTJCorePlugin.newStatus(n, n2, string, null);
    }

    public static IStatus newStatus(int n, int n2, String string, Throwable throwable) {
        return new Status(n, "org.eclipse.mtj.core", n2, string, throwable);
    }

    public static void setResourcesAsDerived(IContainer iContainer) throws CoreException {
        if (iContainer.exists()) {
            IResource[] iResourceArray;
            iContainer.setDerived(true);
            IResource[] iResourceArray2 = iResourceArray = iContainer.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource = iResourceArray2[n2];
                if (iResource instanceof IContainer) {
                    MTJCorePlugin.setResourcesAsDerived((IContainer)iResource);
                } else {
                    iResource.setDerived(true);
                }
                ++n2;
            }
        }
    }

    public static Object statusPrompt(IStatus iStatus, Object object) throws CoreException {
        Object object2 = null;
        IStatusHandler iStatusHandler = DebugPlugin.getDefault().getStatusHandler(PROMPTER_STATUS);
        if (iStatusHandler == null) {
            throw new CoreException(iStatus);
        }
        object2 = iStatusHandler.handleStatus(iStatus, object);
        return object2;
    }

    public static void throwCoreException(int n, int n2, String string) throws CoreException {
        if (string == null) {
            string = "[No Message]";
        }
        Status status = new Status(n, "org.eclipse.mtj.core", n2, string, null);
        throw new CoreException((IStatus)status);
    }

    public static void throwCoreException(int n, int n2, Throwable throwable) throws CoreException {
        String string = null;
        if (throwable != null) {
            string = throwable.getMessage();
        }
        if (string == null) {
            string = "[No Message]";
        }
        Status status = new Status(n, "org.eclipse.mtj.core", n2, string, throwable);
        throw new CoreException((IStatus)status);
    }

    private static LibrarySpecification createComponentSpecification(IConfigurationElement iConfigurationElement) throws CoreException {
        String string = iConfigurationElement.getAttribute("id");
        String string2 = iConfigurationElement.getAttribute("name");
        String string3 = iConfigurationElement.getAttribute("version");
        Version version = new Version(string3);
        LibrarySpecification librarySpecification = new LibrarySpecification();
        librarySpecification.setIdentifier(string);
        librarySpecification.setName(string2);
        librarySpecification.setVersion(version);
        return librarySpecification;
    }

    public MTJCorePlugin() {
        if (plugin == null) {
            plugin = this;
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
                switch (iResourceChangeEvent.getType()) {
                    case 4: {
                        IProject iProject;
                        IMidletSuiteProject iMidletSuiteProject;
                        IResource iResource = iResourceChangeEvent.getResource();
                        if (!(iResource instanceof IProject) || (iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((iProject = (IProject)iResource).getName())) == null) break;
                        MidletSuiteFactory.removeMidletSuiteProject(iMidletSuiteProject.getJavaProject());
                    }
                }
            }
        });
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.mtj.core.MTJPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        SourceMapperAccess.setSourceMapper((SourceMapper)new PreprocessedSourceMapper());
        new MigrationJob().schedule(5000L);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
    }

    private void doMigration(IProgressMonitor iProgressMonitor) throws CoreException {
        ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)new PreprocessedProjectMigrationRunnable(), iProgressMonitor);
    }

    public static InputStream getResourceAsStream(IPath iPath) {
        InputStream inputStream = null;
        URL uRL = FileLocator.find((Bundle)MTJCorePlugin.getDefault().getBundle(), (IPath)iPath, null);
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return inputStream;
    }

    private class MigrationJob
    extends Job {
        MigrationJob() {
            super("MTJ Migration");
            this.setPriority(20);
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            IStatus iStatus = null;
            try {
                MTJCorePlugin.this.doMigration(iProgressMonitor);
                iStatus = OK_STATUS;
            }
            catch (CoreException coreException) {
                iStatus = coreException.getStatus();
            }
            return iStatus;
        }
    }
}

