/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal.launching;

import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.mtj.core.MTJCoreStrings;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.launching.EmulatorRunner;
import org.eclipse.mtj.core.internal.utils.ColonDelimitedProperties;
import org.eclipse.mtj.core.internal.utils.Utils;
import org.eclipse.mtj.core.model.device.DeviceRegistry;
import org.eclipse.mtj.core.model.device.IDevice;
import org.eclipse.mtj.core.model.device.impl.AbstractDevice;
import org.eclipse.mtj.core.model.device.impl.JavaEmulatorDevice;
import org.eclipse.mtj.core.model.jad.ApplicationDescriptor;
import org.eclipse.mtj.core.model.project.IMidletSuiteProject;
import org.eclipse.mtj.core.model.project.MidletSuiteFactory;
import org.eclipse.mtj.core.persistence.PersistenceException;

public class EmulatorLaunchConfigDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    private static final IStatus NO_MIDLET_STATUS = new Status(4, "org.eclipse.mtj.core", 100, "", null);
    private static final String LIST_INSTALLED_MIDLET_COMMAND = "-Xjam:list";
    private static final String REMOVE_INSTALLED_MIDLET_COMMAND = "-Xjam:remove=";
    private static final String DEVICE_COMMAND = "-Xdevice:";

    protected IVMRunner getVMRunner(ILaunchConfiguration iLaunchConfiguration, IDevice iDevice, String string) throws CoreException {
        IMidletSuiteProject iMidletSuiteProject = this.getMidletSuite(iLaunchConfiguration);
        return new EmulatorRunner(iMidletSuiteProject, iDevice, string);
    }

    protected VMRunnerConfiguration getVMRunnerConfiguration(ILaunchConfiguration iLaunchConfiguration, IDevice iDevice, String string) throws CoreException {
        File file = this.verifyWorkingDirectory(iLaunchConfiguration);
        String string2 = null;
        if (file != null) {
            string2 = file.getAbsolutePath();
        }
        VMRunnerConfiguration vMRunnerConfiguration = new VMRunnerConfiguration(iDevice.getName(), new String[0]);
        vMRunnerConfiguration.setVMArguments(new String[0]);
        vMRunnerConfiguration.setWorkingDirectory(string2);
        vMRunnerConfiguration.setVMSpecificAttributesMap(new HashMap());
        return vMRunnerConfiguration;
    }

    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        IDevice iDevice;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        if ((iDevice = this.getDevice(iLaunchConfiguration)) == null) {
            MTJCorePlugin.throwCoreException(4, -999, "Device is unspecified or unavailable");
        }
        iProgressMonitor.beginTask(MTJCoreStrings.getString("launchdelegate.launching", new Object[]{iLaunchConfiguration.getName()}), 3);
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        iProgressMonitor.subTask(MTJCoreStrings.getString("launchdelegate.verifying_attrs"));
        IVMRunner iVMRunner = this.getVMRunner(iLaunchConfiguration, iDevice, string);
        VMRunnerConfiguration vMRunnerConfiguration = this.getVMRunnerConfiguration(iLaunchConfiguration, iDevice, string);
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        iProgressMonitor.worked(1);
        iProgressMonitor.subTask(MTJCoreStrings.getString("launchdelegate.source_locator"));
        this.setDefaultSourceLocator(iLaunch, iLaunchConfiguration);
        iProgressMonitor.worked(1);
        ((EmulatorRunner)iVMRunner).run(vMRunnerConfiguration, iLaunchConfiguration, iLaunch, iProgressMonitor);
        if (!iProgressMonitor.isCanceled()) {
            iProgressMonitor.done();
        }
    }

    public boolean preLaunchCheck(ILaunchConfiguration iLaunchConfiguration, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        boolean bl = super.preLaunchCheck(iLaunchConfiguration, string, iProgressMonitor);
        if (bl) {
            bl = this.verifyEmulationSettings(iLaunchConfiguration, string, iProgressMonitor);
        }
        return bl;
    }

    private IDevice getDevice(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        IDevice iDevice = null;
        if (iLaunchConfiguration.getAttribute("mtj.use_project_device", true)) {
            iDevice = this.getMidletSuite(iLaunchConfiguration).getDevice();
        } else {
            String string = iLaunchConfiguration.getAttribute("mtj.emulated_device_group", "");
            String string2 = iLaunchConfiguration.getAttribute("mtj.emulated_device", "");
            try {
                iDevice = DeviceRegistry.singleton.getDevice(string, string2);
            }
            catch (PersistenceException persistenceException) {
                MTJCorePlugin.throwCoreException(4, -999, persistenceException);
            }
        }
        return iDevice;
    }

    private IMidletSuiteProject getMidletSuite(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        IJavaProject iJavaProject = this.getJavaProject(iLaunchConfiguration);
        return MidletSuiteFactory.getMidletSuiteProject(iJavaProject);
    }

    private boolean verifyEmulationSettings(ILaunchConfiguration iLaunchConfiguration, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        IMidletSuiteProject iMidletSuiteProject;
        ApplicationDescriptor applicationDescriptor;
        IJavaProject iJavaProject;
        Status status;
        boolean bl = true;
        if ("debug".equals(string) && !(bl = this.promptWhetherToContinue((IStatus)(status = new Status(1, "org.eclipse.mtj.core", 104, "", null))))) {
            return bl;
        }
        boolean bl2 = iLaunchConfiguration.getAttribute("mtj.do_ota", false);
        if (bl2 && (iJavaProject = this.getJavaProject(iLaunchConfiguration)) != null && (applicationDescriptor = (iMidletSuiteProject = MidletSuiteFactory.getMidletSuiteProject(iJavaProject)).getApplicationDescriptor()) != null) {
            boolean bl3 = bl = applicationDescriptor.getMidletCount() > 0;
            if (!bl && !(bl = this.promptWhetherToContinue(NO_MIDLET_STATUS))) {
                return bl;
            }
            this.checkAndRemoveInstalledMidlet(applicationDescriptor, iMidletSuiteProject.getDevice());
        }
        return bl;
    }

    private void checkAndRemoveInstalledMidlet(ApplicationDescriptor applicationDescriptor, IDevice iDevice) throws CoreException {
        if (!(iDevice instanceof JavaEmulatorDevice)) {
            String string = applicationDescriptor.getManifestProperties().getProperty("MIDlet-Name");
            String string2 = applicationDescriptor.getManifestProperties().getProperty("MIDlet-Vendor");
            AbstractDevice abstractDevice = (AbstractDevice)iDevice;
            File file = abstractDevice.getExecutable();
            String[] stringArray = new String[]{DEVICE_COMMAND + abstractDevice.getName(), LIST_INSTALLED_MIDLET_COMMAND};
            String[] stringArray2 = this.populateCommandLine(file, stringArray);
            File file2 = file.getParentFile();
            String string3 = Utils.getStandardOutput("get installed Midlet Suite", stringArray2, file2);
            String string4 = "\\[\\d+\\]";
            String[] stringArray3 = string3.split(string4);
            int n = 0;
            boolean bl = false;
            int n2 = 1;
            while (n2 < stringArray3.length) {
                String string5 = stringArray3[n2];
                if (string5.trim().length() > 0) {
                    ++n;
                    ColonDelimitedProperties colonDelimitedProperties = this.parseMidetSuiteInfo(string5);
                    String string6 = colonDelimitedProperties.getProperty("Name");
                    String string7 = colonDelimitedProperties.getProperty("Vendor");
                    if (string.equals(string6) && string2.equals(string7)) {
                        bl = true;
                        break;
                    }
                }
                ++n2;
            }
            if (bl) {
                stringArray = new String[]{DEVICE_COMMAND + abstractDevice.getName(), REMOVE_INSTALLED_MIDLET_COMMAND + n};
                stringArray2 = this.populateCommandLine(file, stringArray);
                Utils.getStandardOutput("remove Midlet Suite", stringArray2, file2);
            }
        }
    }

    private String[] populateCommandLine(File file, String[] stringArray) {
        boolean bl = Platform.getOS().equals("win32");
        String string = bl ? file.getName() : file.getAbsolutePath();
        ArrayList<String> arrayList = new ArrayList<String>((Collection)Arrays.asList(stringArray));
        arrayList.add(0, string);
        if (bl) {
            arrayList.add(0, "/c");
            arrayList.add(0, "cmd");
        }
        String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        return stringArray2;
    }

    private ColonDelimitedProperties parseMidetSuiteInfo(String string) {
        ColonDelimitedProperties colonDelimitedProperties = new ColonDelimitedProperties();
        StringReader stringReader = new StringReader(string);
        try {
            colonDelimitedProperties.load(stringReader);
        }
        catch (Exception exception) {
            MTJCorePlugin.log(2, "Error parsing installed apps", exception);
            MTJCorePlugin.log(2, string);
        }
        return colonDelimitedProperties;
    }

    private boolean promptWhetherToContinue(IStatus iStatus) throws CoreException {
        Boolean bl = (Boolean)MTJCorePlugin.statusPrompt(iStatus, (Object)this);
        return bl != null ? bl : false;
    }
}

