/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.l10n;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.internal.utils.Utils;
import org.eclipse.mtj.core.model.ReplaceableParametersProcessor;
import org.eclipse.mtj.internal.core.l10n.Messages;
import org.eclipse.mtj.internal.core.text.DocumentElementNode;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.l10n.L10nEntry;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocale;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.eclipse.osgi.util.NLS;

public class L10nApi {
    public static final String LOCALIZATION_DATA_FILE = "Localization Data";
    public static final String DESTINATION = "destination";
    public static final String PACKAGE = "package";
    public static final String L10N_RESOURCES_CLASS = "L10nResources.java";
    public static final String L10N_CONSTANTS_CLASS = "L10nConstants.java";

    public static boolean createLocalizationApi(IProject iProject, IPackageFragment iPackageFragment, IPath iPath) throws CoreException {
        ICompilationUnit iCompilationUnit = null;
        ICompilationUnit iCompilationUnit2 = null;
        IPackageFragment iPackageFragment2 = iPackageFragment;
        iProject.accept(new IResourceVisitor(){

            public boolean visit(IResource iResource) throws CoreException {
                if (iResource.getName().equals(L10nApi.L10N_RESOURCES_CLASS) || iResource.getName().equals(L10nApi.L10N_CONSTANTS_CLASS)) {
                    iResource.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                return true;
            }
        });
        String string = L10nApi.buildL10nResourcesClass(iPackageFragment, iPath);
        iCompilationUnit = iPackageFragment2.createCompilationUnit(L10N_RESOURCES_CLASS, string, true, null);
        string = L10nApi.buildL10nConstantsClass(iProject, iPackageFragment);
        iCompilationUnit2 = iPackageFragment2.createCompilationUnit(L10N_CONSTANTS_CLASS, string, true, null);
        return iCompilationUnit != null && iCompilationUnit2 != null;
    }

    public static String buildL10nConstantsClass(IProject iProject, IPackageFragment iPackageFragment) throws CoreException {
        Object object;
        Object object2;
        InputStream inputStream = MTJCorePlugin.getResourceAsStream((IPath)new Path("templates/L10nConstants.java.template"));
        if (inputStream == null) {
            MTJCorePlugin.throwCoreException(4, -999, "Unable to load templates/L10nResources.java.template.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        L10nModel l10nModel = L10nApi.loadL10nModel(iProject);
        if (!l10nModel.isValid()) {
            MTJCorePlugin.throwCoreException(4, -999, Messages.L10nBuilder_InvalidModel);
        }
        List<IDocumentElementNode> list = l10nModel.getLocales().getChildren();
        for (IDocumentElementNode iDocumentElementNode : list) {
            object2 = (L10nLocale)iDocumentElementNode;
            stringBuffer.append(L10nApi.writeStringConstantDeclaration(((L10nLocale)object2).getName().toUpperCase(), ((L10nLocale)object2).getName()));
            object = ((DocumentElementNode)object2).getChildNodes();
            int n = 0;
            while (n < ((IDocumentElementNode[])object).length) {
                L10nEntry l10nEntry = (L10nEntry)object[n];
                if (!arrayList.contains(l10nEntry.getKey().toUpperCase())) {
                    arrayList.add(l10nEntry.getKey().toUpperCase());
                }
                ++n;
            }
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        for (String string : arrayList) {
            stringBuffer2.append(L10nApi.writeStringConstantDeclaration(string, string));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        object2 = iPackageFragment.getElementName();
        if (object2 != null && ((String)object2).length() > 0) {
            hashMap.put(PACKAGE, NLS.bind((String)"package {0};", (Object)object2));
        } else {
            hashMap.put(PACKAGE, "");
        }
        hashMap.put("locales", stringBuffer.toString());
        hashMap.put("keys", stringBuffer2.toString());
        object = new StringBuffer(Utils.getStreamContent(inputStream));
        String string = ReplaceableParametersProcessor.processReplaceableValues(((StringBuffer)object).toString(), hashMap);
        return string;
    }

    public static String buildL10nResourcesClass(IPackageFragment iPackageFragment, IPath iPath) throws CoreException {
        InputStream inputStream = MTJCorePlugin.getResourceAsStream((IPath)new Path("templates/L10nResources.java.template"));
        if (inputStream == null) {
            MTJCorePlugin.throwCoreException(4, -999, "Unable to load templates/L10nResources.java.template.");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(DESTINATION, iPath.removeFirstSegments(1).toString());
        String string = iPackageFragment.getElementName();
        if (string != null && string.length() > 0) {
            hashMap.put(PACKAGE, NLS.bind((String)"package {0};", (Object)string));
        } else {
            hashMap.put(PACKAGE, "");
        }
        StringBuffer stringBuffer = new StringBuffer(Utils.getStreamContent(inputStream));
        String string2 = ReplaceableParametersProcessor.processReplaceableValues(stringBuffer.toString(), hashMap);
        return string2;
    }

    public static L10nModel loadL10nModel(IProject iProject) throws CoreException {
        L10nModel l10nModel = null;
        IFile iFile = iProject.getFile(LOCALIZATION_DATA_FILE);
        if (iFile.exists()) {
            IPath iPath = iFile.getLocation();
            if (iPath == null) {
                throw new CoreException(MTJCorePlugin.newStatus(4, -999, Messages.L10nBuilder_loadL10nModel_CanNotRealizeLocation));
            }
        } else {
            throw new CoreException(MTJCorePlugin.newStatus(4, -999, Messages.L10nBuilder_LocalizationDataDoesNotExist));
        }
        l10nModel = new L10nModel((IDocument)Utils.getTextDocument(iFile.getContents()), false);
        l10nModel.load();
        return l10nModel;
    }

    private static String writeStringConstantDeclaration(String string, String string2) {
        return NLS.bind((String)"\t\tpublic static final String {0} = \"{1}\";\n", (Object[])new String[]{string.replace("-", "_"), string2});
    }

    public static void syncronizeApi(L10nModel l10nModel) throws CoreException {
        IPackageFragment[] iPackageFragmentArray;
        IResource iResource = l10nModel.getUnderlyingResource();
        IJavaProject iJavaProject = JavaCore.create((IProject)iResource.getProject());
        IPackageFragment[] iPackageFragmentArray2 = iPackageFragmentArray = iJavaProject.getPackageFragments();
        int n = iPackageFragmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragment iPackageFragment = iPackageFragmentArray2[n2];
            if (iPackageFragment.getElementName().equals(l10nModel.getLocales().getPackage())) {
                L10nApi.createLocalizationApi(iJavaProject.getProject(), iPackageFragment, (IPath)new Path(l10nModel.getLocales().getDestination()));
                break;
            }
            ++n2;
        }
    }
}

