/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.model.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.mtj.core.model.configuration.AddConfigEvent;
import org.eclipse.mtj.core.model.configuration.Configuration;
import org.eclipse.mtj.core.model.configuration.IConfigurationsChangeListener;
import org.eclipse.mtj.core.model.configuration.RemoveConfigEvent;
import org.eclipse.mtj.core.model.configuration.SwitchActiveConfigEvent;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configurations
extends ArrayList<Configuration> {
    private static final long serialVersionUID = -8304504334314517586L;
    public static final String ELEM_CONFIGURATION = "configuration";
    private List<IConfigurationsChangeListener> listeners = new ArrayList<IConfigurationsChangeListener>();

    public Configurations() {
    }

    public Configurations(Element element) throws PersistenceException {
        this.populateConfigurations(element);
    }

    @Override
    public boolean add(Configuration configuration) {
        boolean bl = super.add(configuration);
        if (!bl) {
            return bl;
        }
        AddConfigEvent addConfigEvent = new AddConfigEvent(this, configuration);
        for (IConfigurationsChangeListener iConfigurationsChangeListener : this.listeners) {
            iConfigurationsChangeListener.configurationAdded(addConfigEvent);
        }
        return bl;
    }

    @Override
    public boolean addAll(Collection<? extends Configuration> collection) {
        boolean bl = false;
        for (Configuration configuration : collection) {
            bl = this.add(configuration);
        }
        return bl;
    }

    public void addConfigsChangeListener(IConfigurationsChangeListener iConfigurationsChangeListener) {
        this.listeners.add(iConfigurationsChangeListener);
    }

    public Configuration getActiveConfiguration() {
        for (Configuration configuration : this) {
            if (!configuration.isActive()) continue;
            return configuration;
        }
        return null;
    }

    private void populateConfigurations(Element element) throws PersistenceException {
        NodeList nodeList = element.getElementsByTagName(ELEM_CONFIGURATION);
        int n = 0;
        while (n < nodeList.getLength()) {
            Configuration configuration = new Configuration((Element)nodeList.item(n));
            this.add(configuration);
            ++n;
        }
    }

    @Override
    public boolean remove(Object object) {
        boolean bl = super.remove(object);
        if (!bl) {
            return bl;
        }
        if (object instanceof Configuration) {
            Configuration configuration = (Configuration)object;
            RemoveConfigEvent removeConfigEvent = new RemoveConfigEvent(this, configuration);
            for (IConfigurationsChangeListener iConfigurationsChangeListener : this.listeners) {
                iConfigurationsChangeListener.configurationRemoved(removeConfigEvent);
            }
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            bl = this.remove(obj);
        }
        return bl;
    }

    public void removeConfigsChangeListener(IConfigurationsChangeListener iConfigurationsChangeListener) {
        this.listeners.remove(iConfigurationsChangeListener);
    }

    public void switchActiveConfiguration(Configuration configuration) {
        Configuration configuration2 = this.getActiveConfiguration();
        if (configuration2 != null) {
            this.getActiveConfiguration().setActive(false);
        }
        configuration.setActive(true);
        SwitchActiveConfigEvent switchActiveConfigEvent = new SwitchActiveConfigEvent(this, configuration2, configuration);
        for (IConfigurationsChangeListener iConfigurationsChangeListener : this.listeners) {
            iConfigurationsChangeListener.activeConfigSwitched(switchActiveConfigEvent);
        }
    }
}

