/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.jmunit.ui.wizards.testcase;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.junit.wizards.NewTestCaseWizardPageOne;
import org.eclipse.jdt.junit.wizards.NewTestCaseWizardPageTwo;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mtj.core.internal.MTJCorePlugin;
import org.eclipse.mtj.core.library.manager.LibraryManager;
import org.eclipse.mtj.internal.jmunit.JMUnitMessages;
import org.eclipse.mtj.internal.jmunit.core.api.JMUnitTestFinder;
import org.eclipse.mtj.internal.jmunit.core.api.TestCaseWriter;
import org.eclipse.mtj.internal.jmunit.ui.part.MethodStubsSelectionButtonGroup;
import org.eclipse.mtj.internal.jmunit.util.JMUnitStatus;
import org.eclipse.mtj.internal.jmunit.util.LayoutUtil;
import org.eclipse.mtj.jmunit.JMUnitPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class NewJMUnitTestCasePageOne
extends NewTestCaseWizardPageOne {
    private static final int IDX_SETUP = 0;
    private static final int IDX_TEARDOWN = 1;
    private static final String STORE_SETUP = "NewTestCaseCreationWizardPage.USE_SETUP";
    private static final String STORE_TEARDOWN = "NewTestCaseCreationWizardPage.USE_TEARDOWN";
    private Label fImage;
    private boolean fIsJMunitCLDC11;
    private boolean fIsJMunitCLDC11Enabled;
    private IStatus fJMunitCLDC11Status;
    private Button fJMUnitToggle;
    private Link fLink;
    private MethodStubsSelectionButtonGroup fMethodStubsButtons;
    private NewTestCaseWizardPageTwo page2;

    public NewJMUnitTestCasePageOne(NewTestCaseWizardPageTwo newTestCaseWizardPageTwo) {
        super(newTestCaseWizardPageTwo);
        this.page2 = newTestCaseWizardPageTwo;
        this.setTitle(JMUnitMessages.NewJMUnitTestCasePageOne_title);
        this.setDescription(JMUnitMessages.NewJMUnitTestCasePageOne_description);
        String[] stringArray = new String[]{"set&Up()", "&tearDown()"};
        this.fMethodStubsButtons = new MethodStubsSelectionButtonGroup(32, stringArray, 3);
        this.fMethodStubsButtons.setLabelText(JMUnitMessages.NewJMUnitTestCasePageOne_methodStubs_label);
        this.enableCommentControl(true);
        this.fJMunitCLDC11Status = new JMUnitStatus();
        this.fIsJMunitCLDC11 = false;
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        int n = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        composite2.setLayout((Layout)gridLayout);
        this.createJMUnitCLDC11Controls(composite2, n);
        this.createContainerControls(composite2, n);
        this.createPackageControls(composite2, n);
        this.createSeparator(composite2, n);
        this.createTypeNameControls(composite2, n);
        this.createSuperClassControls(composite2, n);
        this.createMethodStubSelectionControls(composite2, n);
        this.createCommentControls(composite2, n);
        this.createSeparator(composite2, n);
        this.createClassUnderTestControls(composite2, n);
        this.createBuildPathConfigureControls(composite2, n);
        this.setControl((Control)composite2);
        String string = this.getClassUnderTestText();
        if (string.length() > 0) {
            this.setTypeName(String.valueOf(Signature.getSimpleName((String)string)) + "Test", true);
        }
        Dialog.applyDialogFont((Control)composite2);
        this.setFocus();
    }

    public void init(IStructuredSelection iStructuredSelection) {
        super.init(iStructuredSelection);
        this.restoreWidgetValues();
        IJavaElement iJavaElement = this.getInitialJavaElement(iStructuredSelection);
        boolean bl = false;
        if (iJavaElement != null && iJavaElement.getElementType() != 1) {
            IJavaProject iJavaProject = iJavaElement.getJavaProject();
            try {
                bl = iJavaProject.findType("jmunit.framework.cldc11.TestCase") != null;
            }
            catch (JavaModelException javaModelException) {}
        }
        this.setJMUnit11(bl, true);
        this.updateStatus(this.getStatusList());
    }

    public boolean isJMUnit11() {
        return this.fIsJMunitCLDC11;
    }

    public void setJMUnit11(boolean bl, boolean bl2) {
        this.fIsJMunitCLDC11Enabled = bl2;
        if (this.fJMUnitToggle != null && !this.fJMUnitToggle.isDisposed()) {
            this.fJMUnitToggle.setSelection(bl);
            this.fJMUnitToggle.setEnabled(bl2);
        }
        this.internalSetJMUnit(bl);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) {
            this.saveWidgetValues();
        }
    }

    private void createJMUnitCLDC11Controls(Composite composite, int n) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 0x1000000, false, false, n, 1));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = ((Button)selectionEvent.widget).getSelection();
                NewJMUnitTestCasePageOne.this.internalSetJMUnit(bl);
            }
        };
        Button button = new Button(composite2, 16);
        button.setText(JMUnitMessages.NewJMUnitTestCasePageOne_jmunit10Toggle_label);
        button.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        button.setSelection(!this.fIsJMunitCLDC11);
        button.setEnabled(this.fIsJMunitCLDC11Enabled);
        this.fJMUnitToggle = new Button(composite2, 16);
        this.fJMUnitToggle.setText(JMUnitMessages.NewJMUnitTestCasePageOne_jmunit11Toggle_label);
        this.fJMUnitToggle.setSelection(this.fIsJMunitCLDC11);
        this.fJMUnitToggle.setEnabled(this.fIsJMunitCLDC11Enabled);
        this.fJMUnitToggle.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        this.fJMUnitToggle.addSelectionListener((SelectionListener)selectionAdapter);
    }

    private void internalSetJMUnit(boolean bl) {
        this.fIsJMunitCLDC11 = bl;
        this.fJMunitCLDC11Status = this.jmunitChanged();
        if (this.fIsJMunitCLDC11) {
            this.setSuperClass("jmunit.framework.cldc11.TestCase", true);
        } else {
            this.setSuperClass("jmunit.framework.cldc10.TestCase", true);
        }
        this.handleFieldChanged("NewContainerWizardPage.container");
    }

    private IStatus jmunitChanged() {
        JMUnitStatus jMUnitStatus = new JMUnitStatus();
        return jMUnitStatus;
    }

    private void performBuildpathConfiguration(Object object) {
        IPackageFragmentRoot iPackageFragmentRoot = this.getPackageFragmentRoot();
        if (iPackageFragmentRoot == null) {
            return;
        }
        IJavaProject iJavaProject = iPackageFragmentRoot.getJavaProject();
        if ("cldc10".equals(object)) {
            try {
                LibraryManager.getInstance().addLibraryToMidletProject(iJavaProject.getProject(), "JMUnit for CLDC 1.0");
            }
            catch (CoreException coreException) {
                MTJCorePlugin.log((int)4, (Throwable)coreException);
            }
        } else if ("cldc11".equals(object)) {
            try {
                LibraryManager.getInstance().addLibraryToMidletProject(iJavaProject.getProject(), "JMUnit for CLDC 1.1");
            }
            catch (CoreException coreException) {
                MTJCorePlugin.log((int)4, (Throwable)coreException);
            }
        }
        this.handleFieldChanged("NewContainerWizardPage.container");
        this.updateBuildPathMessage();
    }

    private IType resolveClassNameToType(IJavaProject iJavaProject, IPackageFragment iPackageFragment, String string) throws JavaModelException {
        IType iType = iJavaProject.findType(string);
        if (iType == null && iPackageFragment != null && !iPackageFragment.isDefaultPackage()) {
            iType = iJavaProject.findType(iPackageFragment.getElementName(), string);
        }
        if (iType == null) {
            iType = iJavaProject.findType("java.lang", string);
        }
        return iType;
    }

    private void restoreWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            this.fMethodStubsButtons.setSelection(0, iDialogSettings.getBoolean(STORE_SETUP));
            this.fMethodStubsButtons.setSelection(1, iDialogSettings.getBoolean(STORE_TEARDOWN));
        } else {
            this.fMethodStubsButtons.setSelection(0, false);
            this.fMethodStubsButtons.setSelection(1, false);
        }
    }

    private void saveWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            iDialogSettings.put(STORE_SETUP, this.fMethodStubsButtons.isSelected(0));
            iDialogSettings.put(STORE_TEARDOWN, this.fMethodStubsButtons.isSelected(1));
        }
    }

    private void updateBuildPathMessage() {
        if (this.fLink == null || this.fLink.isDisposed()) {
            return;
        }
        String string = null;
        IPackageFragmentRoot iPackageFragmentRoot = this.getPackageFragmentRoot();
        if (iPackageFragmentRoot != null) {
            try {
                IJavaProject iJavaProject = iPackageFragmentRoot.getJavaProject();
                if (iJavaProject.exists()) {
                    if (this.isJMUnit11()) {
                        if (iJavaProject.findType("jmunit.framework.cldc11.TestCase") == null) {
                            string = NLS.bind((String)JMUnitMessages.NewJMUnitTestCasePageOne_jmunit_cldc11_not_in_classpath, (Object)iJavaProject.getElementName());
                        }
                    } else if (iJavaProject.findType("jmunit.framework.cldc10.TestCase") == null) {
                        string = NLS.bind((String)JMUnitMessages.NewJMUnitTestCasePageOne_jmunit_cldc10_not_in_classpath, (Object)iJavaProject.getElementName());
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        this.fLink.setVisible(string != null);
        this.fImage.setVisible(string != null);
        if (string != null) {
            this.fLink.setText(string);
        }
    }

    protected void createBuildPathConfigureControls(Composite composite, int n) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 4, false, false, n, 1));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        this.fImage = new Label(composite2, 0);
        this.fImage.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
        this.fImage.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        this.fLink = new Link(composite2, 64);
        this.fLink.setText("\n\n");
        this.fLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewJMUnitTestCasePageOne.this.performBuildpathConfiguration(selectionEvent.text);
            }
        });
        GridData gridData = new GridData(4, 1, true, false, 1, 1);
        gridData.widthHint = this.convertWidthInCharsToPixels(60);
        this.fLink.setLayoutData((Object)gridData);
        this.updateBuildPathMessage();
    }

    protected void createMethodStubSelectionControls(Composite composite, int n) {
        LayoutUtil.setHorizontalSpan((Control)this.fMethodStubsButtons.getLabelControl(composite), n);
        LayoutUtil.createEmptySpace(composite, 1);
        LayoutUtil.setHorizontalSpan((Control)this.fMethodStubsButtons.getSelectionButtonsGroup(composite), n - 1);
    }

    protected void createTypeMembers(IType iType, NewTypeWizardPage.ImportsManager importsManager, IProgressMonitor iProgressMonitor) throws CoreException {
        TestCaseWriter testCaseWriter = new TestCaseWriter(iType, iType.getElementName());
        boolean bl = this.isAddComments();
        boolean bl2 = this.fMethodStubsButtons.isSelected(1);
        boolean bl3 = this.fMethodStubsButtons.isSelected(0);
        boolean bl4 = this.page2.getCreateFinalMethodStubsButtonSelection();
        boolean bl5 = this.page2.isCreateTasks();
        testCaseWriter.writeCode(this.page2.getCheckedMethods(), bl3, bl2, bl, bl5, bl4, iProgressMonitor);
    }

    protected IStatus[] getStatusList() {
        ArrayList<IStatus> arrayList = new ArrayList<IStatus>();
        IStatus[] iStatusArray = super.getStatusList();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus iStatus = iStatusArray[n2];
            arrayList.add(iStatus);
            ++n2;
        }
        arrayList.add(this.fJMunitCLDC11Status);
        return arrayList.toArray(new IStatus[0]);
    }

    protected IStatus superClassChanged() {
        String string = this.getSuperClass();
        JMUnitStatus jMUnitStatus = new JMUnitStatus();
        if (string == null || string.trim().equals("")) {
            jMUnitStatus = JMUnitStatus.createError(JMUnitMessages.NewJMUnitTestCasePageOne_empty_superclass);
            return jMUnitStatus;
        }
        if (this.getPackageFragmentRoot() != null) {
            try {
                IType iType = this.resolveClassNameToType(this.getPackageFragmentRoot().getJavaProject(), this.getPackageFragment(), string);
                if (iType == null) {
                    jMUnitStatus = JMUnitStatus.createError(JMUnitMessages.NewJMUnitTestCasePageOne_missing_superclass);
                    return jMUnitStatus;
                }
                if (iType.isInterface()) {
                    jMUnitStatus = JMUnitStatus.createError(JMUnitMessages.NewJMUnitTestCasePageOne_interface_as_superclass);
                    return jMUnitStatus;
                }
                if (!new JMUnitTestFinder(this.isJMUnit11() ? "jmunit.framework.cldc11.TestCase" : "jmunit.framework.cldc10.TestCase").isTestImplementor(iType)) {
                    jMUnitStatus = JMUnitStatus.createError(String.valueOf(JMUnitMessages.NewJMUnitTestCasePageOne_superclass_not_text_impl) + (this.isJMUnit11() ? "jmunit.framework.cldc11.TestCase" : "jmunit.framework.cldc10.TestCase"));
                    return jMUnitStatus;
                }
            }
            catch (JavaModelException javaModelException) {
                JMUnitPlugin.log(javaModelException.getStatus());
            }
        }
        return jMUnitStatus;
    }

    protected void handleFieldChanged(String string) {
        super.handleFieldChanged(string);
        this.updateBuildPathMessage();
    }
}

