/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.jmunit.ui.wizards.testsuite;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.junit.wizards.NewTestSuiteWizardPage;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mtj.internal.jmunit.JMUnitMessages;
import org.eclipse.mtj.internal.jmunit.core.api.TestSuiteWriter;
import org.eclipse.mtj.internal.jmunit.ui.wizards.testsuite.SuiteClassesContentProvider;
import org.eclipse.mtj.internal.jmunit.util.JMUnitStatus;
import org.eclipse.mtj.internal.jmunit.util.LayoutUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class NewJMUnitTestSuiteWizardPageOne
extends NewTestSuiteWizardPage {
    private static final String PAGE_NAME = "NewJMUnitTestSuiteWizardPageOne";
    public static final String CLASSES_IN_SUITE = "NewJMUnitTestSuiteWizardPageOne.classesinsuite";
    private static final String ALL_TESTS = "AllTestSuite";
    private IStatus fClassesInSuiteStatus;
    private CheckboxTableViewer fClassesInSuiteTable;
    private Label fSelectedClassesLabel;
    private boolean fUpdatedExistingClassButton;
    private boolean fIsJMUnit11;
    private SuiteClassesContentProvider provider;

    public NewJMUnitTestSuiteWizardPageOne() {
        this.setTitle(JMUnitMessages.NewJMUnitTestSuiteWizardPageOne_title);
        this.setDescription(JMUnitMessages.NewJMUnitTestSuiteWizardPageOne_description);
        this.fClassesInSuiteStatus = new JMUnitStatus();
        this.fIsJMUnit11 = false;
        this.provider = new SuiteClassesContentProvider("jmunit.framework.cldc10.TestCase");
    }

    public String getSuperClass() {
        return this.fIsJMUnit11 ? "jmunit.framework.cldc11.TestSuite" : "jmunit.framework.cldc10.TestSuite";
    }

    public boolean hasUpdatedExistingClass() {
        return this.fUpdatedExistingClassButton;
    }

    public void init(IStructuredSelection iStructuredSelection) {
        super.init(iStructuredSelection);
        this.setTypeName(ALL_TESTS, true);
        this.fTypeNameStatus = this.typeNameChanged();
    }

    private IStatus classesInSuiteChanged() {
        JMUnitStatus jMUnitStatus = new JMUnitStatus();
        if (this.fClassesInSuiteTable.getCheckedElements().length <= 0) {
            jMUnitStatus.setWarning(JMUnitMessages.NewJMUnitTestSuiteWizardPageOne_no_test_classes_selected);
        }
        return jMUnitStatus;
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        int n = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        composite2.setLayout((Layout)gridLayout);
        this.createJMUnitCLDC11Controls(composite2, n);
        this.createSeparator(composite2, n);
        this.createContainerControls(composite2, n);
        this.createPackageControls(composite2, n);
        this.createTypeNameControls(composite2, n);
        this.createClassesInSuiteControl(composite2, n);
        this.createMethodStubSelectionControls(composite2, n);
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
    }

    private void createJMUnitCLDC11Controls(Composite composite, int n) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(4, 0x1000000, false, false, n, 1));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewJMUnitTestSuiteWizardPageOne.this.fIsJMUnit11 = ((Button)selectionEvent.widget).getSelection();
                NewJMUnitTestSuiteWizardPageOne.this.provider.setSuperclass(NewJMUnitTestSuiteWizardPageOne.this.fIsJMUnit11 ? "jmunit.framework.cldc11.TestCase" : "jmunit.framework.cldc10.TestCase");
                NewJMUnitTestSuiteWizardPageOne.this.fClassesInSuiteTable.refresh(true);
            }
        };
        Button button = new Button(composite2, 16);
        button.setText(JMUnitMessages.NewJMUnitTestSuiteWizardPageOne_jmunit10Toggle_label);
        button.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        button.setSelection(true);
        button.setEnabled(true);
        Button button2 = new Button(composite2, 16);
        button2.setText(JMUnitMessages.NewJMUnitTestSuiteWizardPageOne_jmunit11Toggle_label);
        button2.setSelection(false);
        button2.setEnabled(true);
        button2.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        button2.addSelectionListener((SelectionListener)selectionAdapter);
    }

    private void doStatusUpdate() {
        IStatus[] iStatusArray = new IStatus[]{this.fContainerStatus, this.fPackageStatus, this.fTypeNameStatus, this.fClassesInSuiteStatus};
        this.updateStatus(iStatusArray);
    }

    private void updateSelectedClassesLabel() {
        int n = this.fClassesInSuiteTable.getCheckedElements().length;
        String string = n == 1 ? JMUnitMessages.NewJMUnitTestSuiteWizardPageOne_class_selected : JMUnitMessages.NewJMUnitTestSuiteWizardPageOne_classes_selected;
        this.fSelectedClassesLabel.setText(NLS.bind((String)string, (Object)new Integer(n)));
    }

    protected void createClassesInSuiteControl(Composite composite, int n) {
        if (this.fClassesInSuiteTable == null) {
            Label label = new Label(composite, 16384);
            label.setText(JMUnitMessages.NewJMUnitTestSuiteWizardPageOne_createClassesInSuiteControl_label);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.horizontalSpan = n;
            label.setLayoutData((Object)gridData);
            this.fClassesInSuiteTable = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
            gridData = new GridData(1808);
            gridData.heightHint = 80;
            gridData.horizontalSpan = n - 1;
            this.fClassesInSuiteTable.getTable().setLayoutData((Object)gridData);
            this.fClassesInSuiteTable.setContentProvider((IContentProvider)this.provider);
            this.fClassesInSuiteTable.setLabelProvider((IBaseLabelProvider)new JavaElementLabelProvider());
            this.fClassesInSuiteTable.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                    NewJMUnitTestSuiteWizardPageOne.this.handleFieldChanged(NewJMUnitTestSuiteWizardPageOne.CLASSES_IN_SUITE);
                }
            });
            Composite composite2 = new Composite(composite, 0);
            gridData = new GridData(1040);
            composite2.setLayoutData((Object)gridData);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            composite2.setLayout((Layout)gridLayout);
            Button button = new Button(composite2, 8);
            button.setText(JMUnitMessages.NewJMUnitTestSuiteWizardPageOne_select_all);
            GridData gridData2 = new GridData(770);
            gridData2.widthHint = LayoutUtil.getButtonWidthHint(button);
            button.setLayoutData((Object)gridData2);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    NewJMUnitTestSuiteWizardPageOne.this.fClassesInSuiteTable.setAllChecked(true);
                    NewJMUnitTestSuiteWizardPageOne.this.handleFieldChanged(NewJMUnitTestSuiteWizardPageOne.CLASSES_IN_SUITE);
                }
            });
            Button button2 = new Button(composite2, 8);
            button2.setText(JMUnitMessages.NewJMUnitTestSuiteWizardPageOne_deselect_all);
            gridData2 = new GridData(770);
            gridData2.widthHint = LayoutUtil.getButtonWidthHint(button2);
            button2.setLayoutData((Object)gridData2);
            button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    NewJMUnitTestSuiteWizardPageOne.this.fClassesInSuiteTable.setAllChecked(false);
                    NewJMUnitTestSuiteWizardPageOne.this.handleFieldChanged(NewJMUnitTestSuiteWizardPageOne.CLASSES_IN_SUITE);
                }
            });
            this.fSelectedClassesLabel = new Label(composite, 16448);
            this.fSelectedClassesLabel.setFont(composite.getFont());
            this.updateSelectedClassesLabel();
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            this.fSelectedClassesLabel.setLayoutData((Object)gridData);
        }
    }

    protected void createTypeMembers(IType iType, NewTypeWizardPage.ImportsManager importsManager, IProgressMonitor iProgressMonitor) throws CoreException {
        Object[] objectArray = this.fClassesInSuiteTable.getCheckedElements();
        String[] stringArray = new String[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            IType iType2 = (IType)objectArray[n];
            importsManager.addImport(iType2.getFullyQualifiedName());
            stringArray[n] = iType2.getElementName();
            ++n;
        }
        TestSuiteWriter testSuiteWriter = new TestSuiteWriter(iType, iType.getElementName());
        testSuiteWriter.writeCode(stringArray, iProgressMonitor);
    }

    protected void handleFieldChanged(String string) {
        if (string.equals("NewTypeWizardPage.package") || string.equals("NewContainerWizardPage.container")) {
            this.updateClassesInSuiteTable();
        } else if (string.equals(CLASSES_IN_SUITE)) {
            this.fClassesInSuiteStatus = this.classesInSuiteChanged();
            this.fTypeNameStatus = this.typeNameChanged();
            this.updateSelectedClassesLabel();
        }
        this.doStatusUpdate();
    }

    protected void updateClassesInSuiteTable() {
        if (this.fClassesInSuiteTable != null) {
            IPackageFragment iPackageFragment = this.getPackageFragment();
            if (iPackageFragment == null) {
                IPackageFragmentRoot iPackageFragmentRoot = this.getPackageFragmentRoot();
                if (iPackageFragmentRoot != null) {
                    iPackageFragment = iPackageFragmentRoot.getPackageFragment("");
                } else {
                    return;
                }
            }
            this.fClassesInSuiteTable.setInput((Object)iPackageFragment);
            this.fClassesInSuiteTable.setAllChecked(true);
            this.updateSelectedClassesLabel();
        }
    }
}

